/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.tasks;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.phases.util.Providers;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoBackend;
import uk.ac.manchester.tornado.api.TornadoRuntime;
import uk.ac.manchester.tornado.api.TornadoTaskGraphInterface;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.common.PrebuiltTaskPackage;
import uk.ac.manchester.tornado.api.common.SchedulableTask;
import uk.ac.manchester.tornado.api.common.TaskPackage;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.common.TornadoFunctions;
import uk.ac.manchester.tornado.api.enums.ProfilerMode;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoBailoutRuntimeException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.exceptions.TornadoTaskRuntimeException;
import uk.ac.manchester.tornado.api.memory.DeviceBufferState;
import uk.ac.manchester.tornado.api.profiler.ProfilerType;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.api.runtime.ExecutorFrame;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.TornadoVM;
import uk.ac.manchester.tornado.runtime.analyzer.MetaReduceCodeAnalysis;
import uk.ac.manchester.tornado.runtime.analyzer.ReduceCodeAnalysis;
import uk.ac.manchester.tornado.runtime.analyzer.TaskUtils;
import uk.ac.manchester.tornado.runtime.common.BatchConfiguration;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.common.TornadoVMClient;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.common.XPUDeviceBufferState;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoSuitesProvider;
import uk.ac.manchester.tornado.runtime.graph.TornadoExecutionContext;
import uk.ac.manchester.tornado.runtime.graph.TornadoGraph;
import uk.ac.manchester.tornado.runtime.graph.TornadoGraphBuilder;
import uk.ac.manchester.tornado.runtime.graph.TornadoVMBytecodeBuilder;
import uk.ac.manchester.tornado.runtime.profiler.EmptyProfiler;
import uk.ac.manchester.tornado.runtime.profiler.TimeProfiler;
import uk.ac.manchester.tornado.runtime.sketcher.Sketch;
import uk.ac.manchester.tornado.runtime.sketcher.SketchRequest;
import uk.ac.manchester.tornado.runtime.sketcher.TornadoSketcher;
import uk.ac.manchester.tornado.runtime.tasks.CompilableTask;
import uk.ac.manchester.tornado.runtime.tasks.DataObjectState;
import uk.ac.manchester.tornado.runtime.tasks.LocalObjectState;
import uk.ac.manchester.tornado.runtime.tasks.PrebuiltTask;
import uk.ac.manchester.tornado.runtime.tasks.ReduceTaskGraph;
import uk.ac.manchester.tornado.runtime.tasks.StreamingObject;
import uk.ac.manchester.tornado.runtime.tasks.TornadoGraphBitcodes;
import uk.ac.manchester.tornado.runtime.tasks.meta.ScheduleContext;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class TornadoTaskGraph
implements TornadoTaskGraphInterface {
    public static final String GENERATED_TASK_GRAPH_PREFIX = "__GENERATED_TASK_GRAPH__";
    private static final String RESET = "\u001b[0m";
    private static final String RED = "\u001b[31m";
    private static final String WARNING_DEOPT_MESSAGE = "\u001b[31mWARNING: Code Bailout to Java sequential. Use --debug to see the reason\u001b[0m";
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)(MB|mg|gb|GB)");
    private static final CompileInfo COMPILE_ONLY = new CompileInfo(true, false);
    private static final CompileInfo COMPILE_AND_UPDATE = new CompileInfo(true, true);
    private static final CompileInfo NOT_COMPILE_UPDATE = new CompileInfo(false, false);
    private MetaReduceCodeAnalysis analysisTaskGraph;
    private TornadoExecutionContext executionContext;
    private byte[] highLevelCode = new byte[8192];
    private ByteBuffer hlBuffer;
    private TornadoVMBytecodeBuilder bytecodeBuilder;
    private long batchSizeBytes = -1L;
    private long memoryLimitSizeBytes = -1L;
    private TornadoVM vm;
    private Map<TornadoXPUDevice, TornadoVM> vmTable;
    private Event event;
    private String taskGraphName;
    private List<TaskPackage> taskPackages;
    private List<Object> streamOutObjects;
    private List<Object> streamInObjects;
    private Map<TornadoTaskGraph, List<Object>> taskToPersistentObjectMap;
    private TornadoTaskGraphInterface lastExecutedTaskGraph;
    private Set<Object> argumentsLookUp;
    private List<StreamingObject> inputModesObjects;
    private List<StreamingObject> outputModeObjects;
    private StringBuilder bufferLogProfiler = new StringBuilder();
    private Graph compilationGraph;
    private boolean reduceExpressionRewritten = false;
    private ReduceTaskGraph reduceTaskGraph;
    private boolean reduceAnalysis = false;
    private TornadoProfiler timeProfiler;
    private boolean updateData;
    private boolean isFinished;
    private GridScheduler gridScheduler;
    private ProfilerMode profilerMode;
    private boolean isConcurrentDevicesEnabled;
    private long executionPlanId;
    private boolean bailout;
    private Access[] accesses;

    public TornadoTaskGraph(String taskScheduleName) {
        this.executionContext = new TornadoExecutionContext(taskScheduleName);
        this.hlBuffer = ByteBuffer.wrap(this.highLevelCode);
        this.hlBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.hlBuffer.rewind();
        this.bytecodeBuilder = null;
        this.event = null;
        this.taskGraphName = taskScheduleName;
        this.vmTable = new HashMap<TornadoXPUDevice, TornadoVM>();
        this.argumentsLookUp = new HashSet<Object>();
        this.taskPackages = new ArrayList<TaskPackage>();
        this.streamOutObjects = new ArrayList<Object>();
        this.streamInObjects = new ArrayList<Object>();
        this.inputModesObjects = new ArrayList<StreamingObject>();
        this.outputModeObjects = new ArrayList<StreamingObject>();
        this.taskToPersistentObjectMap = new HashMap<TornadoTaskGraph, List<Object>>();
    }

    static void performStreamInObject(TaskGraph task, Object inputObject, int dataTransferMode) {
        task.transferToDevice(dataTransferMode, new Object[]{inputObject});
    }

    static void performStreamInObject(TaskGraph task, List<Object> inputObjects, int dataTransferMode) {
        int numObjectsCopyIn = inputObjects.size();
        switch (numObjectsCopyIn) {
            case 0: {
                break;
            }
            case 1: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.getFirst()});
                break;
            }
            case 2: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1)});
                break;
            }
            case 3: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2)});
                break;
            }
            case 4: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2), inputObjects.get(3)});
                break;
            }
            case 5: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2), inputObjects.get(3), inputObjects.get(4)});
                break;
            }
            case 6: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2), inputObjects.get(3), inputObjects.get(4), inputObjects.get(5)});
                break;
            }
            case 7: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2), inputObjects.get(3), inputObjects.get(4), inputObjects.get(5), inputObjects.get(6)});
                break;
            }
            case 8: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2), inputObjects.get(3), inputObjects.get(4), inputObjects.get(5), inputObjects.get(6), inputObjects.get(7)});
                break;
            }
            case 9: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2), inputObjects.get(3), inputObjects.get(4), inputObjects.get(5), inputObjects.get(6), inputObjects.get(7), inputObjects.get(8)});
                break;
            }
            case 10: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2), inputObjects.get(3), inputObjects.get(4), inputObjects.get(5), inputObjects.get(6), inputObjects.get(7), inputObjects.get(8), inputObjects.get(9)});
                break;
            }
            case 11: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2), inputObjects.get(3), inputObjects.get(4), inputObjects.get(5), inputObjects.get(6), inputObjects.get(7), inputObjects.get(8), inputObjects.get(9), inputObjects.get(10)});
                break;
            }
            case 12: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2), inputObjects.get(3), inputObjects.get(4), inputObjects.get(5), inputObjects.get(6), inputObjects.get(7), inputObjects.get(8), inputObjects.get(9), inputObjects.get(10), inputObjects.get(11)});
                break;
            }
            case 13: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2), inputObjects.get(3), inputObjects.get(4), inputObjects.get(5), inputObjects.get(6), inputObjects.get(7), inputObjects.get(8), inputObjects.get(9), inputObjects.get(10), inputObjects.get(11), inputObjects.get(12)});
                break;
            }
            case 14: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2), inputObjects.get(3), inputObjects.get(4), inputObjects.get(5), inputObjects.get(6), inputObjects.get(7), inputObjects.get(8), inputObjects.get(9), inputObjects.get(10), inputObjects.get(11), inputObjects.get(12), inputObjects.get(13)});
                break;
            }
            case 15: {
                task.transferToDevice(dataTransferMode, new Object[]{inputObjects.get(0), inputObjects.get(1), inputObjects.get(2), inputObjects.get(3), inputObjects.get(4), inputObjects.get(5), inputObjects.get(6), inputObjects.get(7), inputObjects.get(8), inputObjects.get(9), inputObjects.get(10), inputObjects.get(11), inputObjects.get(12), inputObjects.get(13), inputObjects.get(14)});
                break;
            }
            default: {
                System.out.println("COPY-IN Not supported yet: " + numObjectsCopyIn);
            }
        }
    }

    static void performStreamOutThreads(int mode, TaskGraph task, Object outputObject) {
        task.transferToHost(mode, new Object[]{outputObject});
    }

    static void performStreamOutThreads(int mode, TaskGraph task, List<Object> outputArrays) {
        int numObjectsCopyOut = outputArrays.size();
        switch (numObjectsCopyOut) {
            case 0: {
                break;
            }
            case 1: {
                task.transferToHost(mode, new Object[]{outputArrays.getFirst()});
                break;
            }
            case 2: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1)});
                break;
            }
            case 3: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2)});
                break;
            }
            case 4: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2), outputArrays.get(3)});
                break;
            }
            case 5: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2), outputArrays.get(3), outputArrays.get(4)});
                break;
            }
            case 6: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2), outputArrays.get(3), outputArrays.get(4), outputArrays.get(5)});
                break;
            }
            case 7: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2), outputArrays.get(3), outputArrays.get(4), outputArrays.get(5), outputArrays.get(6)});
                break;
            }
            case 8: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2), outputArrays.get(3), outputArrays.get(4), outputArrays.get(5), outputArrays.get(6), outputArrays.get(7)});
                break;
            }
            case 9: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2), outputArrays.get(3), outputArrays.get(4), outputArrays.get(5), outputArrays.get(6), outputArrays.get(7), outputArrays.get(8)});
                break;
            }
            case 10: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2), outputArrays.get(3), outputArrays.get(4), outputArrays.get(5), outputArrays.get(6), outputArrays.get(7), outputArrays.get(8), outputArrays.get(9)});
                break;
            }
            case 11: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2), outputArrays.get(3), outputArrays.get(4), outputArrays.get(5), outputArrays.get(6), outputArrays.get(7), outputArrays.get(8), outputArrays.get(9), outputArrays.get(10)});
                break;
            }
            case 12: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2), outputArrays.get(3), outputArrays.get(4), outputArrays.get(5), outputArrays.get(6), outputArrays.get(7), outputArrays.get(8), outputArrays.get(9), outputArrays.get(10), outputArrays.get(11)});
                break;
            }
            case 13: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2), outputArrays.get(3), outputArrays.get(4), outputArrays.get(5), outputArrays.get(6), outputArrays.get(7), outputArrays.get(8), outputArrays.get(9), outputArrays.get(10), outputArrays.get(11), outputArrays.get(12)});
                break;
            }
            case 14: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2), outputArrays.get(3), outputArrays.get(4), outputArrays.get(5), outputArrays.get(6), outputArrays.get(7), outputArrays.get(8), outputArrays.get(9), outputArrays.get(10), outputArrays.get(11), outputArrays.get(12), outputArrays.get(13)});
                break;
            }
            case 15: {
                task.transferToHost(mode, new Object[]{outputArrays.get(0), outputArrays.get(1), outputArrays.get(2), outputArrays.get(3), outputArrays.get(4), outputArrays.get(5), outputArrays.get(6), outputArrays.get(7), outputArrays.get(8), outputArrays.get(9), outputArrays.get(10), outputArrays.get(11), outputArrays.get(12), outputArrays.get(13), outputArrays.get(14)});
                break;
            }
            default: {
                System.out.println("COPY-OUT Not supported yet: " + numObjectsCopyOut);
            }
        }
    }

    public String getTaskGraphName() {
        return this.taskGraphName;
    }

    public void useDefaultThreadScheduler(boolean use) {
        this.executionContext.setDefaultThreadScheduler(use);
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public Set<Object> getArgumentsLookup() {
        return this.argumentsLookUp;
    }

    public TornadoTaskGraph createImmutableTaskGraph() {
        TornadoTaskGraph newTaskGraph = new TornadoTaskGraph(this.taskGraphName);
        newTaskGraph.accesses = this.accesses;
        newTaskGraph.inputModesObjects = Collections.unmodifiableList(this.inputModesObjects);
        newTaskGraph.streamInObjects = Collections.unmodifiableList(this.streamInObjects);
        newTaskGraph.outputModeObjects = Collections.unmodifiableList(this.outputModeObjects);
        newTaskGraph.taskToPersistentObjectMap = Collections.unmodifiableMap(this.taskToPersistentObjectMap);
        newTaskGraph.lastExecutedTaskGraph = this.lastExecutedTaskGraph;
        newTaskGraph.streamOutObjects = Collections.unmodifiableList(this.streamOutObjects);
        newTaskGraph.hlBuffer = this.hlBuffer;
        newTaskGraph.executionContext = this.executionContext.clone();
        newTaskGraph.taskPackages = Collections.unmodifiableList(this.taskPackages);
        newTaskGraph.argumentsLookUp = Collections.unmodifiableSet(this.argumentsLookUp);
        newTaskGraph.reduceTaskGraph = this.reduceTaskGraph;
        newTaskGraph.analysisTaskGraph = this.analysisTaskGraph;
        newTaskGraph.highLevelCode = this.highLevelCode;
        newTaskGraph.timeProfiler = this.timeProfiler;
        newTaskGraph.gridScheduler = this.gridScheduler;
        newTaskGraph.executionContext.withProfiler(this.timeProfiler);
        newTaskGraph.compilationGraph = this.compilationGraph;
        return newTaskGraph;
    }

    public void enableProfiler(ProfilerMode profilerMode) {
        this.profilerMode = profilerMode;
        TornadoOptions.TORNADO_PROFILER = true;
        if (profilerMode == ProfilerMode.SILENT) {
            TornadoOptions.TORNADO_PROFILER_LOG = true;
        }
    }

    public Collection<?> getOutputs() {
        return this.streamOutObjects;
    }

    public void disableProfiler() {
        TornadoOptions.TORNADO_PROFILER = false;
        TornadoOptions.TORNADO_PROFILER_LOG = false;
        this.timeProfiler = null;
        this.profilerMode = null;
    }

    public void withConcurrentDevices() {
        this.isConcurrentDevicesEnabled = true;
    }

    public void withoutConcurrentDevices() {
        this.isConcurrentDevicesEnabled = false;
    }

    public void withThreadInfo() {
        this.meta().enableThreadInfo();
    }

    public void withoutThreadInfo() {
        this.meta().disableThreadInfo();
    }

    public void withPrintKernel() {
        this.meta().enablePrintKernel();
    }

    public void withoutPrintKernel() {
        this.meta().disablePrintKernel();
    }

    public void withGridScheduler(GridScheduler gridScheduler) {
        this.gridScheduler = gridScheduler;
        this.checkGridSchedulerNames();
    }

    public long getCurrentDeviceMemoryUsage() {
        return this.executionContext.getCurrentDeviceMemoryUsage();
    }

    public Map<String, List<Object>> getPersistedTaskToObjectsMap() {
        return this.executionContext.getPersistedTaskToObjectsMap();
    }

    public void withCompilerFlags(TornadoVMBackendType backendType, String compilerFlags) {
        this.executionContext.meta().setCompilerFlags(backendType, compilerFlags);
    }

    public void mapOnDeviceMemoryRegion(Object destArray, Object srcArray, long offset, TornadoTaskGraphInterface taskGraphSrc) {
        TornadoTaskGraph graphSrc = (TornadoTaskGraph)taskGraphSrc;
        Access objectAccessSrc = graphSrc.getObjectAccess(srcArray);
        LocalObjectState localStateSrc = graphSrc.executionContext.getLocalStateObject(srcArray, objectAccessSrc);
        DataObjectState dataObjectStateSrc = localStateSrc.getDataObjectState();
        TornadoXPUDevice device = graphSrc.meta().getXPUDevice();
        XPUDeviceBufferState deviceStateSrc = dataObjectStateSrc.getDeviceBufferState(device);
        Access objectAccessDest = this.getObjectAccess(destArray);
        LocalObjectState localStateDest = this.executionContext.getLocalStateObject(destArray, objectAccessDest);
        DataObjectState dataObjectStateDest = localStateDest.getDataObjectState();
        XPUDeviceBufferState deviceStateDest = dataObjectStateDest.getDeviceBufferState(device);
        if (!deviceStateDest.hasObjectBuffer()) {
            device.allocate(destArray, 0L, deviceStateDest, objectAccessDest);
        }
        TornadoXPUDevice deviceDest = this.meta().getXPUDevice();
        deviceDest.mapDeviceRegion(this.executionPlanId, destArray, srcArray, deviceStateSrc, deviceStateDest, offset);
    }

    public void updateObjectAccess() {
        Object streamOutObject;
        Access currentAccess;
        HashMap<Object, Access> objectAccesses = this.executionContext.getObjectsAccesses();
        for (StreamingObject inputStreamObject : this.inputModesObjects) {
            Object streamInObject;
            if (inputStreamObject.getMode() != 2 || (currentAccess = objectAccesses.get(streamInObject = inputStreamObject.getObject())) == Access.READ_WRITE) continue;
            objectAccesses.replace(streamInObject, currentAccess, Access.READ_WRITE);
        }
        for (StreamingObject outputStreamObject : this.outputModeObjects) {
            if (outputStreamObject.getMode() != 2 || (currentAccess = objectAccesses.get(streamOutObject = outputStreamObject.getObject())) == Access.READ_WRITE) continue;
            objectAccesses.replace(streamOutObject, currentAccess, Access.READ_WRITE);
        }
        for (StreamingObject outputStreamObject : this.outputModeObjects) {
            if (outputStreamObject.getMode() != 2 || (currentAccess = objectAccesses.get(streamOutObject = outputStreamObject.getObject())) == Access.READ_WRITE) continue;
            objectAccesses.replace(streamOutObject, currentAccess, Access.READ_WRITE);
        }
    }

    public boolean isGridRegistered() {
        return this.checkGridSchedulerNames();
    }

    public void setLastExecutedTaskGraph(TornadoTaskGraphInterface lastExecutedTaskGraph) {
        this.lastExecutedTaskGraph = lastExecutedTaskGraph;
    }

    public long getTotalBytesTransferred() {
        return this.getProfilerValue(ProfilerType.TOTAL_COPY_IN_SIZE_BYTES) + this.getProfilerValue(ProfilerType.TOTAL_COPY_OUT_SIZE_BYTES);
    }

    public long getTotalDeviceMemoryUsage() {
        return this.getProfilerValue(ProfilerType.ALLOCATION_BYTES);
    }

    public SchedulableTask getTask(String id) {
        return this.executionContext.getTask(id);
    }

    public TornadoDevice getDevice() {
        return this.executionContext.getDeviceOfFirstTask();
    }

    public void setDevice(TornadoDevice device) {
        SchedulableTask task;
        TornadoXPUDevice oldDevice = this.meta().getXPUDevice();
        if (oldDevice.equals(device)) {
            this.reuseDeviceBuffersForSameDevice(device);
            return;
        }
        this.meta().setDevice(device);
        for (int i = 0; i < this.executionContext.getTaskCount(); ++i) {
            task = this.executionContext.getTask(i);
            task.meta().setDevice(device);
            if (!(task instanceof CompilableTask)) continue;
            CompilableTask compilableTask = (CompilableTask)task;
            ResolvedJavaMethod method = TornadoCoreRuntime.getTornadoRuntime().resolveMethod(compilableTask.getMethod());
            if (this.meta().getXPUDevice().getDeviceContext().isCached(this.executionPlanId, method.getName(), (SchedulableTask)compilableTask)) continue;
            this.updateInner(i, this.executionContext.getTask(i));
        }
        for (LocalObjectState localState : this.executionContext.getObjectStates()) {
            DataObjectState dataObjectState = localState.getDataObjectState();
            XPUDeviceBufferState deviceState = dataObjectState.getDeviceBufferState(oldDevice);
            if (!deviceState.isLockedBuffer()) continue;
            this.releaseObjectFromDeviceMemory(localState, oldDevice);
            this.reuseDeviceBufferObject(localState, device);
        }
        for (int i = 0; i < this.executionContext.getTaskCount(); ++i) {
            task = this.executionContext.getTask(i);
            task.meta().resetThreadBlocks();
        }
    }

    private void reuseDeviceBuffersForSameDevice(TornadoDevice device) {
        for (LocalObjectState localState : this.executionContext.getObjectStates()) {
            this.reuseDeviceBufferObject(localState, device);
        }
    }

    public void updatePersistedObjectState() {
        if (this.lastExecutedTaskGraph == null) {
            return;
        }
        TornadoTaskGraph graphSrc = (TornadoTaskGraph)this.lastExecutedTaskGraph;
        List<Object> objectsToSync = this.executionContext.getPersistedTaskToObjectsMap().get(graphSrc.taskGraphName);
        if (objectsToSync == null) {
            objectsToSync = this.executionContext.getPersistedObjects();
            this.executionContext.addPersistedObject(this.taskGraphName, objectsToSync);
        }
        for (Object objectToSync : objectsToSync) {
            Access objectAccessSrc = graphSrc.getObjectAccess(objectToSync);
            LocalObjectState localStateSrc = graphSrc.executionContext.getLocalStateObject(objectToSync, objectAccessSrc);
            DataObjectState dataObjectStateSrc = localStateSrc.getDataObjectState();
            TornadoXPUDevice device = graphSrc.meta().getXPUDevice();
            XPUDeviceBufferState deviceStateSrc = dataObjectStateSrc.getDeviceBufferState(device);
            Access objectAccessDest = Access.READ_WRITE;
            LocalObjectState localStateDest = this.executionContext.getLocalStateObject(objectToSync, objectAccessDest);
            if (localStateDest == null) continue;
            if (!graphSrc.meta().getXPUDevice().equals(this.executionContext.meta().getXPUDevice())) {
                throw new TornadoRuntimeException("[ERROR] Object " + String.valueOf(objectsToSync) + " is not on the same device pesisted and consumed: " + String.valueOf(graphSrc.meta().getXPUDevice()) + "  vs " + String.valueOf(this.executionContext.meta().getXPUDevice()));
            }
            DataObjectState dataObjectStateDest = localStateDest.getDataObjectState();
            XPUDeviceBufferState deviceStateDest = dataObjectStateDest.getDeviceBufferState(device);
            deviceStateDest.setXPUBuffer(deviceStateSrc.getXPUBuffer());
        }
    }

    public void setDevice(String taskName, TornadoDevice device) {
        SchedulableTask task;
        TornadoXPUDevice oldDevice = this.meta().getXPUDevice();
        for (int i = 0; i < this.executionContext.getTaskCount(); ++i) {
            task = this.executionContext.getTask(i);
            String name = task.getId();
            if (!name.equals(taskName)) continue;
            task.meta().setDevice(device);
            if (!(task instanceof CompilableTask)) continue;
            ResolvedJavaMethod method = TornadoCoreRuntime.getTornadoRuntime().resolveMethod(((CompilableTask)task).getMethod());
            if (task.getDevice().getDeviceContext().isCached(this.executionPlanId, method.getName(), task)) continue;
            this.updateInner(i, task);
        }
        for (LocalObjectState localState : this.executionContext.getObjectStates()) {
            DataObjectState dataObjectState = localState.getDataObjectState();
            XPUDeviceBufferState deviceState = dataObjectState.getDeviceBufferState(oldDevice);
            if (!deviceState.isLockedBuffer()) continue;
            this.releaseObjectFromDeviceMemory(localState, oldDevice);
            this.reuseDeviceBufferObject(localState, device);
        }
        for (int i = 0; i < this.executionContext.getTaskCount(); ++i) {
            task = this.executionContext.getTask(i);
            task.meta().resetThreadBlocks();
        }
    }

    public TornadoXPUDevice getDeviceForTask(String id) {
        return this.executionContext.getDeviceForTask(id);
    }

    private void updateInner(int index, SchedulableTask task) {
        int driverIndex = task.meta().getBackendIndex();
        Providers providers = TornadoCoreRuntime.getTornadoRuntime().getBackend(driverIndex).getProviders();
        TornadoSuitesProvider suites = TornadoCoreRuntime.getTornadoRuntime().getBackend(driverIndex).getSuitesProvider();
        this.executionContext.setTask(index, task);
        if (task instanceof CompilableTask) {
            CompilableTask compilableTask = (CompilableTask)task;
            ResolvedJavaMethod resolvedMethod = TornadoCoreRuntime.getTornadoRuntime().resolveMethod(compilableTask.getMethod());
            TaskDataContext taskMetaData = compilableTask.meta();
            new SketchRequest(resolvedMethod, providers, suites.getGraphBuilderSuite(), suites.getSketchTier(), taskMetaData.getBackendIndex(), taskMetaData.getDeviceIndex()).run();
            Sketch sketchGraph = TornadoSketcher.lookup(resolvedMethod, taskMetaData.getBackendIndex(), taskMetaData.getDeviceIndex());
            this.compilationGraph = sketchGraph.getGraph();
        }
    }

    public void addInner(SchedulableTask task) {
        int driverIndex = task.meta().getBackendIndex();
        Providers providers = TornadoCoreRuntime.getTornadoRuntime().getBackend(driverIndex).getProviders();
        TornadoSuitesProvider suites = TornadoCoreRuntime.getTornadoRuntime().getBackend(driverIndex).getSuitesProvider();
        int index = this.executionContext.addTask(task);
        if (task instanceof CompilableTask) {
            CompilableTask compilableTask = (CompilableTask)task;
            this.checkForMemorySegmentAsTaskParameter(compilableTask);
            ResolvedJavaMethod resolvedMethod = TornadoCoreRuntime.getTornadoRuntime().resolveMethod(compilableTask.getMethod());
            TaskDataContext taskMetaData = compilableTask.meta();
            new SketchRequest(resolvedMethod, providers, suites.getGraphBuilderSuite(), suites.getSketchTier(), taskMetaData.getBackendIndex(), taskMetaData.getDeviceIndex()).run();
            Sketch lookup = TornadoSketcher.lookup(resolvedMethod, compilableTask.meta().getBackendIndex(), compilableTask.meta().getDeviceIndex());
            this.compilationGraph = lookup.getGraph();
            this.accesses = lookup.getArgumentsAccess();
        } else {
            PrebuiltTask prebuiltTask = (PrebuiltTask)task;
            this.accesses = prebuiltTask.getArgumentsAccess();
        }
        this.hlBuffer.put(TornadoGraphBitcodes.CONTEXT.index());
        int globalTaskId = this.executionContext.getTaskCountAndIncrement();
        this.hlBuffer.putInt(globalTaskId);
        this.hlBuffer.putInt(index);
        Object[] args = task.getArguments();
        this.hlBuffer.put(TornadoGraphBitcodes.ARG_LIST.index());
        this.hlBuffer.putInt(args.length);
        int i = 0;
        for (Object arg : args) {
            index = this.executionContext.insertVariable(arg, this.accesses[i]);
            if (arg.getClass().isPrimitive() || RuntimeUtilities.isBoxedPrimitiveClass(arg.getClass())) {
                this.hlBuffer.put(TornadoGraphBitcodes.LOAD_PRIM.index());
            } else {
                this.hlBuffer.put(TornadoGraphBitcodes.LOAD_REF.index());
            }
            this.hlBuffer.putInt(index);
            ++i;
        }
        this.hlBuffer.put(TornadoGraphBitcodes.LAUNCH.index());
    }

    private void logTaskMethodHandle(SchedulableTask task) {
        if (task.getTaskName() != null && task.getId() != null) {
            Object object;
            if (task instanceof PrebuiltTask) {
                PrebuiltTask prebuiltTask = (PrebuiltTask)task;
                object = prebuiltTask.getFilename();
            } else {
                object = ((CompilableTask)task).getMethod().getDeclaringClass().getSimpleName() + "." + task.getTaskName();
            }
            String methodName = object;
            this.timeProfiler.registerMethodHandle(ProfilerType.METHOD, task.getId(), methodName);
        }
    }

    private void updateDeviceContext() {
        this.executionContext.setDevice(this.meta().getXPUDevice());
    }

    private TornadoVM compileGraphAndBuildVM(boolean setNewDevice) {
        ByteBuffer buffer = ByteBuffer.wrap(this.highLevelCode);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.limit(this.hlBuffer.position());
        TornadoGraph tornadoGraph = TornadoGraphBuilder.buildGraph(this.executionContext, buffer);
        if (setNewDevice) {
            this.updateDeviceContext();
        }
        TornadoVM tornadoVM = new TornadoVM(this.executionContext, tornadoGraph, this.timeProfiler);
        if (this.meta().isDebug()) {
            this.executionContext.dumpExecutionContextMeta();
            tornadoGraph.dumpTornadoGraph();
        }
        return tornadoVM;
    }

    private boolean compareDevices(Set<TornadoXPUDevice> lastDevices, TornadoXPUDevice device2) {
        return lastDevices.contains(device2);
    }

    public boolean isLastDeviceListEmpty() {
        return this.executionContext.getLastDevices().isEmpty();
    }

    private CompileInfo extractCompileInfo() {
        if (this.bytecodeBuilder == null && this.isLastDeviceListEmpty()) {
            return COMPILE_ONLY;
        }
        if (this.bytecodeBuilder != null && !this.isLastDeviceListEmpty() && !this.compareDevices(this.executionContext.getLastDevices(), this.meta().getXPUDevice())) {
            return COMPILE_AND_UPDATE;
        }
        if (this.updateData && (this.gridScheduler == null || !this.hasWorkerGridForAllTasks())) {
            return COMPILE_ONLY;
        }
        if (!this.compareDevices(this.executionContext.getLastDevices(), this.meta().getXPUDevice())) {
            return COMPILE_AND_UPDATE;
        }
        return NOT_COMPILE_UPDATE;
    }

    private boolean hasWorkerGridForAllTasks() {
        for (TaskPackage taskPackage : this.taskPackages) {
            if (this.gridScheduler.contains(this.taskGraphName, taskPackage.getId())) continue;
            return false;
        }
        return true;
    }

    private boolean compileComputeGraphToTornadoVMBytecode() {
        CompileInfo compileInfo = this.extractCompileInfo();
        if (compileInfo.compile) {
            this.timeProfiler.start(ProfilerType.TOTAL_BYTE_CODE_GENERATION);
            this.executionContext.scheduleTaskToDevices();
            TornadoVM tornadoVM = this.compileGraphAndBuildVM(compileInfo.updateDevice);
            this.vmTable.put(this.meta().getXPUDevice(), tornadoVM);
            this.timeProfiler.stop(ProfilerType.TOTAL_BYTE_CODE_GENERATION);
        }
        this.executionContext.addLastDevice(this.meta().getXPUDevice());
        this.vm = this.vmTable.get(this.meta().getXPUDevice());
        this.vm.setGridScheduler(this.gridScheduler);
        if (this.updateData) {
            this.executionContext.newCallWrapper(true);
        } else {
            this.executionContext.newCallWrapper(compileInfo.updateDevice);
        }
        return compileInfo.compile;
    }

    private void compileTaskToOpenCL() {
        this.vm.withPreCompilation();
    }

    private void preCompileForFPGAs() {
        boolean compile = false;
        if (TornadoOptions.FPGA_EMULATION) {
            compile = true;
        } else {
            TornadoXPUDevice tornadoAcceleratorDevice;
            TornadoDevice tornadoDevice = this.executionContext.getDeviceOfFirstTask();
            if (tornadoDevice instanceof TornadoXPUDevice && (tornadoAcceleratorDevice = (TornadoXPUDevice)tornadoDevice).isFullJITMode(this.executionPlanId, this.executionContext.getTask(0))) {
                compile = true;
            }
        }
        if (compile) {
            if (TornadoOptions.DEBUG) {
                System.out.println("[DEBUG] JIT compilation for the FPGA");
            }
            this.compileTaskToOpenCL();
        }
    }

    private void updateProfiler() {
        if (!TornadoOptions.isProfilerEnabled()) {
            return;
        }
        if (!TornadoOptions.PROFILER_LOGS_ACCUMULATE()) {
            this.timeProfiler.dumpJson(new StringBuilder(), this.getId());
        } else {
            this.bufferLogProfiler.append(this.timeProfiler.createJson(new StringBuilder(), this.getId()));
        }
        if (!TornadoOptions.SOCKET_PORT.isEmpty()) {
            TornadoVMClient tornadoVMClient = new TornadoVMClient();
            try {
                tornadoVMClient.sentLogOverSocket(this.timeProfiler.createJson(new StringBuilder(), this.getId()));
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
        if (!TornadoOptions.PROFILER_DIRECTORY.isEmpty()) {
            String jsonFile = this.timeProfiler.createJson(new StringBuilder(), this.getId());
            RuntimeUtilities.profilerFileWriter(jsonFile);
        }
    }

    private void dumpDeoptimisationReason(TornadoBailoutRuntimeException e) {
        if (!TornadoOptions.DEBUG) {
            System.err.println("\u001b[31m[Bailout] Running the sequential implementation. Enable --debug to see the reason.\u001b[0m");
        } else {
            System.err.println(e.getMessage());
            for (StackTraceElement s : e.getStackTrace()) {
                System.err.println("\t" + String.valueOf(s));
            }
        }
    }

    private void deoptimiseToSequentialJava(TornadoBailoutRuntimeException e) {
        this.dumpDeoptimisationReason(e);
        this.runAllTasksJavaSequential();
    }

    public void scheduleInner() {
        boolean compile = this.compileComputeGraphToTornadoVMBytecode();
        TornadoXPUDevice deviceForTask = this.executionContext.getDeviceForTask(0);
        if (compile && deviceForTask.getDeviceContext().isPlatformFPGA()) {
            this.preCompileForFPGAs();
        }
        try {
            this.event = this.vm.execute(this.isConcurrentDevicesEnabled, this.timeProfiler);
            this.timeProfiler.stop(ProfilerType.TOTAL_TASK_GRAPH_TIME);
            this.updateProfiler();
        }
        catch (TornadoBailoutRuntimeException e) {
            if (TornadoOptions.RECOVER_BAILOUT) {
                this.deoptimiseToSequentialJava(e);
            }
            if (TornadoOptions.DEBUG) {
                e.printStackTrace();
            }
            throw new TornadoBailoutRuntimeException("Bailout is disabled. \nReason: " + e.getMessage());
        }
    }

    public void apply(Consumer<SchedulableTask> consumer) {
        this.executionContext.apply(consumer);
    }

    public void mapAllToInner(TornadoDevice device) {
        this.executionContext.mapAllTasksToSingleDevice(device);
    }

    public void dumpTimes() {
        this.vm.printTimes();
    }

    public void dumpProfiles() {
        this.vm.dumpProfiles();
    }

    public void dumpEvents() {
        this.vm.dumpEvents();
    }

    public void clearProfiles() {
        this.vm.clearProfiles();
    }

    public void waitOn() {
        if (TornadoOptions.VM_USE_DEPS && this.event != null) {
            this.event.waitOn();
        } else {
            for (TornadoXPUDevice tornadoXPUDevice : this.executionContext.getDevices()) {
                if (tornadoXPUDevice == null) continue;
                tornadoXPUDevice.sync(this.executionPlanId);
            }
        }
    }

    public void transferToDevice(int mode, Object ... objects) {
        for (Object parameter : objects) {
            if (parameter == null) {
                throw new TornadoRuntimeException("[ERROR] null object passed into streamIn() in schedule " + this.executionContext.getId());
            }
            if (parameter instanceof Number) continue;
            boolean isObjectForStreaming = false;
            if (mode == 1) {
                this.streamInObjects.add(parameter);
                isObjectForStreaming = true;
            }
            this.executionContext.getLocalStateObject(parameter, Access.READ_ONLY).setStreamIn(isObjectForStreaming);
            if (mode == 2) {
                this.executionContext.getLocalStateObject(parameter, Access.READ_ONLY).enableUnderDemand();
            }
            this.inputModesObjects.add(new StreamingObject(mode, parameter));
            if (TornadoOptions.isReusedBuffersEnabled() && !this.argumentsLookUp.contains(parameter)) {
                this.lockObjectsInMemory(parameter);
            }
            this.argumentsLookUp.add(parameter);
        }
    }

    public void consumeFromDevice(String sourceTaskGraphName, Object ... objects) {
        for (Object parameter : objects) {
            if (parameter == null) {
                throw new TornadoRuntimeException("[ERROR] null object passed into streamIn() in task-graph " + this.executionContext.getId());
            }
            if (parameter instanceof Number) {
                throw new TornadoRuntimeException("[ERROR] Invalid object type (Number) passed into streamIn() in task-graph " + this.executionContext.getId());
            }
            this.executionContext.getLocalStateObject(parameter, Access.READ_WRITE).setOnDevice(true);
            this.executionContext.addPersistedObject(sourceTaskGraphName, parameter);
            this.executionContext.addPersistedObject(parameter);
            if (TornadoOptions.isReusedBuffersEnabled() && !this.argumentsLookUp.contains(parameter)) {
                this.lockObjectsInMemory(parameter);
            }
            this.argumentsLookUp.add(parameter);
        }
    }

    public void consumeFromDevice(Object ... objects) {
        for (Object parameter : objects) {
            if (parameter == null) {
                throw new TornadoRuntimeException("[ERROR] null object passed into streamIn() in task-graph " + this.executionContext.getId());
            }
            if (parameter instanceof Number) {
                throw new TornadoRuntimeException("[ERROR] Invalid object type (Number) passed into streamIn() in task-graph " + this.executionContext.getId());
            }
            this.executionContext.getLocalStateObject(parameter, Access.READ_WRITE).setOnDevice(true);
            this.executionContext.addPersistedObject(parameter);
            if (TornadoOptions.isReusedBuffersEnabled() && !this.argumentsLookUp.contains(parameter)) {
                this.lockObjectsInMemory(parameter);
            }
            this.argumentsLookUp.add(parameter);
        }
    }

    private boolean isANumber(Object parameter) {
        return parameter instanceof Number;
    }

    private boolean isAtomic(Object parameter) {
        return parameter instanceof AtomicInteger;
    }

    public void transferToHost(int mode, Object ... objects) {
        for (Object functionParameter : objects) {
            if (functionParameter == null) {
                new TornadoLogger().warn("null object passed into streamIn() in schedule %s", this.executionContext.getId());
                continue;
            }
            if (this.isANumber(functionParameter) && !this.isAtomic(functionParameter)) {
                throw new TornadoRuntimeException("[ERROR] Scalar value used as output. Use an array or a vector-type instead");
            }
            if (mode != 2) {
                this.streamOutObjects.add(functionParameter);
                this.executionContext.getLocalStateObject(functionParameter, Access.WRITE_ONLY).setStreamOut(true);
            }
            if (mode == 2) {
                this.executionContext.addPersistedObject(functionParameter);
            }
            this.outputModeObjects.add(new StreamingObject(mode, functionParameter));
            if ((TornadoOptions.isReusedBuffersEnabled() || mode == 2) && !this.argumentsLookUp.contains(functionParameter)) {
                this.lockObjectsInMemory(functionParameter);
            }
            this.argumentsLookUp.add(functionParameter);
        }
    }

    public void dump() {
        int width = 16;
        System.out.printf("code  : capacity = %s, in use = %s %n", RuntimeUtilities.humanReadableByteCount(this.hlBuffer.capacity(), true), RuntimeUtilities.humanReadableByteCount(this.hlBuffer.position(), true));
        for (int i = 0; i < this.hlBuffer.position(); i += 16) {
            System.out.printf("[0x%04x]: ", i);
            for (int j = 0; j < Math.min(this.hlBuffer.capacity() - i, 16); ++j) {
                if (j % 2 == 0) {
                    System.out.print(" ");
                }
                if (j < this.hlBuffer.position() - i) {
                    System.out.printf("%02x", this.hlBuffer.get(i + j));
                    continue;
                }
                System.out.print("..");
            }
            System.out.println();
        }
    }

    public void withPreCompilation(ExecutorFrame executionPackage) {
        this.setupProfiler();
        this.getDevice().getDeviceContext().setResetToFalse();
        this.timeProfiler.clean();
        this.compileComputeGraphToTornadoVMBytecode();
        this.executionPlanId = executionPackage.getExecutionPlanId();
        this.executionContext.setExecutionPlanId(this.executionPlanId);
        this.vm.withPreCompilation();
        if (TornadoOptions.isProfilerEnabled() && !TornadoOptions.PROFILER_LOGS_ACCUMULATE()) {
            this.timeProfiler.dumpJson(new StringBuilder(), this.getId());
        }
    }

    private Access getObjectAccess(Object object) {
        boolean isRead = false;
        boolean isWrite = false;
        for (StreamingObject inputStreamObject : this.inputModesObjects) {
            if (!inputStreamObject.object.equals(object)) continue;
            isRead = true;
        }
        for (StreamingObject outputStreamObject : this.outputModeObjects) {
            if (!outputStreamObject.object.equals(object)) continue;
            isWrite = true;
        }
        if (isRead && isWrite) {
            return Access.READ_WRITE;
        }
        if (isRead) {
            return Access.READ_ONLY;
        }
        if (isWrite) {
            return Access.WRITE_ONLY;
        }
        return Access.NONE;
    }

    private void reuseDeviceBufferObject(Object object) {
        Access objectAccess = this.getObjectAccess(object);
        LocalObjectState localState = this.executionContext.getLocalStateObject(object, objectAccess);
        TornadoRuntime runtime = TornadoRuntimeProvider.getTornadoRuntime();
        int numBackends = runtime.getNumBackends();
        for (int i = 0; i < numBackends; ++i) {
            TornadoBackend backend = runtime.getBackend(i);
            backend.getAllDevices().forEach(device -> this.reuseDeviceBufferObject(localState, (TornadoDevice)device));
        }
    }

    private void reuseDeviceBufferObject(LocalObjectState localState, TornadoDevice device) {
        DataObjectState dataObjectState = localState.getDataObjectState();
        XPUDeviceBufferState deviceState = dataObjectState.getDeviceBufferState(device);
        deviceState.setLockBuffer(true);
    }

    void lockObjectsInMemory(Object ... objects) {
        Arrays.stream(objects).forEach(this::reuseDeviceBufferObject);
    }

    public void freeDeviceMemory() {
        this.free();
    }

    private void freeIOObjects() {
        for (StreamingObject inputStreamObject : this.inputModesObjects) {
            if (this.streamOutObjects.contains(inputStreamObject.object)) {
                this.freeDeviceMemoryObject(inputStreamObject.object, Access.READ_WRITE);
                continue;
            }
            this.freeDeviceMemoryObject(inputStreamObject.object, Access.READ_ONLY);
        }
        for (StreamingObject outputStreamObject : this.outputModeObjects) {
            if (this.streamInObjects.contains(outputStreamObject.object)) {
                this.freeDeviceMemoryObject(outputStreamObject.object, Access.READ_WRITE);
                continue;
            }
            this.freeDeviceMemoryObject(outputStreamObject.object, Access.WRITE_ONLY);
        }
    }

    private void free() {
        if (this.vm == null) {
            return;
        }
        this.freeIOObjects();
        this.meta().getXPUDevice().getDeviceContext().reset(this.executionPlanId);
    }

    private void freeDeviceMemoryObject(Object object, Access access) {
        LocalObjectState localState = this.executionContext.getLocalStateObject(object, access);
        this.releaseObjectFromDeviceMemory(localState, this.meta().getXPUDevice());
    }

    private void releaseObjectFromDeviceMemory(LocalObjectState localState, TornadoDevice device) {
        DataObjectState dataObjectState = localState.getDataObjectState();
        XPUDeviceBufferState deviceBufferState = dataObjectState.getDeviceBufferState(device);
        deviceBufferState.setLockBuffer(false);
        if (deviceBufferState.hasObjectBuffer()) {
            device.deallocate((DeviceBufferState)deviceBufferState);
        }
    }

    private void syncField(Object object) {
        this.timeProfiler.clean();
        this.executionContext.sync();
        this.updateProfiler();
    }

    private Event syncObjectInner(Object object) {
        TornadoXPUDevice device;
        Access objectAccess = this.getObjectAccess(object);
        LocalObjectState localState = this.executionContext.getLocalStateObject(object, objectAccess);
        DataObjectState dataObjectState = localState.getDataObjectState();
        XPUDeviceBufferState deviceState = dataObjectState.getDeviceBufferState(device = this.meta().getXPUDevice());
        if (deviceState.isLockedBuffer()) {
            return device.resolveEvent(this.executionPlanId, device.streamOutBlocking(this.executionPlanId, object, 0L, deviceState, null));
        }
        return null;
    }

    private Event syncObjectInner(Object object, long offset, long partialCopySize) {
        Access objectAccess = this.getObjectAccess(object);
        LocalObjectState localState = this.executionContext.getLocalStateObject(object, objectAccess);
        DataObjectState dataObjectState = localState.getDataObjectState();
        TornadoXPUDevice device = this.meta().getXPUDevice();
        XPUDeviceBufferState deviceState = dataObjectState.getDeviceBufferState(device);
        deviceState.setPartialCopySize(partialCopySize);
        if (deviceState.isLockedBuffer()) {
            return device.resolveEvent(this.executionPlanId, device.streamOutBlocking(this.executionPlanId, object, offset, deviceState, null));
        }
        return null;
    }

    private Event syncObjectInnerLazy(Object object, long hostOffset, long bufferSize) {
        TornadoXPUDevice device;
        Access objectAccess = this.getObjectAccess(object);
        LocalObjectState localState = this.executionContext.getLocalStateObject(object, objectAccess);
        DataObjectState dataObjectState = localState.getDataObjectState();
        XPUDeviceBufferState deviceBufferState = dataObjectState.getDeviceBufferState(device = this.meta().getXPUDevice());
        if (deviceBufferState.isLockedBuffer()) {
            deviceBufferState.getXPUBuffer().setSizeSubRegion(bufferSize);
            return device.resolveEvent(this.executionPlanId, device.streamOutBlocking(this.executionPlanId, object, hostOffset, deviceBufferState, null));
        }
        return null;
    }

    private Event syncParameter(Object object) {
        Event eventParameter = null;
        if (this.batchSizeBytes != (long)TornadoExecutionContext.INIT_VALUE) {
            BatchConfiguration batchConfiguration = BatchConfiguration.computeChunkSizes(this.executionContext, this.batchSizeBytes);
            long hostOffset = 0L;
            for (int i = 0; i < batchConfiguration.getTotalChunks(); ++i) {
                hostOffset = this.batchSizeBytes * (long)i;
                eventParameter = this.syncObjectInnerLazy(object, hostOffset, this.batchSizeBytes);
            }
            if (batchConfiguration.getRemainingChunkSize() != 0) {
                eventParameter = this.syncObjectInnerLazy(object, hostOffset += this.batchSizeBytes, batchConfiguration.getRemainingChunkSize());
            }
        } else {
            eventParameter = this.syncObjectInner(object);
        }
        if (eventParameter != null) {
            eventParameter.waitOn();
        }
        return eventParameter;
    }

    private Event syncParameter(Object object, long offset, long partialCopySize) {
        Event eventParameter = this.syncObjectInner(object, offset, partialCopySize);
        if (eventParameter != null) {
            eventParameter.waitOn();
        }
        return eventParameter;
    }

    private boolean copyUnderDemand(Object object) {
        for (StreamingObject outputObject : this.outputModeObjects) {
            if (!outputObject.getObject().equals(object) || outputObject.getMode() != 2) continue;
            return true;
        }
        return false;
    }

    public void syncRuntimeTransferToHost(Object ... objects) {
        if (this.vm == null) {
            return;
        }
        ArrayList<Event> events = new ArrayList<Event>();
        for (Object object : objects) {
            if (TornadoOptions.DEBUG && this.copyUnderDemand(object)) {
                new TornadoLogger().debug("Object " + String.valueOf(object) + " to be copied UNDER_DEMAND");
            }
            if (!this.argumentsLookUp.contains(object)) {
                this.syncField(object);
                continue;
            }
            Event eventParameter = this.syncParameter(object);
            events.add(eventParameter);
        }
        if (TornadoOptions.isProfilerEnabled()) {
            this.timeProfiler.clean();
            for (int i = 0; i < events.size(); ++i) {
                Event eventParameter = (Event)events.get(i);
                if (eventParameter == null) continue;
                long value = this.timeProfiler.getTimer(ProfilerType.COPY_OUT_TIME_SYNC);
                eventParameter.waitForEvents(this.executionPlanId);
                this.timeProfiler.setTimer(ProfilerType.COPY_OUT_TIME_SYNC, value += eventParameter.getElapsedTime());
                Access objectAccess = this.getObjectAccess(objects[i]);
                LocalObjectState localState = this.executionContext.getLocalStateObject(objects[i], objectAccess);
                XPUDeviceBufferState deviceObjectState = localState.getDataObjectState().getDeviceBufferState(this.meta().getXPUDevice());
                this.timeProfiler.addValueToMetric(ProfilerType.COPY_OUT_SIZE_BYTES_SYNC, TimeProfiler.NO_TASK_NAME, deviceObjectState.getXPUBuffer().size());
            }
            this.updateProfiler();
        }
    }

    public void syncRuntimeTransferToHost(Object object, long offset, long partialCopySize) {
        if (this.vm == null) {
            return;
        }
        Event event = null;
        if (TornadoOptions.DEBUG && this.copyUnderDemand(object)) {
            new TornadoLogger().debug(partialCopySize + " bytes of the object " + String.valueOf(object) + " to be copied UNDER_DEMAND from offset " + offset);
        }
        if (!this.argumentsLookUp.contains(object)) {
            this.syncField(object);
        } else {
            event = this.syncParameter(object, offset, partialCopySize);
        }
        if (TornadoOptions.isProfilerEnabled()) {
            this.timeProfiler.clean();
            if (event != null) {
                long value = this.timeProfiler.getTimer(ProfilerType.COPY_OUT_TIME_SYNC);
                event.waitForEvents(this.executionPlanId);
                this.timeProfiler.setTimer(ProfilerType.COPY_OUT_TIME_SYNC, value += event.getElapsedTime());
                Access objectAccess = this.getObjectAccess(object);
                LocalObjectState localState = this.executionContext.getLocalStateObject(object, objectAccess);
                XPUDeviceBufferState deviceObjectState = localState.getDataObjectState().getDeviceBufferState(this.meta().getXPUDevice());
                this.timeProfiler.addValueToMetric(ProfilerType.COPY_OUT_SIZE_BYTES_SYNC, TimeProfiler.NO_TASK_NAME, deviceObjectState.getXPUBuffer().size());
                this.updateProfiler();
            }
        }
    }

    public String getId() {
        return this.meta().getId();
    }

    public ScheduleContext meta() {
        return this.executionContext.meta();
    }

    private void runReduceTaskGraph() {
        this.reduceTaskGraph.executeExpression();
    }

    private void rewriteTaskForReduceSkeleton(MetaReduceCodeAnalysis analysisTaskSchedule) {
        this.reduceTaskGraph = new ReduceTaskGraph(this.getId(), this.taskPackages, this.streamInObjects, this.inputModesObjects, this.streamOutObjects, this.outputModeObjects, this.compilationGraph, this);
        this.reduceTaskGraph.scheduleWithReduction(analysisTaskSchedule);
        this.reduceExpressionRewritten = true;
    }

    private TornadoTaskGraphInterface reduceAnalysis() {
        TornadoTaskGraph abstractTaskGraph = null;
        if (this.analysisTaskGraph == null && !this.reduceAnalysis) {
            this.analysisTaskGraph = ReduceCodeAnalysis.analyzeTaskGraph(this.taskPackages);
            this.reduceAnalysis = true;
            if (this.analysisTaskGraph != null && this.analysisTaskGraph.isValid()) {
                this.rewriteTaskForReduceSkeleton(this.analysisTaskGraph);
                abstractTaskGraph = this;
            }
        }
        return abstractTaskGraph;
    }

    private TornadoTaskGraphInterface analyzeSkeletonAndRun() {
        TornadoTaskGraphInterface abstractTaskGraph;
        if (!this.reduceExpressionRewritten) {
            abstractTaskGraph = this.reduceAnalysis();
        } else {
            this.runReduceTaskGraph();
            abstractTaskGraph = this;
        }
        return abstractTaskGraph;
    }

    private void cleanUp() {
        this.updateData = false;
        this.isFinished = true;
    }

    private boolean isArgumentIgnorable(Object parameter) {
        return parameter instanceof Number || parameter instanceof KernelContext || parameter instanceof IntArray || parameter instanceof FloatArray || parameter instanceof DoubleArray || parameter instanceof LongArray || parameter instanceof ShortArray;
    }

    private void checkAllArgumentsPerTask() {
        for (TaskPackage task : this.taskPackages) {
            Object[] taskParameters = task.getTaskParameters();
            for (int i = 1; i < taskParameters.length - 1; ++i) {
                Object parameter = taskParameters[i];
                if (this.isArgumentIgnorable(parameter) || this.argumentsLookUp.contains(parameter)) continue;
                throw new TornadoTaskRuntimeException("Parameter #" + i + " <" + String.valueOf(parameter) + "> from task <" + task.getId() + "> not specified either in transferToDevice or transferToHost functions");
            }
        }
    }

    private boolean checkForMemorySegmentAsTaskParameter(CompilableTask task) {
        for (Object parameter : task.getArguments()) {
            if (!(parameter instanceof MemorySegment)) continue;
            String parameterClassName = parameter.getClass().getSimpleName();
            throw new TornadoRuntimeException("Parameter " + parameterClassName + " is not a valid task argument because it is an instance of a TornadoNativeArray.");
        }
        return true;
    }

    private void lockInPendingFieldsObjects() {
        int taskCount = this.executionContext.getTaskCount();
        for (int i = 0; i < taskCount; ++i) {
            Object[] arguments;
            SchedulableTask task = this.executionContext.getTask(i);
            for (Object arg : arguments = task.getArguments()) {
                if (this.isArgumentIgnorable(arg) || this.argumentsLookUp.contains(arg)) continue;
                this.lockObjectsInMemory(arg);
            }
        }
    }

    private void setupProfiler() {
        this.timeProfiler = this.isProfilerEnabled() ? new TimeProfiler() : new EmptyProfiler();
        this.executionContext.withProfiler(this.timeProfiler);
        for (SchedulableTask task : this.executionContext.getTasks()) {
            this.logTaskMethodHandle(task);
        }
    }

    private void bailout() {
        if (!TornadoOptions.RECOVER_BAILOUT) {
            throw new TornadoBailoutRuntimeException("[TornadoVM] Error - Recover option disabled");
        }
        this.runAllTasksJavaSequential();
    }

    private TornadoTaskGraphInterface execute() {
        if (this.bailout) {
            this.bailout();
        }
        this.isFinished = false;
        this.setupProfiler();
        this.timeProfiler.clean();
        this.timeProfiler.start(ProfilerType.TOTAL_TASK_GRAPH_TIME);
        this.executionContext.setExecutionPlanId(this.executionPlanId);
        this.updatePersistedObjectState();
        TornadoTaskGraphInterface reduceTaskGraph = null;
        if (TornadoOptions.EXPERIMENTAL_REDUCE && !this.getId().startsWith(GENERATED_TASK_GRAPH_PREFIX)) {
            reduceTaskGraph = this.analyzeSkeletonAndRun();
        }
        if (reduceTaskGraph != null) {
            return reduceTaskGraph;
        }
        if (TornadoOptions.FORCE_CHECK_PARAMETERS) {
            this.checkAllArgumentsPerTask();
        }
        this.lockInPendingFieldsObjects();
        this.analysisTaskGraph = null;
        try {
            this.scheduleInner();
            this.cleanUp();
        }
        catch (TornadoRuntimeException e) {
            this.bailout();
        }
        return this;
    }

    private void checkProfilerOn(ExecutorFrame executorFrame) {
        if (executorFrame.getProfilerMode() != null) {
            this.enableProfiler(executorFrame.getProfilerMode());
        } else {
            this.disableProfiler();
        }
    }

    public TornadoTaskGraphInterface execute(ExecutorFrame executorFrame) {
        this.executionPlanId = executorFrame.getExecutionPlanId();
        this.checkProfilerOn(executorFrame);
        return this.execute();
    }

    private boolean isTaskNamePresent(String taskName) {
        for (TaskPackage taskPackage : this.taskPackages) {
            if (!taskName.equals(this.taskGraphName + "." + taskPackage.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean checkGridSchedulerNames() {
        Set gridTaskNames = this.gridScheduler.keySet();
        return gridTaskNames.stream().anyMatch(this::isTaskNamePresent);
    }

    private void runSequentialCodeInThread(TaskPackage taskPackage) {
        int type = taskPackage.getTaskType();
        switch (type) {
            case 0: {
                TornadoFunctions.Task task = (TornadoFunctions.Task)taskPackage.getTaskParameters()[0];
                task.apply();
                break;
            }
            case 1: {
                TornadoFunctions.Task1 task1 = (TornadoFunctions.Task1)taskPackage.getTaskParameters()[0];
                task1.apply(taskPackage.getTaskParameters()[1]);
                break;
            }
            case 2: {
                TornadoFunctions.Task2 task2 = (TornadoFunctions.Task2)taskPackage.getTaskParameters()[0];
                task2.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2]);
                break;
            }
            case 3: {
                TornadoFunctions.Task3 task3 = (TornadoFunctions.Task3)taskPackage.getTaskParameters()[0];
                task3.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3]);
                break;
            }
            case 4: {
                TornadoFunctions.Task4 task4 = (TornadoFunctions.Task4)taskPackage.getTaskParameters()[0];
                task4.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3], taskPackage.getTaskParameters()[4]);
                break;
            }
            case 5: {
                TornadoFunctions.Task5 task5 = (TornadoFunctions.Task5)taskPackage.getTaskParameters()[0];
                task5.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3], taskPackage.getTaskParameters()[4], taskPackage.getTaskParameters()[5]);
                break;
            }
            case 6: {
                TornadoFunctions.Task6 task6 = (TornadoFunctions.Task6)taskPackage.getTaskParameters()[0];
                task6.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3], taskPackage.getTaskParameters()[4], taskPackage.getTaskParameters()[5], taskPackage.getTaskParameters()[6]);
                break;
            }
            case 7: {
                TornadoFunctions.Task7 task7 = (TornadoFunctions.Task7)taskPackage.getTaskParameters()[0];
                task7.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3], taskPackage.getTaskParameters()[4], taskPackage.getTaskParameters()[5], taskPackage.getTaskParameters()[6], taskPackage.getTaskParameters()[7]);
                break;
            }
            case 8: {
                TornadoFunctions.Task8 task8 = (TornadoFunctions.Task8)taskPackage.getTaskParameters()[0];
                task8.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3], taskPackage.getTaskParameters()[4], taskPackage.getTaskParameters()[5], taskPackage.getTaskParameters()[6], taskPackage.getTaskParameters()[7], taskPackage.getTaskParameters()[8]);
                break;
            }
            case 9: {
                TornadoFunctions.Task9 task9 = (TornadoFunctions.Task9)taskPackage.getTaskParameters()[0];
                task9.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3], taskPackage.getTaskParameters()[4], taskPackage.getTaskParameters()[5], taskPackage.getTaskParameters()[6], taskPackage.getTaskParameters()[7], taskPackage.getTaskParameters()[8], taskPackage.getTaskParameters()[9]);
                break;
            }
            case 10: {
                TornadoFunctions.Task10 task10 = (TornadoFunctions.Task10)taskPackage.getTaskParameters()[0];
                task10.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3], taskPackage.getTaskParameters()[4], taskPackage.getTaskParameters()[5], taskPackage.getTaskParameters()[6], taskPackage.getTaskParameters()[7], taskPackage.getTaskParameters()[8], taskPackage.getTaskParameters()[9], taskPackage.getTaskParameters()[10]);
                break;
            }
            case 11: {
                TornadoFunctions.Task11 task11 = (TornadoFunctions.Task11)taskPackage.getTaskParameters()[0];
                task11.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3], taskPackage.getTaskParameters()[4], taskPackage.getTaskParameters()[5], taskPackage.getTaskParameters()[6], taskPackage.getTaskParameters()[7], taskPackage.getTaskParameters()[8], taskPackage.getTaskParameters()[9], taskPackage.getTaskParameters()[10], taskPackage.getTaskParameters()[11]);
                break;
            }
            case 12: {
                TornadoFunctions.Task12 task12 = (TornadoFunctions.Task12)taskPackage.getTaskParameters()[0];
                task12.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3], taskPackage.getTaskParameters()[4], taskPackage.getTaskParameters()[5], taskPackage.getTaskParameters()[6], taskPackage.getTaskParameters()[7], taskPackage.getTaskParameters()[8], taskPackage.getTaskParameters()[9], taskPackage.getTaskParameters()[10], taskPackage.getTaskParameters()[11], taskPackage.getTaskParameters()[12]);
                break;
            }
            case 13: {
                TornadoFunctions.Task13 task13 = (TornadoFunctions.Task13)taskPackage.getTaskParameters()[0];
                task13.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3], taskPackage.getTaskParameters()[4], taskPackage.getTaskParameters()[5], taskPackage.getTaskParameters()[6], taskPackage.getTaskParameters()[7], taskPackage.getTaskParameters()[8], taskPackage.getTaskParameters()[9], taskPackage.getTaskParameters()[10], taskPackage.getTaskParameters()[11], taskPackage.getTaskParameters()[12], taskPackage.getTaskParameters()[13]);
                break;
            }
            case 14: {
                TornadoFunctions.Task14 task14 = (TornadoFunctions.Task14)taskPackage.getTaskParameters()[0];
                task14.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3], taskPackage.getTaskParameters()[4], taskPackage.getTaskParameters()[5], taskPackage.getTaskParameters()[6], taskPackage.getTaskParameters()[7], taskPackage.getTaskParameters()[8], taskPackage.getTaskParameters()[9], taskPackage.getTaskParameters()[10], taskPackage.getTaskParameters()[11], taskPackage.getTaskParameters()[12], taskPackage.getTaskParameters()[13], taskPackage.getTaskParameters()[14]);
                break;
            }
            case 15: {
                TornadoFunctions.Task15 task15 = (TornadoFunctions.Task15)taskPackage.getTaskParameters()[0];
                task15.apply(taskPackage.getTaskParameters()[1], taskPackage.getTaskParameters()[2], taskPackage.getTaskParameters()[3], taskPackage.getTaskParameters()[4], taskPackage.getTaskParameters()[5], taskPackage.getTaskParameters()[6], taskPackage.getTaskParameters()[7], taskPackage.getTaskParameters()[8], taskPackage.getTaskParameters()[9], taskPackage.getTaskParameters()[10], taskPackage.getTaskParameters()[11], taskPackage.getTaskParameters()[12], taskPackage.getTaskParameters()[13], taskPackage.getTaskParameters()[14], taskPackage.getTaskParameters()[15]);
                break;
            }
            default: {
                throw new TornadoRuntimeException("Sequential Runner not supported yet. Number of parameters: " + type);
            }
        }
    }

    private void runAllTasksJavaSequential() {
        for (TaskPackage taskPackage : this.taskPackages) {
            this.runSequentialCodeInThread(taskPackage);
        }
    }

    private void addInner(int type, Method method, ScheduleContext meta, String id, Object[] parameters) {
        switch (type) {
            case 0: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task)parameters[0]));
                break;
            }
            case 1: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task1)parameters[0], parameters[1]));
                break;
            }
            case 2: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task2)parameters[0], parameters[1], parameters[2]));
                break;
            }
            case 3: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task3)parameters[0], parameters[1], parameters[2], parameters[3]));
                break;
            }
            case 4: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task4)parameters[0], parameters[1], parameters[2], parameters[3], parameters[4]));
                break;
            }
            case 5: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task5)parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], parameters[5]));
                break;
            }
            case 6: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task6)parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], parameters[5], parameters[6]));
                break;
            }
            case 7: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task7)parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], parameters[5], parameters[6], parameters[7]));
                break;
            }
            case 8: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task8)parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], parameters[5], parameters[6], parameters[7], parameters[8]));
                break;
            }
            case 9: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task9)parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], parameters[5], parameters[6], parameters[7], parameters[8], parameters[9]));
                break;
            }
            case 10: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task10)parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], parameters[5], parameters[6], parameters[7], parameters[8], parameters[9], parameters[10]));
                break;
            }
            case 11: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task11)parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], parameters[5], parameters[6], parameters[7], parameters[8], parameters[9], parameters[10], parameters[11]));
                break;
            }
            case 12: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task12)parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], parameters[5], parameters[6], parameters[7], parameters[8], parameters[9], parameters[10], parameters[11], parameters[12]));
                break;
            }
            case 13: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task13)parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], parameters[5], parameters[6], parameters[7], parameters[8], parameters[9], parameters[10], parameters[11], parameters[12], parameters[13]));
                break;
            }
            case 14: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task14)parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], parameters[5], parameters[6], parameters[7], parameters[8], parameters[9], parameters[10], parameters[11], parameters[12], parameters[13], parameters[14]));
                break;
            }
            case 15: {
                this.addInner(TaskUtils.createTask(method, meta, id, (TornadoFunctions.Task15)parameters[0], parameters[1], parameters[2], parameters[3], parameters[4], parameters[5], parameters[6], parameters[7], parameters[8], parameters[9], parameters[10], parameters[11], parameters[12], parameters[13], parameters[14], parameters[15]));
                break;
            }
            default: {
                throw new TornadoRuntimeException("Task not supported yet. Type: " + type);
            }
        }
    }

    public void addTask(TaskPackage taskPackage) {
        this.taskPackages.add(taskPackage);
        String id = taskPackage.getId();
        int type = taskPackage.getTaskType();
        Object[] parameters = taskPackage.getTaskParameters();
        Method method = TaskUtils.resolveMethodHandle(parameters[0]);
        ScheduleContext meta = this.meta();
        meta.setNumThreads(taskPackage.getNumThreadsToRun());
        try {
            this.addInner(type, method, meta, id, parameters);
        }
        catch (TornadoBailoutRuntimeException e) {
            this.bailout = true;
            if (!TornadoOptions.DEBUG) {
                System.out.println(WARNING_DEOPT_MESSAGE);
            }
            throw e;
        }
    }

    public void addPrebuiltTask(TaskPackage taskPackage) {
        this.taskPackages.add(taskPackage);
        PrebuiltTaskPackage prebuiltTaskPackage = (PrebuiltTaskPackage)taskPackage;
        this.addInner(TaskUtils.createTask(this.meta(), prebuiltTaskPackage));
    }

    public void withBatch(String batchSize) {
        this.batchSizeBytes = this.parseSizeToBytes(batchSize);
        this.executionContext.setBatchSize(this.batchSizeBytes);
    }

    public void withMemoryLimit(String memoryLimit) {
        this.memoryLimitSizeBytes = this.parseSizeToBytes(memoryLimit);
        this.executionContext.setExecutionPlanMemoryLimit(this.memoryLimitSizeBytes);
    }

    public void withoutMemoryLimit() {
        this.executionContext.setExecutionPlanMemoryLimit(TornadoExecutionContext.INIT_VALUE);
    }

    private long parseSizeToBytes(String sizeStr) {
        Matcher matcher = SIZE_PATTERN.matcher(sizeStr);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid size format");
        }
        long value = Long.parseLong(matcher.group(1));
        String units = matcher.group(2).toUpperCase();
        return switch (Objects.requireNonNull(units)) {
            case "MB" -> value * 1000000L;
            case "GB" -> value * 1000000000L;
            default -> throw new TornadoRuntimeException("Units not supported: " + units);
        };
    }

    public long getTotalTime() {
        return this.getProfilerValue(ProfilerType.TOTAL_TASK_GRAPH_TIME);
    }

    public long getCompileTime() {
        return this.getProfilerValue(ProfilerType.TOTAL_GRAAL_COMPILE_TIME) + this.getProfilerValue(ProfilerType.TOTAL_DRIVER_COMPILE_TIME);
    }

    public long getTornadoCompilerTime() {
        return this.getProfilerValue(ProfilerType.TOTAL_GRAAL_COMPILE_TIME);
    }

    public long getDriverInstallTime() {
        return this.getProfilerValue(ProfilerType.TOTAL_DRIVER_COMPILE_TIME);
    }

    public long getDataTransfersTime() {
        return this.getProfilerValue(ProfilerType.COPY_IN_TIME) + this.getProfilerValue(ProfilerType.COPY_OUT_TIME);
    }

    public long getDeviceWriteTime() {
        return this.getProfilerValue(ProfilerType.COPY_IN_TIME);
    }

    public long getDeviceReadTime() {
        return this.getProfilerValue(ProfilerType.COPY_OUT_TIME);
    }

    public long getDataTransferDispatchTime() {
        return this.getProfilerValue(ProfilerType.TOTAL_DISPATCH_DATA_TRANSFERS_TIME);
    }

    public long getKernelDispatchTime() {
        return this.getProfilerValue(ProfilerType.TOTAL_DISPATCH_KERNEL_TIME);
    }

    public long getDeviceKernelTime() {
        return this.getProfilerValue(ProfilerType.TOTAL_KERNEL_TIME);
    }

    private long getProfilerValueFromReduceTaskGraph(ProfilerType profilerType) {
        return switch (profilerType) {
            case ProfilerType.TOTAL_KERNEL_TIME -> this.reduceTaskGraph.getExecutionResult().getProfilerResult().getDeviceKernelTime();
            case ProfilerType.TOTAL_DISPATCH_KERNEL_TIME -> this.reduceTaskGraph.getExecutionResult().getProfilerResult().getKernelDispatchTime();
            case ProfilerType.TOTAL_DISPATCH_DATA_TRANSFERS_TIME -> this.reduceTaskGraph.getExecutionResult().getProfilerResult().getDataTransferDispatchTime();
            case ProfilerType.COPY_OUT_TIME -> this.reduceTaskGraph.getExecutionResult().getProfilerResult().getDeviceReadTime();
            case ProfilerType.COPY_IN_TIME -> this.reduceTaskGraph.getExecutionResult().getProfilerResult().getDeviceWriteTime();
            case ProfilerType.TOTAL_DRIVER_COMPILE_TIME -> this.reduceTaskGraph.getExecutionResult().getProfilerResult().getDriverInstallTime();
            case ProfilerType.TOTAL_GRAAL_COMPILE_TIME -> this.reduceTaskGraph.getExecutionResult().getProfilerResult().getTornadoCompilerTime();
            case ProfilerType.TOTAL_TASK_GRAPH_TIME -> this.reduceTaskGraph.getExecutionResult().getProfilerResult().getTotalTime();
            case ProfilerType.TOTAL_COPY_IN_SIZE_BYTES -> this.reduceTaskGraph.getExecutionResult().getProfilerResult().getTotalBytesCopyIn();
            case ProfilerType.TOTAL_COPY_OUT_SIZE_BYTES -> this.reduceTaskGraph.getExecutionResult().getProfilerResult().getTotalBytesCopyOut();
            case ProfilerType.ALLOCATION_BYTES -> this.reduceTaskGraph.getExecutionResult().getProfilerResult().getTotalDeviceMemoryUsage();
            default -> 0L;
        };
    }

    private long __getProfilerValue(ProfilerType profilerType) {
        return switch (profilerType) {
            case ProfilerType.TOTAL_KERNEL_TIME -> this.timeProfiler.getTimer(ProfilerType.TOTAL_KERNEL_TIME);
            case ProfilerType.TOTAL_DISPATCH_KERNEL_TIME -> this.timeProfiler.getTimer(ProfilerType.TOTAL_DISPATCH_KERNEL_TIME);
            case ProfilerType.TOTAL_DISPATCH_DATA_TRANSFERS_TIME -> this.timeProfiler.getTimer(ProfilerType.TOTAL_DISPATCH_DATA_TRANSFERS_TIME);
            case ProfilerType.COPY_OUT_TIME -> this.timeProfiler.getTimer(ProfilerType.COPY_OUT_TIME);
            case ProfilerType.COPY_IN_TIME -> this.timeProfiler.getTimer(ProfilerType.COPY_IN_TIME);
            case ProfilerType.TOTAL_DRIVER_COMPILE_TIME -> this.timeProfiler.getTimer(ProfilerType.TOTAL_DRIVER_COMPILE_TIME);
            case ProfilerType.TOTAL_GRAAL_COMPILE_TIME -> this.timeProfiler.getTimer(ProfilerType.TOTAL_GRAAL_COMPILE_TIME);
            case ProfilerType.TOTAL_TASK_GRAPH_TIME -> this.timeProfiler.getTimer(ProfilerType.TOTAL_TASK_GRAPH_TIME);
            case ProfilerType.TOTAL_COPY_IN_SIZE_BYTES -> this.timeProfiler.getSize(ProfilerType.TOTAL_COPY_IN_SIZE_BYTES);
            case ProfilerType.TOTAL_COPY_OUT_SIZE_BYTES -> this.timeProfiler.getSize(ProfilerType.TOTAL_COPY_OUT_SIZE_BYTES);
            case ProfilerType.ALLOCATION_BYTES -> this.timeProfiler.getSize(ProfilerType.ALLOCATION_BYTES);
            default -> 0L;
        };
    }

    private long getProfilerValue(ProfilerType profilerType) {
        if (this.reduceTaskGraph != null) {
            return this.getProfilerValueFromReduceTaskGraph(profilerType);
        }
        return this.__getProfilerValue(profilerType);
    }

    public String getProfileLog() {
        return this.bufferLogProfiler.toString();
    }

    public long getTotalBytesCopyIn() {
        return this.getProfilerValue(ProfilerType.TOTAL_COPY_IN_SIZE_BYTES);
    }

    public long getTotalBytesCopyOut() {
        return this.getProfilerValue(ProfilerType.TOTAL_COPY_OUT_SIZE_BYTES);
    }

    boolean isProfilerEnabled() {
        return this.getProfilerMode() != null || TornadoOptions.isProfilerEnabled();
    }

    ProfilerMode getProfilerMode() {
        return this.profilerMode;
    }

    private record CompileInfo(boolean compile, boolean updateDevice) {
    }
}

