/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.tasks;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.InvalidInstalledCodeException;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.nodes.StructuredGraph;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.common.TaskPackage;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.enums.TornadoDeviceType;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.exceptions.TornadoTaskRuntimeException;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.analyzer.CodeAnalysis;
import uk.ac.manchester.tornado.runtime.analyzer.MetaReduceCodeAnalysis;
import uk.ac.manchester.tornado.runtime.analyzer.MetaReduceTasks;
import uk.ac.manchester.tornado.runtime.analyzer.ReduceCodeAnalysis;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.tasks.ReduceFactory;
import uk.ac.manchester.tornado.runtime.tasks.StreamingObject;
import uk.ac.manchester.tornado.runtime.tasks.TornadoTaskGraph;
import uk.ac.manchester.tornado.runtime.tasks.meta.MetaDataUtils;

class ReduceTaskGraph {
    private static final String EXCEPTION_MESSAGE_ERROR = "[ERROR] reduce type not supported yet: ";
    private static final String OPERATION_NOT_SUPPORTED_MESSAGE = "Operation not supported";
    private static final String SEQUENTIAL_TASK_REDUCE_NAME = "reduce_seq";
    private static final int DEFAULT_GPU_WORK_GROUP = 256;
    private static final int DEFAULT_BACKEND_INDEX = 0;
    private static final int DEFAULT_DEVICE_INDEX = 0;
    private static AtomicInteger counterName = new AtomicInteger(0);
    private static AtomicInteger counterSeqName = new AtomicInteger(0);
    private final List<StreamingObject> inputModeObjects;
    private final List<StreamingObject> outputModeObjects;
    private final TornadoTaskGraph originalTaskGraph;
    private final Graph sketchGraph;
    private String idTaskGraph;
    private List<TaskPackage> taskPackages;
    private List<Object> streamOutObjects;
    private List<Object> streamInObjects;
    private Map<Object, Object> originalReduceVariables;
    private Map<Object, Object> hostHybridVariables;
    private List<Thread> threadSequentialExecution;
    private List<HybridThreadMeta> hybridThreadMetas;
    private Map<Object, Object> neutralElementsNew = new HashMap<Object, Object>();
    private Map<Object, Object> neutralElementsOriginal = new HashMap<Object, Object>();
    private TaskGraph rewrittenTaskGraph;
    private Map<Object, List<Integer>> reduceOperandTable;
    private boolean hybridMode;
    private Map<Object, ReduceCodeAnalysis.REDUCE_OPERATION> hybridMergeTable;
    private boolean hybridInitialized;
    private TornadoExecutionPlan executionPlan;
    private TornadoExecutionResult executionResult;

    ReduceTaskGraph(String taskScheduleID, List<TaskPackage> taskPackages, List<Object> streamInObjects, List<StreamingObject> streamingObjects, List<Object> streamOutObjects, List<StreamingObject> outputModeObjects, Graph graph, TornadoTaskGraph originalTaskGraph) {
        this.idTaskGraph = taskScheduleID;
        this.sketchGraph = graph;
        this.originalTaskGraph = originalTaskGraph;
        this.taskPackages = new ArrayList<TaskPackage>(taskPackages);
        this.streamInObjects = new ArrayList<Object>(streamInObjects);
        this.inputModeObjects = new ArrayList<StreamingObject>(streamingObjects);
        this.streamOutObjects = new ArrayList<Object>(streamOutObjects);
        this.outputModeObjects = new ArrayList<StreamingObject>(outputModeObjects);
    }

    private static int obtainSizeArrayResult(int driverIndex, int device, int inputSize) {
        TornadoDeviceType deviceType = TornadoCoreRuntime.getTornadoRuntime().getBackend(driverIndex).getDevice(device).getDeviceType();
        TornadoDevice deviceToRun = TornadoCoreRuntime.getTornadoRuntime().getBackend(driverIndex).getDevice(device);
        return switch (deviceType) {
            case TornadoDeviceType.CPU -> deviceToRun.getAvailableProcessors() + 1;
            case TornadoDeviceType.GPU, TornadoDeviceType.ACCELERATOR -> {
                if (inputSize > ReduceTaskGraph.calculateAcceleratorGroupSize(deviceToRun, inputSize)) {
                    yield inputSize / ReduceTaskGraph.calculateAcceleratorGroupSize(deviceToRun, inputSize) + 1;
                }
                yield 2;
            }
            default -> 0;
        };
    }

    private static int calculateAcceleratorGroupSize(TornadoDevice device, long globalWorkSize) {
        if (device.getPlatformName().contains("AMD")) {
            return 256;
        }
        int maxBlockSize = (int)device.getDeviceMaxWorkgroupDimensions()[0];
        if (maxBlockSize <= 0) {
            return 256;
        }
        if ((long)maxBlockSize == globalWorkSize) {
            maxBlockSize /= 4;
        }
        int value = (int)Math.min((long)maxBlockSize, globalWorkSize);
        while (globalWorkSize % (long)value != 0L) {
            --value;
        }
        return value;
    }

    private static void inspectBinariesFPGA(String taskScheduleName, String graphName, String taskName, boolean sequential) {
        String idTaskGraph = graphName + "." + taskName;
        StringBuilder originalBinaries = TornadoOptions.FPGA_BINARIES;
        if (originalBinaries != null) {
            String[] binaries = originalBinaries.toString().split(",");
            if (binaries.length == 1) {
                binaries = MetaDataUtils.processPrecompiledBinariesFromFile(binaries[0]);
                StringBuilder sb = new StringBuilder();
                for (String binary : binaries) {
                    sb.append(binary.replace(" ", "")).append(",");
                }
                sb = sb.deleteCharAt(sb.length() - 1);
                originalBinaries = new StringBuilder(sb.toString());
            }
            for (int i = 0; i < binaries.length; i += 2) {
                String givenTaskName = binaries[i + 1].split(".device")[0];
                if (!givenTaskName.equals(idTaskGraph)) continue;
                MetaDataUtils.BackendSelectionContainer info = MetaDataUtils.resolveDriverDeviceIndexes(MetaDataUtils.getProperty(idTaskGraph + ".device"));
                int deviceNumber = info.deviceIndex();
                if (!sequential) {
                    originalBinaries.append("," + binaries[i] + "," + taskScheduleName + "." + taskName + ".device=0:" + deviceNumber);
                    continue;
                }
                originalBinaries.append("," + binaries[i] + "," + taskScheduleName + ".reduce_seq" + String.valueOf(counterSeqName) + ".device=0:" + deviceNumber);
            }
            TornadoOptions.FPGA_BINARIES = originalBinaries;
        }
    }

    private boolean isAheadOfTime() {
        return TornadoOptions.FPGA_BINARIES != null;
    }

    private MetaDataUtils.BackendSelectionContainer changeDriverAndDeviceIfNeeded(String taskScheduleName, String graphName, String taskName) {
        boolean isDeviceDefined;
        String idTaskGraph = graphName + "." + taskName;
        boolean bl = isDeviceDefined = MetaDataUtils.getProperty(idTaskGraph + ".device") != null;
        if (isDeviceDefined) {
            MetaDataUtils.BackendSelectionContainer info = MetaDataUtils.resolveDriverDeviceIndexes(MetaDataUtils.getProperty(idTaskGraph + ".device"));
            int backendIndex = info.backendIndex();
            int deviceNumber = info.deviceIndex();
            TornadoRuntimeProvider.setProperty((String)(taskScheduleName + "." + taskName + ".device"), (String)(backendIndex + ":" + deviceNumber));
            return info;
        }
        return null;
    }

    private void fillOutputArrayWithNeutral(Object reduceArray, Object neutral) {
        Object object = reduceArray;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{int[].class, float[].class, double[].class, long[].class, IntArray.class, FloatArray.class, DoubleArray.class, LongArray.class}, (Object)object, n)) {
            case 0: {
                int[] ints = (int[])object;
                Arrays.fill(ints, (Integer)neutral);
                break;
            }
            case 1: {
                float[] floats = (float[])object;
                Arrays.fill(floats, ((Float)neutral).floatValue());
                break;
            }
            case 2: {
                double[] doubles = (double[])object;
                Arrays.fill(doubles, (Double)neutral);
                break;
            }
            case 3: {
                long[] longs = (long[])object;
                Arrays.fill(longs, (Long)neutral);
                break;
            }
            case 4: {
                IntArray intArray = (IntArray)object;
                intArray.init(((Integer)neutral).intValue());
                break;
            }
            case 5: {
                FloatArray floatArray = (FloatArray)object;
                floatArray.init(((Float)neutral).floatValue());
                break;
            }
            case 6: {
                DoubleArray doubleArray = (DoubleArray)object;
                doubleArray.init(((Double)neutral).doubleValue());
                break;
            }
            case 7: {
                LongArray longArray = (LongArray)object;
                longArray.init(((Long)neutral).longValue());
                break;
            }
            default: {
                throw new TornadoRuntimeException(EXCEPTION_MESSAGE_ERROR + String.valueOf(reduceArray.getClass()));
            }
        }
    }

    private Object createNewReduceArray(Object reduceVariable, int size) {
        Object object;
        if (size == 1) {
            return reduceVariable;
        }
        Object object2 = reduceVariable;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{int[].class, float[].class, double[].class, long[].class, IntArray.class, FloatArray.class, DoubleArray.class, LongArray.class}, (Object)object2, n)) {
            case 0: {
                int[] ints = (int[])object2;
                object = new int[size];
                break;
            }
            case 1: {
                float[] floats = (float[])object2;
                object = new float[size];
                break;
            }
            case 2: {
                double[] doubles = (double[])object2;
                object = new double[size];
                break;
            }
            case 3: {
                long[] longs = (long[])object2;
                object = new long[size];
                break;
            }
            case 4: {
                IntArray intArray;
                IntArray intArray2 = (IntArray)object2;
                object = intArray;
                intArray = new IntArray(size);
                break;
            }
            case 5: {
                FloatArray floatArray;
                FloatArray floatArray2 = (FloatArray)object2;
                object = floatArray;
                floatArray = new FloatArray(size);
                break;
            }
            case 6: {
                DoubleArray doubleArray;
                DoubleArray doubleArray2 = (DoubleArray)object2;
                object = doubleArray;
                doubleArray = new DoubleArray(size);
                break;
            }
            case 7: {
                LongArray longArray;
                LongArray longArray2 = (LongArray)object2;
                object = longArray;
                longArray = new LongArray(size);
                break;
            }
            default: {
                throw new TornadoRuntimeException(EXCEPTION_MESSAGE_ERROR + String.valueOf(reduceVariable.getClass()));
            }
        }
        return object;
    }

    private Object createNewReduceArray(Object reduceVariable) {
        Object object;
        Object object2 = reduceVariable;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{int[].class, float[].class, double[].class, long[].class, IntArray.class, FloatArray.class, DoubleArray.class, LongArray.class}, (Object)object2, n)) {
            case 0: {
                int[] ints = (int[])object2;
                object = new int[1];
                break;
            }
            case 1: {
                float[] floats = (float[])object2;
                object = new float[1];
                break;
            }
            case 2: {
                double[] doubles = (double[])object2;
                object = new double[1];
                break;
            }
            case 3: {
                long[] longs = (long[])object2;
                object = new long[1];
                break;
            }
            case 4: {
                IntArray intArray;
                IntArray intArray2 = (IntArray)object2;
                object = intArray;
                intArray = new IntArray(1);
                break;
            }
            case 5: {
                FloatArray floatArray;
                FloatArray floatArray2 = (FloatArray)object2;
                object = floatArray;
                floatArray = new FloatArray(1);
                break;
            }
            case 6: {
                DoubleArray doubleArray;
                DoubleArray doubleArray2 = (DoubleArray)object2;
                object = doubleArray;
                doubleArray = new DoubleArray(1);
                break;
            }
            case 7: {
                LongArray longArray;
                LongArray longArray2 = (LongArray)object2;
                object = longArray;
                longArray = new LongArray(1);
                break;
            }
            default: {
                throw new TornadoRuntimeException(EXCEPTION_MESSAGE_ERROR + String.valueOf(reduceVariable.getClass()));
            }
        }
        return object;
    }

    private Object getNeutralElement(Object originalArray) {
        Object object = originalArray;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{int[].class, float[].class, double[].class, long[].class, IntArray.class, FloatArray.class, DoubleArray.class, LongArray.class}, (Object)object, n)) {
            case 0 -> {
                int[] ints = (int[])object;
                yield ints[0];
            }
            case 1 -> {
                float[] floats = (float[])object;
                yield Float.valueOf(floats[0]);
            }
            case 2 -> {
                double[] doubles = (double[])object;
                yield doubles[0];
            }
            case 3 -> {
                long[] longs = (long[])object;
                yield longs[0];
            }
            case 4 -> {
                IntArray intArray = (IntArray)object;
                yield intArray.get(0);
            }
            case 5 -> {
                FloatArray floatArray = (FloatArray)object;
                yield Float.valueOf(floatArray.get(0));
            }
            case 6 -> {
                DoubleArray doubleArray = (DoubleArray)object;
                yield doubleArray.get(0);
            }
            case 7 -> {
                LongArray longArray = (LongArray)object;
                yield longArray.get(0);
            }
            default -> throw new TornadoRuntimeException(EXCEPTION_MESSAGE_ERROR + String.valueOf(originalArray.getClass()));
        };
    }

    private boolean isPowerOfTwo(long number) {
        return (number & number - 1L) == 0L;
    }

    private boolean isTaskEligibleSplitHostAndDevice(int targetDeviceToRun, long elementsReductionLeftOver) {
        if (elementsReductionLeftOver > 0L) {
            TornadoDeviceType deviceType = TornadoCoreRuntime.getTornadoRuntime().getBackend(0).getDevice(targetDeviceToRun).getDeviceType();
            return deviceType == TornadoDeviceType.GPU || deviceType == TornadoDeviceType.FPGA || deviceType == TornadoDeviceType.ACCELERATOR;
        }
        return false;
    }

    private void joinHostThreads() {
        if (this.threadSequentialExecution != null && !this.threadSequentialExecution.isEmpty()) {
            this.threadSequentialExecution.forEach(thread -> {
                try {
                    thread.join();
                    this.hybridInitialized = false;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private ReduceCompilationThread createCompilationThread(TaskPackage taskPackage, int sizeTargetDevice) {
        Object codeTask = taskPackage.getTaskParameters()[0];
        return new ReduceCompilationThread(codeTask, sizeTargetDevice);
    }

    private void updateStreamInOutVariables(Map<Integer, MetaReduceTasks> tableReduce) {
        for (int taskNumber = 0; taskNumber < this.taskPackages.size(); ++taskNumber) {
            int i;
            for (i = 0; i < this.streamInObjects.size(); ++i) {
                if (tableReduce.containsKey(taskNumber) && !this.reduceOperandTable.containsKey(this.streamInObjects.get(i))) {
                    LinkedList<Integer> taskList = new LinkedList<Integer>();
                    taskList.add(taskNumber);
                    this.reduceOperandTable.put(this.streamInObjects.get(i), taskList);
                }
                if (!this.originalReduceVariables.containsKey(this.streamInObjects.get(i))) continue;
                this.streamInObjects.set(i, this.originalReduceVariables.get(this.streamInObjects.get(i)));
            }
            for (Map.Entry<Object, Object> reduceArray : this.originalReduceVariables.entrySet()) {
                this.streamInObjects.add(reduceArray.getValue());
            }
            TornadoTaskGraph.performStreamInObject(this.rewrittenTaskGraph, this.streamInObjects, 1);
            for (StreamingObject so : this.inputModeObjects) {
                if (so.getMode() != 0) continue;
                TornadoTaskGraph.performStreamInObject(this.rewrittenTaskGraph, so.getObject(), 0);
            }
            for (i = 0; i < this.streamOutObjects.size(); ++i) {
                if (!this.originalReduceVariables.containsKey(this.streamOutObjects.get(i))) continue;
                Object newArray = this.originalReduceVariables.get(this.streamOutObjects.get(i));
                this.streamOutObjects.set(i, newArray);
            }
        }
    }

    private boolean isDeviceAnAccelerator(int deviceToRun) {
        TornadoDeviceType deviceType = TornadoRuntimeProvider.getTornadoRuntime().getBackend(0).getDevice(deviceToRun).getDeviceType();
        return deviceType == TornadoDeviceType.ACCELERATOR;
    }

    private void updateGlobalAndLocalDimensionsFPGA(int deviceToRun, String taskScheduleReduceName, TaskPackage taskPackage, int inputSize) {
        if (this.isAheadOfTime() && this.isDeviceAnAccelerator(deviceToRun)) {
            TornadoRuntimeProvider.setProperty((String)(taskScheduleReduceName + "." + taskPackage.getId() + ".global.workgroup.size"), (String)Integer.toString(inputSize));
            TornadoRuntimeProvider.setProperty((String)(taskScheduleReduceName + "." + taskPackage.getId() + ".local.workgroup.size"), (String)"64");
        }
    }

    private Object createHostArrayForHybridMode(Object originalReduceArray, TaskPackage taskPackage, int sizeTargetDevice) {
        this.hybridMode = true;
        if (this.hostHybridVariables == null) {
            this.hostHybridVariables = new HashMap<Object, Object>();
        }
        Object hybridArray = this.createNewReduceArray(originalReduceArray);
        Object neutralElement = this.getNeutralElement(originalReduceArray);
        this.fillOutputArrayWithNeutral(hybridArray, neutralElement);
        taskPackage.setNumThreadsToRun((long)sizeTargetDevice);
        return hybridArray;
    }

    TaskGraph scheduleWithReduction(MetaReduceCodeAnalysis metaReduceTable) {
        int taskNumber;
        assert (metaReduceTable != null);
        Map<Integer, MetaReduceTasks> tableReduce = metaReduceTable.getTable();
        String taskScheduleReduceName = "__GENERATED_TASK_GRAPH__" + counterName.get();
        String graphName = this.idTaskGraph;
        HashMap streamReduceTable = new HashMap();
        ArrayList<Integer> sizesReductionArray = new ArrayList<Integer>();
        if (this.originalReduceVariables == null) {
            this.originalReduceVariables = new HashMap<Object, Object>();
        }
        if (this.reduceOperandTable == null) {
            this.reduceOperandTable = new HashMap<Object, List<Integer>>();
        }
        int backendToRun = 0;
        int deviceToRun = 0;
        for (taskNumber = 0; taskNumber < this.taskPackages.size(); ++taskNumber) {
            TaskPackage taskPackage = this.taskPackages.get(taskNumber);
            ArrayList<Object> streamReduceList = new ArrayList<Object>();
            MetaDataUtils.BackendSelectionContainer selectionContainer = this.changeDriverAndDeviceIfNeeded(taskScheduleReduceName, graphName, taskPackage.getId());
            if (selectionContainer != null) {
                backendToRun = selectionContainer.backendIndex();
                deviceToRun = selectionContainer.deviceIndex();
            }
            ReduceTaskGraph.inspectBinariesFPGA(taskScheduleReduceName, graphName, taskPackage.getId(), false);
            if (!tableReduce.containsKey(taskNumber)) continue;
            MetaReduceTasks metaReduceTasks = tableReduce.get(taskNumber);
            ArrayList<Integer> listOfReduceIndexParameters = metaReduceTasks.getListOfReduceParameters(taskNumber);
            int inputSize = 0;
            for (Integer paramIndex : listOfReduceIndexParameters) {
                Object originalReduceArray = taskPackage.getTaskParameters()[paramIndex + 1];
                if (this.originalReduceVariables.containsKey(originalReduceArray)) continue;
                inputSize = metaReduceTasks.getInputSize(taskNumber);
                this.updateGlobalAndLocalDimensionsFPGA(deviceToRun, taskScheduleReduceName, taskPackage, inputSize);
                boolean isInputPowerOfTwo = this.isPowerOfTwo(inputSize);
                Object hostHybridModeArray = null;
                if (!isInputPowerOfTwo) {
                    int exp = (int)(Math.log(inputSize) / Math.log(2.0));
                    double closestPowerOf2 = Math.pow(2.0, exp);
                    int elementsReductionLeftOver = (int)((double)inputSize - closestPowerOf2);
                    int sizeTargetDevice = inputSize -= elementsReductionLeftOver;
                    if (this.isTaskEligibleSplitHostAndDevice(deviceToRun, elementsReductionLeftOver)) {
                        hostHybridModeArray = this.createHostArrayForHybridMode(originalReduceArray, taskPackage, sizeTargetDevice);
                    }
                }
                int sizeReductionArray = ReduceTaskGraph.obtainSizeArrayResult(backendToRun, deviceToRun, inputSize);
                Object newDeviceArray = this.createNewReduceArray(originalReduceArray, sizeReductionArray);
                Object neutralElement = this.getNeutralElement(originalReduceArray);
                this.fillOutputArrayWithNeutral(newDeviceArray, neutralElement);
                this.neutralElementsNew.put(newDeviceArray, neutralElement);
                this.neutralElementsOriginal.put(originalReduceArray, neutralElement);
                streamReduceList.add(newDeviceArray);
                sizesReductionArray.add(sizeReductionArray);
                this.originalReduceVariables.put(originalReduceArray, newDeviceArray);
                if (!this.hybridMode) continue;
                this.hostHybridVariables.put(newDeviceArray, hostHybridModeArray);
            }
            streamReduceTable.put(taskNumber, streamReduceList);
            if (!this.hybridMode) continue;
            ReduceCompilationThread compilationThread = this.createCompilationThread(taskPackage, inputSize);
            compilationThread.start();
            if (this.threadSequentialExecution == null) {
                this.threadSequentialExecution = new ArrayList<Thread>();
            }
            HybridThreadMeta meta = new HybridThreadMeta(taskPackage, compilationThread);
            if (this.hybridThreadMetas == null) {
                this.hybridThreadMetas = new ArrayList<HybridThreadMeta>();
            }
            this.hybridThreadMetas.add(meta);
            SequentialExecutionThread sequentialExecutionThread = new SequentialExecutionThread(compilationThread, taskPackage, this.hostHybridVariables);
            this.threadSequentialExecution.add(sequentialExecutionThread);
            sequentialExecutionThread.start();
            this.hybridInitialized = true;
        }
        this.rewrittenTaskGraph = new TaskGraph(taskScheduleReduceName);
        this.updateStreamInOutVariables(metaReduceTable.getTable());
        for (taskNumber = 0; taskNumber < this.taskPackages.size(); ++taskNumber) {
            int i;
            TaskPackage taskPackage = this.taskPackages.get(taskNumber);
            int taskType = this.taskPackages.get(taskNumber).getTaskType();
            for (i = 0; i < taskType; ++i) {
                Object value;
                Object key = this.taskPackages.get(taskNumber).getTaskParameters()[i + 1];
                if (!this.originalReduceVariables.containsKey(key)) continue;
                this.taskPackages.get((int)taskNumber).getTaskParameters()[i + 1] = value = this.originalReduceVariables.get(key);
            }
            if (tableReduce.containsKey(taskNumber)) {
                for (i = 0; i < this.taskPackages.get(taskNumber).getTaskParameters().length - 1; ++i) {
                    Object parameterToMethod = this.taskPackages.get(taskNumber).getTaskParameters()[i + 1];
                    if (!this.reduceOperandTable.containsKey(parameterToMethod) || this.reduceOperandTable.get(parameterToMethod).size() <= 1) continue;
                    this.rewrittenTaskGraph.transferToDevice(0, new Object[]{parameterToMethod});
                }
            }
            this.rewrittenTaskGraph.addTask(this.taskPackages.get(taskNumber));
            if (!tableReduce.containsKey(taskNumber)) continue;
            MetaReduceTasks metaReduceTasks = tableReduce.get(taskNumber);
            ArrayList<Integer> listOfReduceParameters = metaReduceTasks.getListOfReduceParameters(taskNumber);
            StructuredGraph graph = metaReduceTasks.getGraph();
            List<ReduceCodeAnalysis.REDUCE_OPERATION> operations = ReduceCodeAnalysis.getReduceOperation(graph, listOfReduceParameters);
            if (operations.isEmpty()) {
                operations = ReduceCodeAnalysis.getReduceOperatorFromSketch(this.sketchGraph, listOfReduceParameters);
            }
            List streamUpdateList = (List)streamReduceTable.get(taskNumber);
            for (int i2 = 0; i2 < streamUpdateList.size(); ++i2) {
                Object newArray = streamUpdateList.get(i2);
                int sizeReduceArray = (Integer)sizesReductionArray.get(i2);
                for (ReduceCodeAnalysis.REDUCE_OPERATION operation : operations) {
                    String newTaskSequentialName = SEQUENTIAL_TASK_REDUCE_NAME + counterSeqName.get();
                    String fullName = this.rewrittenTaskGraph.getTaskGraphName() + "." + newTaskSequentialName;
                    TornadoRuntimeProvider.setProperty((String)(fullName + ".device"), (String)(backendToRun + ":" + deviceToRun));
                    ReduceTaskGraph.inspectBinariesFPGA(taskScheduleReduceName, graphName, taskPackage.getId(), true);
                    switch (operation) {
                        case SUM: {
                            ReduceFactory.handleAdd(newArray, this.rewrittenTaskGraph, sizeReduceArray, newTaskSequentialName);
                            break;
                        }
                        case MUL: {
                            ReduceFactory.handleMul(newArray, this.rewrittenTaskGraph, sizeReduceArray, newTaskSequentialName);
                            break;
                        }
                        case MAX: {
                            ReduceFactory.handleMax(newArray, this.rewrittenTaskGraph, sizeReduceArray, newTaskSequentialName);
                            break;
                        }
                        case MIN: {
                            ReduceFactory.handleMin(newArray, this.rewrittenTaskGraph, sizeReduceArray, newTaskSequentialName);
                            break;
                        }
                        default: {
                            throw new TornadoRuntimeException("[ERROR] Reduce operation not supported yet.");
                        }
                    }
                    if (this.hybridMode) {
                        if (this.hybridMergeTable == null) {
                            this.hybridMergeTable = new HashMap<Object, ReduceCodeAnalysis.REDUCE_OPERATION>();
                        }
                        this.hybridMergeTable.put(newArray, operation);
                    }
                    counterSeqName.incrementAndGet();
                }
            }
        }
        TornadoTaskGraph.performStreamOutThreads(1, this.rewrittenTaskGraph, this.streamOutObjects);
        ImmutableTaskGraph immutableTaskGraph = this.rewrittenTaskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        this.executeExpression();
        counterName.incrementAndGet();
        return this.rewrittenTaskGraph;
    }

    private boolean checkAllArgumentsPerTask() {
        for (TaskPackage task : this.taskPackages) {
            Object[] taskParameters = task.getTaskParameters();
            for (int i = 1; i < taskParameters.length - 1; ++i) {
                Object parameter = taskParameters[i];
                if (parameter instanceof Number || parameter instanceof KernelContext || this.rewrittenTaskGraph.getArgumentsLookup().contains(parameter)) continue;
                throw new TornadoTaskRuntimeException("Parameter #" + i + " <" + String.valueOf(parameter) + "> from task <" + task.getId() + "> not specified either in `transferToDevice` or `transferToHost` functions");
            }
        }
        return true;
    }

    TornadoExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    void executeExpression() {
        if (this.originalTaskGraph.isProfilerEnabled()) {
            this.executionPlan.withProfiler(this.originalTaskGraph.getProfilerMode());
        } else {
            this.executionPlan.withoutProfiler();
        }
        if (this.originalTaskGraph.meta().isPrintKernelEnabled()) {
            this.executionPlan.withPrintKernel();
        } else {
            this.executionPlan.withoutPrintKernel();
        }
        if (this.originalTaskGraph.meta().isThreadInfoEnabled()) {
            this.executionPlan.withThreadInfo();
        } else {
            this.executionPlan.withoutThreadInfo();
        }
        if (TornadoOptions.FORCE_CHECK_PARAMETERS) {
            this.checkAllArgumentsPerTask();
        }
        this.setNeutralElement();
        if (this.hybridMode && !this.hybridInitialized) {
            this.hybridInitialized = true;
            this.threadSequentialExecution.clear();
            for (HybridThreadMeta meta : this.hybridThreadMetas) {
                this.threadSequentialExecution.add(new SequentialExecutionThread(meta.compilationThread, meta.taskPackage, this.hostHybridVariables));
            }
            this.threadSequentialExecution.forEach(Thread::start);
        }
        this.executionResult = this.executionPlan.execute();
        this.updateOutputArrays();
    }

    private void setNeutralElement() {
        Object neutralElement;
        for (Map.Entry<Object, Object> pair : this.neutralElementsNew.entrySet()) {
            Object newArray = pair.getKey();
            neutralElement = pair.getValue();
            this.fillOutputArrayWithNeutral(newArray, neutralElement);
            if (this.hostHybridVariables == null || !this.hostHybridVariables.containsKey(newArray)) continue;
            Object arrayCPU = this.hostHybridVariables.get(newArray);
            this.fillOutputArrayWithNeutral(arrayCPU, neutralElement);
        }
        for (Map.Entry<Object, Object> pair : this.neutralElementsOriginal.entrySet()) {
            Object originalArray = pair.getKey();
            neutralElement = pair.getValue();
            this.fillOutputArrayWithNeutral(originalArray, neutralElement);
        }
    }

    private int operateFinalReduction(int a, int b, ReduceCodeAnalysis.REDUCE_OPERATION operation) {
        return switch (operation) {
            case ReduceCodeAnalysis.REDUCE_OPERATION.SUM -> a + b;
            case ReduceCodeAnalysis.REDUCE_OPERATION.MUL -> a * b;
            case ReduceCodeAnalysis.REDUCE_OPERATION.MAX -> Math.max(a, b);
            case ReduceCodeAnalysis.REDUCE_OPERATION.MIN -> Math.min(a, b);
            default -> throw new TornadoRuntimeException(OPERATION_NOT_SUPPORTED_MESSAGE);
        };
    }

    private float operateFinalReduction(float a, float b, ReduceCodeAnalysis.REDUCE_OPERATION operation) {
        return switch (operation) {
            case ReduceCodeAnalysis.REDUCE_OPERATION.SUM -> a + b;
            case ReduceCodeAnalysis.REDUCE_OPERATION.MUL -> a * b;
            case ReduceCodeAnalysis.REDUCE_OPERATION.MAX -> Math.max(a, b);
            case ReduceCodeAnalysis.REDUCE_OPERATION.MIN -> Math.min(a, b);
            default -> throw new TornadoRuntimeException(OPERATION_NOT_SUPPORTED_MESSAGE);
        };
    }

    private double operateFinalReduction(double a, double b, ReduceCodeAnalysis.REDUCE_OPERATION operation) {
        return switch (operation) {
            case ReduceCodeAnalysis.REDUCE_OPERATION.SUM -> a + b;
            case ReduceCodeAnalysis.REDUCE_OPERATION.MUL -> a * b;
            case ReduceCodeAnalysis.REDUCE_OPERATION.MAX -> Math.max(a, b);
            case ReduceCodeAnalysis.REDUCE_OPERATION.MIN -> Math.min(a, b);
            default -> throw new TornadoRuntimeException(OPERATION_NOT_SUPPORTED_MESSAGE);
        };
    }

    private long operateFinalReduction(long a, long b, ReduceCodeAnalysis.REDUCE_OPERATION operation) {
        return switch (operation) {
            case ReduceCodeAnalysis.REDUCE_OPERATION.SUM -> a + b;
            case ReduceCodeAnalysis.REDUCE_OPERATION.MUL -> a * b;
            case ReduceCodeAnalysis.REDUCE_OPERATION.MAX -> Math.max(a, b);
            case ReduceCodeAnalysis.REDUCE_OPERATION.MIN -> Math.min(a, b);
            default -> throw new TornadoRuntimeException(OPERATION_NOT_SUPPORTED_MESSAGE);
        };
    }

    private void updateVariableFromAccelerator(Object originalReduceVariable, Object newArray) {
        Object object = newArray;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{int[].class, float[].class, double[].class, long[].class, IntArray.class, FloatArray.class, DoubleArray.class, LongArray.class}, (Object)object2, n)) {
            case 0: {
                int[] intArray = (int[])object2;
                ((int[])originalReduceVariable)[0] = intArray[0];
                break;
            }
            case 1: {
                float[] floatArray = (float[])object2;
                ((float[])originalReduceVariable)[0] = floatArray[0];
                break;
            }
            case 2: {
                double[] doubleArray = (double[])object2;
                ((double[])originalReduceVariable)[0] = doubleArray[0];
                break;
            }
            case 3: {
                long[] longArray = (long[])object2;
                ((long[])originalReduceVariable)[0] = longArray[0];
                break;
            }
            case 4: {
                IntArray panamaIntArray = (IntArray)object2;
                ((IntArray)originalReduceVariable).set(0, panamaIntArray.get(0));
                break;
            }
            case 5: {
                FloatArray panamaFloatArray = (FloatArray)object2;
                ((FloatArray)originalReduceVariable).set(0, panamaFloatArray.get(0));
                break;
            }
            case 6: {
                DoubleArray panamaDoubleArray = (DoubleArray)object2;
                ((DoubleArray)originalReduceVariable).set(0, panamaDoubleArray.get(0));
                break;
            }
            case 7: {
                LongArray panamaLongArray = (LongArray)object2;
                ((LongArray)originalReduceVariable).set(0, panamaLongArray.get(0));
                break;
            }
            default: {
                throw new TornadoRuntimeException("[ERROR] Reduce data type not supported yet: " + newArray.getClass().getTypeName());
            }
        }
    }

    private void mergeHybridMode(Object originalReduceVariable, Object newArray) {
        Object object = newArray;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{int[].class, float[].class, double[].class, long[].class, IntArray.class, FloatArray.class, DoubleArray.class, LongArray.class}, (Object)object2, n)) {
            case 0: {
                int[] intArray = (int[])object2;
                int a = ((int[])this.hostHybridVariables.get(intArray))[0];
                int b = intArray[0];
                ((int[])originalReduceVariable)[0] = this.operateFinalReduction(a, b, this.hybridMergeTable.get(intArray));
                break;
            }
            case 1: {
                float[] floatArray = (float[])object2;
                float af = ((float[])this.hostHybridVariables.get(floatArray))[0];
                float bf = floatArray[0];
                ((float[])originalReduceVariable)[0] = this.operateFinalReduction(af, bf, this.hybridMergeTable.get(floatArray));
                break;
            }
            case 2: {
                double[] doubleArray = (double[])object2;
                double ad = ((double[])this.hostHybridVariables.get(doubleArray))[0];
                double bd = doubleArray[0];
                ((double[])originalReduceVariable)[0] = this.operateFinalReduction(ad, bd, this.hybridMergeTable.get(doubleArray));
                break;
            }
            case 3: {
                long[] longArray = (long[])object2;
                long al = ((long[])this.hostHybridVariables.get(longArray))[0];
                long bl = longArray[0];
                ((long[])originalReduceVariable)[0] = this.operateFinalReduction(al, bl, this.hybridMergeTable.get(longArray));
                break;
            }
            case 4: {
                IntArray panamaIntArray = (IntArray)object2;
                int ani = ((IntArray)this.hostHybridVariables.get(panamaIntArray)).get(0);
                int bni = panamaIntArray.get(0);
                ((IntArray)originalReduceVariable).set(0, this.operateFinalReduction(ani, bni, this.hybridMergeTable.get(panamaIntArray)));
                break;
            }
            case 5: {
                FloatArray panamaFloatArray = (FloatArray)object2;
                float anf = ((FloatArray)this.hostHybridVariables.get(panamaFloatArray)).get(0);
                float bnf = panamaFloatArray.get(0);
                ((FloatArray)originalReduceVariable).set(0, this.operateFinalReduction(anf, bnf, this.hybridMergeTable.get(panamaFloatArray)));
                break;
            }
            case 6: {
                DoubleArray panamaDoubleArray = (DoubleArray)object2;
                double and = ((DoubleArray)this.hostHybridVariables.get(panamaDoubleArray)).get(0);
                double bnd = panamaDoubleArray.get(0);
                ((DoubleArray)originalReduceVariable).set(0, this.operateFinalReduction(and, bnd, this.hybridMergeTable.get(panamaDoubleArray)));
                break;
            }
            case 7: {
                LongArray panamaLongArray = (LongArray)object2;
                long anl = ((LongArray)this.hostHybridVariables.get(panamaLongArray)).get(0);
                long bnl = panamaLongArray.get(0);
                ((LongArray)originalReduceVariable).set(0, this.operateFinalReduction(anl, bnl, this.hybridMergeTable.get(panamaLongArray)));
                break;
            }
            default: {
                throw new TornadoRuntimeException("[ERROR] Reduce data type not supported yet: " + newArray.getClass().getTypeName());
            }
        }
    }

    private void updateOutputArrays() {
        this.joinHostThreads();
        for (Map.Entry<Object, Object> pair : this.originalReduceVariables.entrySet()) {
            Object originalReduceVariable = pair.getKey();
            Object newArray = pair.getValue();
            if (this.hostHybridVariables != null && this.hostHybridVariables.containsKey(newArray)) {
                this.mergeHybridMode(originalReduceVariable, newArray);
                continue;
            }
            this.updateVariableFromAccelerator(originalReduceVariable, newArray);
        }
    }

    private static class ReduceCompilationThread
    extends Thread {
        private final int sizeTargetDevice;
        private final Object codeTask;
        private InstalledCode code;
        private boolean finished;

        ReduceCompilationThread(Object codeTask, int sizeTargetDevice) {
            this.codeTask = codeTask;
            this.sizeTargetDevice = sizeTargetDevice;
        }

        public InstalledCode getCode() {
            return this.code;
        }

        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public void run() {
            StructuredGraph originalGraph = CodeAnalysis.buildHighLevelGraalGraph(this.codeTask);
            assert (originalGraph != null);
            StructuredGraph graph = (StructuredGraph)originalGraph.copy(TornadoCoreRuntime.getDebugContext());
            ReduceCodeAnalysis.performLoopBoundNodeSubstitution(graph, this.sizeTargetDevice);
            this.code = CodeAnalysis.compileAndInstallMethod(graph);
            this.finished = true;
        }
    }

    private static class HybridThreadMeta {
        private final TaskPackage taskPackage;
        private final ReduceCompilationThread compilationThread;

        HybridThreadMeta(TaskPackage taskPackage, ReduceCompilationThread compilationThread) {
            this.taskPackage = taskPackage;
            this.compilationThread = compilationThread;
        }
    }

    private static class SequentialExecutionThread
    extends Thread {
        final ReduceCompilationThread compilationThread;
        private final TaskPackage taskPackage;
        private final Map<Object, Object> hostHybridVariables;

        SequentialExecutionThread(ReduceCompilationThread compilationThread, TaskPackage taskPackage, Map<Object, Object> hostHybridVariables) {
            this.compilationThread = compilationThread;
            this.taskPackage = taskPackage;
            this.hostHybridVariables = hostHybridVariables;
        }

        private void runBinaryCodeForReduction(TaskPackage taskPackage, InstalledCode code, Map<Object, Object> hostHybridVariables) {
            try {
                int numArgs = taskPackage.getTaskParameters().length - 1;
                Object[] args = new Object[numArgs];
                for (int i = 0; i < numArgs; ++i) {
                    Object argument = taskPackage.getTaskParameters()[i + 1];
                    args[i] = hostHybridVariables.getOrDefault(argument, argument);
                }
                code.executeVarargs(args);
            }
            catch (InvalidInstalledCodeException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            try {
                this.compilationThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.runBinaryCodeForReduction(this.taskPackage, this.compilationThread.getCode(), this.hostHybridVariables);
        }
    }
}

