/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.tasks;

import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;

class ReduceFactory {
    private static final String ERROR_MESSAGE = "[ERROR] Reduce data type not supported yet: ";

    ReduceFactory() {
    }

    private static void rAdd(int[] array, int size) {
        int acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc += array[i];
        }
        array[0] = acc;
    }

    private static void rAdd(long[] array, int size) {
        long acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc += array[i];
        }
        array[0] = acc;
    }

    private static void rAdd(float[] array, int size) {
        float acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc += array[i];
        }
        array[0] = acc;
    }

    private static void rAdd(double[] array, int size) {
        double acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc += array[i];
        }
        array[0] = acc;
    }

    private static void rAdd(FloatArray array, int size) {
        float acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc += array.get(i);
        }
        array.set(0, acc);
    }

    private static void rAdd(IntArray array, int size) {
        int acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc += array.get(i);
        }
        array.set(0, acc);
    }

    private static void rAdd(DoubleArray array, int size) {
        double acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc += array.get(i);
        }
        array.set(0, acc);
    }

    private static void rAdd(LongArray array, int size) {
        long acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc += array.get(i);
        }
        array.set(0, acc);
    }

    private static void rMul(int[] array, int size) {
        int acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc *= array[i];
        }
        array[0] = acc;
    }

    private static void rMul(long[] array, int size) {
        long acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc *= array[i];
        }
        array[0] = acc;
    }

    private static void rMul(float[] array, int size) {
        float acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc *= array[i];
        }
        array[0] = acc;
    }

    private static void rMul(double[] array, int size) {
        double acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc *= array[i];
        }
        array[0] = acc;
    }

    private static void rMul(IntArray array, int size) {
        int acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc *= array.get(i);
        }
        array.set(0, acc);
    }

    private static void rMul(FloatArray array, int size) {
        float acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc *= array.get(i);
        }
        array.set(0, acc);
    }

    private static void rMul(DoubleArray array, int size) {
        double acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc *= array.get(i);
        }
        array.set(0, acc);
    }

    private static void rMul(LongArray array, int size) {
        long acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc *= array.get(i);
        }
        array.set(0, acc);
    }

    private static void rMax(int[] array, int size) {
        int acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc = Math.max(acc, array[i]);
        }
        array[0] = acc;
    }

    private static void rMax(long[] array, int size) {
        long acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc = Math.max(acc, array[i]);
        }
        array[0] = acc;
    }

    private static void rMax(float[] array, int size) {
        float acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc = Math.max(acc, array[i]);
        }
        array[0] = acc;
    }

    private static void rMax(double[] array, int size) {
        double acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc = Math.max(acc, array[i]);
        }
        array[0] = acc;
    }

    private static void rMax(IntArray array, int size) {
        int acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc = Math.max(acc, array.get(i));
        }
        array.set(0, acc);
    }

    private static void rMax(FloatArray array, int size) {
        float acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc = Math.max(acc, array.get(i));
        }
        array.set(0, acc);
    }

    private static void rMax(DoubleArray array, int size) {
        double acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc = Math.max(acc, array.get(i));
        }
        array.set(0, acc);
    }

    private static void rMax(LongArray array, int size) {
        long acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc = Math.max(acc, array.get(i));
        }
        array.set(0, acc);
    }

    private static void rMin(int[] array, int size) {
        int acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc = Math.min(acc, array[i]);
        }
        array[0] = acc;
    }

    private static void rMin(long[] array, int size) {
        long acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc = Math.min(acc, array[i]);
        }
        array[0] = acc;
    }

    private static void rMin(float[] array, int size) {
        float acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc = Math.min(acc, array[i]);
        }
        array[0] = acc;
    }

    private static void rMin(double[] array, int size) {
        double acc = array[0];
        for (int i = 1; i < size; ++i) {
            acc = Math.min(acc, array[i]);
        }
        array[0] = acc;
    }

    private static void rMin(IntArray array, int size) {
        int acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc = Math.min(acc, array.get(i));
        }
        array.set(0, acc);
    }

    private static void rMin(FloatArray array, int size) {
        float acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc = Math.min(acc, array.get(i));
        }
        array.set(0, acc);
    }

    private static void rMin(DoubleArray array, int size) {
        double acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc = Math.min(acc, array.get(i));
        }
        array.set(0, acc);
    }

    private static void rMin(LongArray array, int size) {
        long acc = array.get(0);
        for (int i = 1; i < size; ++i) {
            acc = Math.min(acc, array.get(i));
        }
        array.set(0, acc);
    }

    static void handleAdd(Object newArray, TaskGraph task, int sizeReduceArray, String taskName) {
        switch (newArray.getClass().getTypeName()) {
            case "int[]": {
                task.task(taskName, ReduceFactory::rAdd, (Object)((int[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "long[]": {
                task.task(taskName, ReduceFactory::rAdd, (Object)((long[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "float[]": {
                task.task(taskName, ReduceFactory::rAdd, (Object)((float[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "double[]": {
                task.task(taskName, ReduceFactory::rAdd, (Object)((double[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.IntArray": {
                task.task(taskName, ReduceFactory::rAdd, (Object)((IntArray)newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.FloatArray": {
                task.task(taskName, ReduceFactory::rAdd, (Object)((FloatArray)newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.DoubleArray": {
                task.task(taskName, ReduceFactory::rAdd, (Object)((DoubleArray)newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.LongArray": {
                task.task(taskName, ReduceFactory::rAdd, (Object)((LongArray)newArray), (Object)sizeReduceArray);
                break;
            }
            default: {
                throw new TornadoRuntimeException(ERROR_MESSAGE + newArray.getClass().getTypeName());
            }
        }
    }

    static void handleMul(Object newArray, TaskGraph task, int sizeReduceArray, String taskName) {
        switch (newArray.getClass().getTypeName()) {
            case "int[]": {
                task.task(taskName, ReduceFactory::rMul, (Object)((int[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "long[]": {
                task.task(taskName, ReduceFactory::rMul, (Object)((long[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "float[]": {
                task.task(taskName, ReduceFactory::rMul, (Object)((float[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "double[]": {
                task.task(taskName, ReduceFactory::rMul, (Object)((double[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.IntArray": {
                task.task(taskName, ReduceFactory::rMul, (Object)((IntArray)newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.FloatArray": {
                task.task(taskName, ReduceFactory::rMul, (Object)((FloatArray)newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.DoubleArray": {
                task.task(taskName, ReduceFactory::rMul, (Object)((DoubleArray)newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.LongArray": {
                task.task(taskName, ReduceFactory::rMul, (Object)((LongArray)newArray), (Object)sizeReduceArray);
                break;
            }
            default: {
                throw new TornadoRuntimeException(ERROR_MESSAGE + newArray.getClass().getTypeName());
            }
        }
    }

    static void handleMax(Object newArray, TaskGraph task, int sizeReduceArray, String taskName) {
        switch (newArray.getClass().getTypeName()) {
            case "int[]": {
                task.task(taskName, ReduceFactory::rMax, (Object)((int[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "long[]": {
                task.task(taskName, ReduceFactory::rMax, (Object)((long[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "float[]": {
                task.task(taskName, ReduceFactory::rMax, (Object)((float[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "double[]": {
                task.task(taskName, ReduceFactory::rMax, (Object)((double[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.IntArray": {
                task.task(taskName, ReduceFactory::rMax, (Object)((IntArray)newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.FloatArray": {
                task.task(taskName, ReduceFactory::rMax, (Object)((FloatArray)newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.DoubleArray": {
                task.task(taskName, ReduceFactory::rMax, (Object)((DoubleArray)newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.LongArray": {
                task.task(taskName, ReduceFactory::rMax, (Object)((LongArray)newArray), (Object)sizeReduceArray);
                break;
            }
            default: {
                throw new TornadoRuntimeException(ERROR_MESSAGE + newArray.getClass().getTypeName());
            }
        }
    }

    static void handleMin(Object newArray, TaskGraph task, int sizeReduceArray, String taskName) {
        switch (newArray.getClass().getTypeName()) {
            case "int[]": {
                task.task(taskName, ReduceFactory::rMin, (Object)((int[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "long[]": {
                task.task(taskName, ReduceFactory::rMin, (Object)((long[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "float[]": {
                task.task(taskName, ReduceFactory::rMin, (Object)((float[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "double[]": {
                task.task(taskName, ReduceFactory::rMin, (Object)((double[])newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.IntArray": {
                task.task(taskName, ReduceFactory::rMin, (Object)((IntArray)newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.FloatArray": {
                task.task(taskName, ReduceFactory::rMin, (Object)((FloatArray)newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.DoubleArray": {
                task.task(taskName, ReduceFactory::rMin, (Object)((DoubleArray)newArray), (Object)sizeReduceArray);
                break;
            }
            case "uk.ac.manchester.tornado.api.types.arrays.LongArray": {
                task.task(taskName, ReduceFactory::rMin, (Object)((LongArray)newArray), (Object)sizeReduceArray);
                break;
            }
            default: {
                throw new TornadoRuntimeException(ERROR_MESSAGE + newArray.getClass().getTypeName());
            }
        }
    }
}

