/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.tasks;

import java.util.Objects;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.SchedulableTask;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.tasks.CompilableTask;
import uk.ac.manchester.tornado.runtime.tasks.meta.ScheduleContext;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class PrebuiltTask
implements SchedulableTask {
    private final Object[] args;
    private TaskDataContext meta;
    private final String entryPoint;
    private final String filename;
    private final Access[] argumentsAccess;
    protected long batchThreads;
    protected int batchNumber;
    protected long batchSize;
    private TornadoProfiler profiler;
    private boolean forceCompiler;
    private int[] atomics;

    public PrebuiltTask(ScheduleContext scheduleMeta, String id, String entryPoint, String filename, Object[] args, Access[] access) {
        this.entryPoint = entryPoint;
        this.filename = filename;
        this.args = args;
        this.argumentsAccess = access;
        this.meta = new TaskDataContext(scheduleMeta, id, access.length);
        this.meta.setArgumentsAccess(access);
    }

    public void setAtomics(int[] atomics) {
        this.atomics = atomics;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("task: ").append(this.entryPoint).append("()\n");
        for (int i = 0; i < this.args.length; ++i) {
            sb.append(String.format("arg  : [%s] %s\n", this.argumentsAccess[i], this.args[i]));
        }
        sb.append("meta : ").append(this.meta.toString());
        return sb.toString();
    }

    public Object[] getArguments() {
        return this.args;
    }

    public Access[] getArgumentsAccess() {
        return this.argumentsAccess;
    }

    public TaskDataContext meta() {
        return this.meta;
    }

    public void setDevice(TornadoDevice device) {
        this.meta.setDevice(device);
    }

    public TornadoXPUDevice getDevice() {
        return this.meta.getXPUDevice();
    }

    public String getFullName() {
        return "task - " + this.meta.getId() + "[" + this.entryPoint + "]";
    }

    public String getNormalizedName() {
        return this.meta.getId() + "." + this.entryPoint;
    }

    public String getTaskName() {
        return this.entryPoint;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getEntryPoint() {
        return this.getTaskName();
    }

    public String getId() {
        return this.meta.getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompilableTask) {
            CompilableTask other = (CompilableTask)obj;
            return this.getId().equals(other.getId());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.getId());
        hash = 71 * hash + Objects.hashCode(this.entryPoint);
        hash = 71 * hash + Objects.hashCode(this.filename);
        return hash;
    }

    public long getBatchThreads() {
        return this.batchThreads;
    }

    public void setBatchThreads(long batchThreads) {
        this.batchThreads = batchThreads;
    }

    public void setBatchNumber(int batchNumber) {
        this.batchNumber = batchNumber;
    }

    public int getBatchNumber() {
        return this.batchNumber;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public void attachProfiler(TornadoProfiler tornadoProfiler) {
        this.profiler = tornadoProfiler;
    }

    public TornadoProfiler getProfiler() {
        return this.profiler;
    }

    public void forceCompilation() {
        this.forceCompiler = true;
    }

    public boolean shouldCompile() {
        return this.forceCompiler;
    }

    public void enableDefaultThreadScheduler(boolean useDefaultScheduler) {
        this.meta.enableDefaultThreadScheduler(useDefaultScheduler);
    }

    public void setUseGridScheduler(boolean use) {
        this.meta.setUseGridScheduler(use);
    }

    public void setGridScheduler(GridScheduler gridScheduler) {
        this.meta.setGridScheduler(gridScheduler);
    }

    public boolean isGridSchedulerEnabled() {
        return this.meta.isGridSchedulerEnabled();
    }

    public int[] getAtomics() {
        return this.atomics;
    }
}

