/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.tasks;

import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.memory.DeviceBufferState;
import uk.ac.manchester.tornado.runtime.common.XPUDeviceBufferState;
import uk.ac.manchester.tornado.runtime.tasks.DataObjectState;

public class LocalObjectState {
    private boolean streamIn;
    private boolean forceStreamIn;
    private boolean streamOut;
    private boolean underDemand;
    private boolean onDevice;
    private DataObjectState dataObjectState;
    private Object object;

    public LocalObjectState(Object object) {
        this.object = object;
        this.dataObjectState = new DataObjectState();
        this.streamIn = false;
        this.streamOut = false;
        this.underDemand = false;
        this.onDevice = false;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean isStreamIn() {
        return this.streamIn;
    }

    public boolean isUnderDemand() {
        return this.underDemand;
    }

    public void enableUnderDemand() {
        this.underDemand = true;
    }

    public void setOnDevice(boolean isOnDevice) {
        this.onDevice = isOnDevice;
    }

    public boolean isOnDevice() {
        return this.onDevice;
    }

    public void setStreamIn(boolean streamIn) {
        this.streamIn = streamIn;
    }

    public void setForceStreamIn(boolean streamIn) {
        this.forceStreamIn = streamIn;
    }

    public boolean isForcedStreamIn() {
        return this.forceStreamIn;
    }

    public boolean isStreamOut() {
        return this.streamOut;
    }

    public void setStreamOut(boolean streamOut) {
        this.streamOut = streamOut;
    }

    public DataObjectState getDataObjectState() {
        return this.dataObjectState;
    }

    public Event sync(long executionPlanId, Object object, TornadoDevice device) {
        XPUDeviceBufferState deviceState = this.dataObjectState.getDeviceBufferState(device);
        if (deviceState.isLockedBuffer()) {
            int eventId = device.streamOutBlocking(executionPlanId, object, 0L, (DeviceBufferState)deviceState, null);
            return device.resolveEvent(executionPlanId, eventId);
        }
        return null;
    }

    public LocalObjectState clone() {
        LocalObjectState newLocalObjectState = new LocalObjectState(this.object);
        newLocalObjectState.streamIn = this.streamIn;
        newLocalObjectState.streamOut = this.streamOut;
        newLocalObjectState.forceStreamIn = this.forceStreamIn;
        newLocalObjectState.underDemand = this.underDemand;
        newLocalObjectState.dataObjectState = this.dataObjectState.clone();
        newLocalObjectState.onDevice = this.onDevice;
        return newLocalObjectState;
    }

    public String toString() {
        return (this.streamIn ? "SIN" : "--") + (this.streamOut ? "SOUT" : "--") + " " + String.valueOf(this.dataObjectState);
    }
}

