/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.tasks;

import java.util.concurrent.ConcurrentHashMap;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.memory.ObjectState;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.common.XPUDeviceBufferState;

public class DataObjectState
implements ObjectState {
    private ConcurrentHashMap<TornadoXPUDevice, XPUDeviceBufferState> deviceStates = new ConcurrentHashMap();

    public XPUDeviceBufferState getDeviceBufferState(TornadoDevice device) {
        if (!(device instanceof TornadoXPUDevice)) {
            throw new TornadoRuntimeException("[ERROR] Device not compatible: " + String.valueOf(device.getClass()));
        }
        if (!this.deviceStates.containsKey(device)) {
            this.deviceStates.put((TornadoXPUDevice)device, new XPUDeviceBufferState());
        }
        return this.deviceStates.get(device);
    }

    public DataObjectState clone() {
        DataObjectState dataObjectState = new DataObjectState();
        dataObjectState.deviceStates = new ConcurrentHashMap();
        ((ConcurrentHashMap.KeySetView)this.deviceStates.keySet()).forEach(device -> {
            XPUDeviceBufferState xpuDeviceBufferState = this.deviceStates.get(device).createSnapshot();
            dataObjectState.deviceStates.put((TornadoXPUDevice)device, xpuDeviceBufferState);
        });
        return dataObjectState;
    }

    public void clear() {
        this.deviceStates.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TornadoXPUDevice device : this.deviceStates.keySet()) {
            sb.append(device.toString()).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

