/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.tasks;

import java.lang.reflect.Method;
import java.util.Objects;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.SchedulableTask;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.tasks.meta.ScheduleContext;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class CompilableTask
implements SchedulableTask {
    protected final Object[] args;
    protected final Method method;
    private final Object[] resolvedArgs;
    protected TaskDataContext meta;
    protected boolean shouldCompile;
    private long batchNumThreads;
    private int batchNumber;
    private long batchSize;
    private TornadoProfiler profiler;
    private boolean forceCompiler;

    public CompilableTask(ScheduleContext meta, String id, Method method, Object ... args) {
        this.method = method;
        this.args = args;
        this.shouldCompile = true;
        this.resolvedArgs = args;
        this.meta = TaskDataContext.create(meta, id, method);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("task: ").append(this.meta.getId()).append(" ").append(this.method.getName()).append("()\n");
        Access[] argumentsAccess = this.meta.getArgumentsAccess();
        for (int i = 0; i < this.args.length; ++i) {
            buffer.append(String.format("arg  : [%s] %s -> %s%n", argumentsAccess[i], this.args[i], this.resolvedArgs[i]));
        }
        buffer.append("meta : ").append(this.meta.toString());
        return buffer.toString();
    }

    public Object[] getArguments() {
        return this.resolvedArgs;
    }

    public Access[] getArgumentsAccess() {
        return this.meta.getArgumentsAccess();
    }

    public TornadoXPUDevice getDevice() {
        return this.meta.getXPUDevice();
    }

    public String getFullName() {
        return "task " + this.meta.getId() + " - " + this.method.getName();
    }

    public String getNormalizedName() {
        return this.meta.getId() + "." + this.method.getName();
    }

    public String getTaskName() {
        return this.method.getName();
    }

    public void setDevice(TornadoDevice device) {
        this.meta.setDevice(device);
    }

    public TaskDataContext meta() {
        return this.meta;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getId() {
        return this.meta.getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompilableTask) {
            CompilableTask other = (CompilableTask)obj;
            return this.getId().equals(other.getId());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.getId());
        hash = 71 * hash + Objects.hashCode(this.method);
        return hash;
    }

    public long getBatchThreads() {
        return this.batchNumThreads;
    }

    public void setBatchThreads(long batchThreads) {
        this.batchNumThreads = batchThreads;
    }

    public void setBatchNumber(int batchNumber) {
        this.batchNumber = batchNumber;
    }

    public int getBatchNumber() {
        return this.batchNumber;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public void attachProfiler(TornadoProfiler tornadoProfiler) {
        this.profiler = tornadoProfiler;
    }

    public TornadoProfiler getProfiler() {
        return this.profiler;
    }

    public void forceCompilation() {
        this.forceCompiler = true;
    }

    public boolean shouldCompile() {
        return this.forceCompiler;
    }

    public void enableDefaultThreadScheduler(boolean useDefaultScheduler) {
        this.meta.enableDefaultThreadScheduler(useDefaultScheduler);
    }

    public void setUseGridScheduler(boolean use) {
        this.meta.setUseGridScheduler(use);
    }

    public void setGridScheduler(GridScheduler gridScheduler) {
        this.meta.setGridScheduler(gridScheduler);
    }

    public boolean isGridSchedulerEnabled() {
        return this.meta.isGridSchedulerEnabled();
    }
}

