/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.sketcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpScope;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.util.Providers;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoBailoutRuntimeException;
import uk.ac.manchester.tornado.api.exceptions.TornadoInliningException;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.OCLTokens;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoCompilerIdentifier;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoSketchTier;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoSketchTierContext;
import uk.ac.manchester.tornado.runtime.sketcher.Sketch;
import uk.ac.manchester.tornado.runtime.sketcher.SketchRequest;

public class TornadoSketcher {
    private static final AtomicInteger sketchId = new AtomicInteger(0);
    private static final Map<ResolvedJavaMethod, List<TornadoSketcherCacheEntry>> cache = new ConcurrentHashMap<ResolvedJavaMethod, List<TornadoSketcherCacheEntry>>();
    private static final TimerKey Sketcher = DebugContext.timer((CharSequence)"Sketcher");
    private static final OptimisticOptimizations optimisticOpts = OptimisticOptimizations.ALL;
    private static TornadoLogger logger = new TornadoLogger();
    public static Access[] methodAccesses;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cacheContainsSketch(ResolvedJavaMethod method, int driverIndex, int deviceIndex) {
        List<TornadoSketcherCacheEntry> entries = cache.get(method);
        if (entries == null) {
            return false;
        }
        List<TornadoSketcherCacheEntry> list = entries;
        synchronized (list) {
            for (TornadoSketcherCacheEntry entry : entries) {
                if (!entry.matchesDriverAndDevice(driverIndex, deviceIndex)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sketch lookup(ResolvedJavaMethod resolvedMethod, int driverIndex, int deviceIndex) {
        Sketch sketch = null;
        TornadoInternalError.guarantee((boolean)cache.containsKey(resolvedMethod), (String)"cache miss for: %s", (Object[])new Object[]{resolvedMethod.getName()});
        List<TornadoSketcherCacheEntry> entries = cache.get(resolvedMethod);
        try {
            List<TornadoSketcherCacheEntry> list = entries;
            synchronized (list) {
                for (TornadoSketcherCacheEntry entry : entries) {
                    if (!entry.matchesDriverAndDevice(driverIndex, deviceIndex)) continue;
                    sketch = entry.getSketchFuture().get();
                    break;
                }
            }
            TornadoInternalError.guarantee((sketch != null ? 1 : 0) != 0, (String)"No sketch available for %d:%d %s", (Object[])new Object[]{driverIndex, deviceIndex, resolvedMethod.getName()});
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable cause;
            logger.fatal("Failed to retrieve sketch for %d:%d %s ", driverIndex, deviceIndex, resolvedMethod.getName());
            if (TornadoOptions.DEBUG) {
                e.printStackTrace();
            }
            if ((cause = e.getCause()) instanceof TornadoInliningException) {
                TornadoInliningException inliningException = (TornadoInliningException)cause;
                throw inliningException;
            }
            if (cause instanceof TornadoRuntimeException) {
                TornadoRuntimeException runtimeException = (TornadoRuntimeException)cause;
                throw runtimeException;
            }
            if (cause instanceof TornadoBailoutRuntimeException) {
                TornadoBailoutRuntimeException bailoutRuntimeException = (TornadoBailoutRuntimeException)cause;
                throw bailoutRuntimeException;
            }
            throw new TornadoInternalError(cause);
        }
        return sketch;
    }

    static void buildSketch(SketchRequest request) {
        if (TornadoSketcher.cacheContainsSketch(request.resolvedMethod, request.driverIndex, request.deviceIndex)) {
            return;
        }
        List sketches = cache.computeIfAbsent(request.resolvedMethod, k -> Collections.synchronizedList(new ArrayList(TornadoVMBackendType.values().length)));
        Future<Sketch> result = TornadoCoreRuntime.getTornadoExecutor().submit(new TornadoSketcherCallable(request));
        sketches.add(new TornadoSketcherCacheEntry(request.driverIndex, request.deviceIndex, result));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Sketch buildSketch(ResolvedJavaMethod resolvedMethod, Providers providers, PhaseSuite<HighTierContext> graphBuilderSuite, TornadoSketchTier sketchTier, int backendIndex, int deviceIndex) {
        logger.info("Building sketch of %s::%s", resolvedMethod.getDeclaringClass().getName(), resolvedMethod.getName());
        TornadoCompilerIdentifier id = new TornadoCompilerIdentifier("sketch-" + resolvedMethod.getName(), sketchId.getAndIncrement());
        StructuredGraph.Builder builder = new StructuredGraph.Builder(TornadoCoreRuntime.getOptions(), TornadoCoreRuntime.getDebugContext(), StructuredGraph.AllowAssumptions.YES);
        builder.method(resolvedMethod);
        builder.compilationId((CompilationIdentifier)id);
        builder.name("sketch-" + resolvedMethod.getName());
        StructuredGraph graph = builder.build();
        if (OCLTokens.openCLTokens.contains(resolvedMethod.getName())) {
            throw new TornadoRuntimeException("[ERROR] Java method name corresponds to an OpenCL Token. Change the Java method's name: " + resolvedMethod.getName());
        }
        try (DebugContext.Scope ignored = TornadoCoreRuntime.getDebugContext().scope((Object)"Tornado-Sketcher", (Object)new DebugDumpScope("Tornado-Sketcher"));){
            Sketch sketch;
            block19: {
                DebugCloseable ignored1 = Sketcher.start(TornadoCoreRuntime.getDebugContext());
                try {
                    TornadoSketchTierContext highTierContext = new TornadoSketchTierContext(providers, graphBuilderSuite, optimisticOpts, resolvedMethod, backendIndex, deviceIndex);
                    if (graph.start().next() == null) {
                        graphBuilderSuite.apply(graph, (Object)highTierContext);
                        new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional).apply(graph);
                    } else {
                        TornadoCoreRuntime.getDebugContext().dump(1, (Object)graph, "initial state");
                    }
                    sketchTier.apply(graph, (Object)highTierContext);
                    graph.maybeCompress();
                    graph.getInvokes().forEach(invoke -> {
                        if (OCLTokens.openCLTokens.contains(invoke.callTarget().targetMethod().getName())) {
                            throw new TornadoRuntimeException("[ERROR] Java method name corresponds to an OpenCL Token. Change the Java method's name: " + invoke.callTarget().targetMethod().getName());
                        }
                        SketchRequest newRequest = new SketchRequest(invoke.callTarget().targetMethod(), providers, graphBuilderSuite, sketchTier, backendIndex, deviceIndex);
                        TornadoSketcher.buildSketch(newRequest);
                    });
                    Access[] highTierAccesses = highTierContext.getAccesses();
                    graph.getInvokes().forEach(invoke -> {
                        Sketch sketch = TornadoSketcher.lookup(invoke.callTarget().targetMethod(), backendIndex, deviceIndex);
                        TornadoSketcher.mergeAccesses(highTierAccesses, invoke.callTarget(), sketch.getArgumentsAccess());
                    });
                    methodAccesses = highTierAccesses;
                    sketch = new Sketch(graph.copy(TornadoCoreRuntime.getDebugContext()), methodAccesses, highTierContext.getBatchWriteThreadIndex());
                    if (ignored1 == null) break block19;
                }
                catch (Throwable throwable) {
                    if (ignored1 != null) {
                        try {
                            ignored1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored1.close();
            }
            return sketch;
        }
        catch (Throwable e) {
            logger.fatal("unable to build sketch for method: %s (%s)", resolvedMethod.getName(), e.getMessage());
            if (TornadoOptions.DEBUG) {
                e.printStackTrace();
            }
            if (e instanceof TornadoInliningException) {
                throw new TornadoInliningException(e.getMessage());
            }
            throw new TornadoBailoutRuntimeException("Unable to build sketch for method: " + resolvedMethod.getName() + " (" + e.getMessage() + ")");
        }
    }

    private static void mergeAccesses(Access[] callerAccesses, CallTargetNode callTarget, Access[] calleeAccesses) {
        int index;
        List callArgs = callTarget.arguments().snapshot();
        int n = index = callTarget.targetMethod().isStatic() ? 0 : 1;
        while (index < callArgs.size()) {
            ValueNode callArg = (ValueNode)callArgs.get(index);
            if (callArg instanceof ParameterNode) {
                ParameterNode param = (ParameterNode)callArg;
                int paramIndex = param.index();
                Access calleeAcc = calleeAccesses[index];
                Access callerAcc = callerAccesses[paramIndex];
                callerAccesses[paramIndex] = Access.asArray()[callerAcc.position | calleeAcc.position];
            }
            ++index;
        }
    }

    private static final class TornadoSketcherCacheEntry {
        private final int driverIndex;
        private final int deviceIndex;
        private final Future<Sketch> sketchFuture;

        private TornadoSketcherCacheEntry(int driverIndex, int deviceIndex, Future<Sketch> sketchFuture) {
            this.driverIndex = driverIndex;
            this.deviceIndex = deviceIndex;
            this.sketchFuture = sketchFuture;
        }

        public boolean matchesDriverAndDevice(int driverIndex, int deviceIndex) {
            return this.driverIndex == driverIndex && this.deviceIndex == deviceIndex;
        }

        public Future<Sketch> getSketchFuture() {
            return this.sketchFuture;
        }
    }

    private static class TornadoSketcherCallable
    implements Callable<Sketch> {
        private final SketchRequest request;

        TornadoSketcherCallable(SketchRequest request) {
            this.request = request;
        }

        @Override
        public Sketch call() {
            Sketch sketch;
            block9: {
                DebugContext.Scope ignored = TornadoCoreRuntime.getDebugContext().scope((Object)"SketchCompiler");
                try {
                    sketch = TornadoSketcher.buildSketch(this.request.resolvedMethod, this.request.providers, this.request.graphBuilderSuite, this.request.sketchTier, this.request.driverIndex, this.request.deviceIndex);
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        if (e instanceof TornadoInliningException) {
                            throw (TornadoInliningException)e;
                        }
                        throw TornadoCoreRuntime.getDebugContext().handle(e);
                    }
                }
                ignored.close();
            }
            return sketch;
        }
    }
}

