/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.profiler;

import java.util.HashMap;
import java.util.Set;
import uk.ac.manchester.tornado.api.profiler.ProfilerType;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class TimeProfiler
implements TornadoProfiler {
    public static String NO_TASK_NAME = "noTask";
    private HashMap<ProfilerType, Long> profilerTime = new HashMap();
    private HashMap<String, HashMap<ProfilerType, Long>> taskTimers = new HashMap();
    private HashMap<String, HashMap<ProfilerType, String>> taskPowerMetrics = new HashMap();
    private HashMap<String, HashMap<ProfilerType, Long>> taskSizeMetrics;
    private HashMap<String, HashMap<ProfilerType, String>> taskDeviceIdentifiers = new HashMap();
    private HashMap<String, HashMap<ProfilerType, String>> taskMethodNames = new HashMap();
    private HashMap<String, HashMap<ProfilerType, String>> taskBackends;
    private StringBuilder indent;

    public TimeProfiler() {
        this.taskSizeMetrics = new HashMap();
        this.taskBackends = new HashMap();
        this.indent = new StringBuilder("");
    }

    public synchronized void addValueToMetric(ProfilerType type, String taskName, long value) {
        HashMap<ProfilerType, Long> profilerType;
        if (!this.taskSizeMetrics.containsKey(taskName)) {
            this.taskSizeMetrics.put(taskName, new HashMap());
        }
        profilerType.put(type, (profilerType = this.taskSizeMetrics.get(taskName)).get(type) != null ? profilerType.get(type) + value : value);
        this.taskSizeMetrics.put(taskName, profilerType);
    }

    public synchronized void start(ProfilerType type) {
        long start = System.nanoTime();
        this.profilerTime.put(type, start);
    }

    public synchronized void start(ProfilerType type, String taskName) {
        long start = System.nanoTime();
        if (!this.taskTimers.containsKey(taskName)) {
            this.taskTimers.put(taskName, new HashMap());
        }
        HashMap<ProfilerType, Long> profilerType = this.taskTimers.get(taskName);
        profilerType.put(type, start);
        this.taskTimers.put(taskName, profilerType);
    }

    public synchronized void registerMethodHandle(ProfilerType type, String taskName, String methodName) {
        if (!this.taskMethodNames.containsKey(taskName)) {
            this.taskMethodNames.put(taskName, new HashMap());
        }
        HashMap<ProfilerType, String> profilerType = this.taskMethodNames.get(taskName);
        profilerType.put(type, methodName);
        this.taskMethodNames.put(methodName, profilerType);
    }

    public synchronized void registerDeviceName(String taskName, String deviceInfo) {
        if (!this.taskDeviceIdentifiers.containsKey(taskName)) {
            this.taskDeviceIdentifiers.put(taskName, new HashMap());
        }
        HashMap<ProfilerType, String> profilerType = this.taskDeviceIdentifiers.get(taskName);
        profilerType.put(ProfilerType.DEVICE, deviceInfo);
        this.taskDeviceIdentifiers.put(taskName, profilerType);
    }

    public synchronized void registerBackend(String taskName, String backend) {
        if (!this.taskBackends.containsKey(taskName)) {
            this.taskBackends.put(taskName, new HashMap());
        }
        HashMap<ProfilerType, String> profilerType = this.taskBackends.get(taskName);
        profilerType.put(ProfilerType.BACKEND, backend);
        this.taskBackends.put(taskName, profilerType);
    }

    public synchronized void registerDeviceID(String taskName, String deviceID) {
        if (!this.taskDeviceIdentifiers.containsKey(taskName)) {
            this.taskDeviceIdentifiers.put(taskName, new HashMap());
        }
        HashMap<ProfilerType, String> profilerType = this.taskDeviceIdentifiers.get(taskName);
        profilerType.put(ProfilerType.DEVICE_ID, deviceID);
        this.taskDeviceIdentifiers.put(taskName, profilerType);
    }

    public synchronized void stop(ProfilerType type) {
        long end = System.nanoTime();
        long start = this.profilerTime.get(type);
        long total = end - start;
        this.profilerTime.put(type, total);
    }

    public synchronized void stop(ProfilerType type, String taskName) {
        long end = System.nanoTime();
        HashMap<ProfilerType, Long> profiledType = this.taskTimers.get(taskName);
        long start = profiledType.get(type);
        long total = end - start;
        profiledType.put(type, total);
        this.taskTimers.put(taskName, profiledType);
    }

    public long getTimer(ProfilerType type) {
        if (!this.profilerTime.containsKey(type)) {
            return 0L;
        }
        return this.profilerTime.get(type);
    }

    public long getSize(ProfilerType type) {
        Set<String> strings = this.taskSizeMetrics.keySet();
        long size = 0L;
        for (String s : this.taskSizeMetrics.keySet()) {
            HashMap<ProfilerType, Long> copySizes = this.taskSizeMetrics.get(s);
            if (!copySizes.containsKey(type)) continue;
            size += copySizes.get(type).longValue();
        }
        return size;
    }

    public long getTaskTimer(ProfilerType type, String taskName) {
        if (!this.taskTimers.containsKey(taskName)) {
            return 0L;
        }
        if (!this.taskTimers.get(taskName).containsKey(type)) {
            return 0L;
        }
        return this.taskTimers.get(taskName).get(type);
    }

    public synchronized void setTimer(ProfilerType type, long time) {
        this.profilerTime.put(type, time);
    }

    public synchronized void dump() {
        for (ProfilerType profilerType : this.profilerTime.keySet()) {
            System.out.println("[PROFILER] " + profilerType.getDescription() + ": " + String.valueOf(this.profilerTime.get(profilerType)));
        }
        for (String string : this.taskTimers.keySet()) {
            System.out.println("[PROFILER-TASK] " + string + ": " + String.valueOf(this.taskTimers.get(string)));
        }
    }

    private void increaseIndent() {
        this.indent.append("    ");
    }

    private void decreaseIndent() {
        this.indent.delete(this.indent.length() - 4, this.indent.length());
    }

    private void closeScope(StringBuilder json) {
        json.append(this.indent.toString() + "}");
    }

    private void newLine(StringBuilder json) {
        json.append("\n");
    }

    /*
     * WARNING - void declaration
     */
    public String createJson(StringBuilder json, String sectionName) {
        json.append("{\n");
        this.increaseIndent();
        json.append(this.indent.toString() + "\"" + sectionName + "\": {\n");
        this.increaseIndent();
        for (ProfilerType profilerType : this.profilerTime.keySet()) {
            json.append(this.indent.toString() + "\"" + String.valueOf(profilerType) + "\": \"" + String.valueOf(this.profilerTime.get(profilerType)) + "\",\n");
        }
        if (this.taskSizeMetrics.containsKey(NO_TASK_NAME)) {
            HashMap<ProfilerType, Long> noTaskValues = this.taskSizeMetrics.get(NO_TASK_NAME);
            for (ProfilerType p : noTaskValues.keySet()) {
                json.append(this.indent.toString() + "\"" + String.valueOf(p) + "\": \"" + String.valueOf(noTaskValues.get(p)) + "\",\n");
            }
        }
        int size = this.taskTimers.keySet().size();
        boolean bl = false;
        for (String p : this.taskTimers.keySet()) {
            void var4_9;
            json.append(this.indent.toString() + "\"" + p + "\": {\n");
            this.increaseIndent();
            ++var4_9;
            if (TornadoOptions.LOG_IP) {
                json.append(this.indent.toString() + "\"IP\": \"" + RuntimeUtilities.getTornadoInstanceIP() + "\",\n");
            }
            json.append(this.indent.toString() + "\"" + String.valueOf(ProfilerType.BACKEND) + "\": \"" + this.taskBackends.get(p).get(ProfilerType.BACKEND) + "\",\n");
            json.append(this.indent.toString() + "\"" + String.valueOf(ProfilerType.METHOD) + "\": \"" + this.taskMethodNames.get(p).get(ProfilerType.METHOD) + "\",\n");
            json.append(this.indent.toString() + "\"" + String.valueOf(ProfilerType.DEVICE_ID) + "\": \"" + this.taskDeviceIdentifiers.get(p).get(ProfilerType.DEVICE_ID) + "\",\n");
            json.append(this.indent.toString() + "\"" + String.valueOf(ProfilerType.DEVICE) + "\": \"" + this.taskDeviceIdentifiers.get(p).get(ProfilerType.DEVICE) + "\",\n");
            if (this.taskSizeMetrics.containsKey(p)) {
                for (ProfilerType p1 : this.taskSizeMetrics.get(p).keySet()) {
                    json.append(this.indent.toString() + "\"" + String.valueOf(p1) + "\": \"" + String.valueOf(this.taskSizeMetrics.get(p).get(p1)) + "\",\n");
                }
            }
            if (this.taskPowerMetrics.containsKey(p)) {
                for (ProfilerType p1 : this.taskPowerMetrics.get(p).keySet()) {
                    json.append(this.indent.toString() + "\"" + String.valueOf(p1) + "\": \"" + this.taskPowerMetrics.get(p).get(p1) + "\",\n");
                }
            }
            for (ProfilerType p2 : this.taskTimers.get(p).keySet()) {
                json.append(this.indent.toString() + "\"" + String.valueOf(p2) + "\": \"" + String.valueOf(this.taskTimers.get(p).get(p2)) + "\",\n");
            }
            json.delete(json.length() - 2, json.length() - 1);
            this.decreaseIndent();
            this.closeScope(json);
            if (var4_9 != size) {
                json.append(", ");
            }
            this.newLine(json);
        }
        this.decreaseIndent();
        this.closeScope(json);
        this.newLine(json);
        this.decreaseIndent();
        this.closeScope(json);
        this.newLine(json);
        return json.toString();
    }

    public synchronized void dumpJson(StringBuilder json, String id) {
        String jsonContent = this.createJson(json, id);
        System.out.println(jsonContent);
    }

    public synchronized void clean() {
        this.taskSizeMetrics.clear();
        this.profilerTime.clear();
        this.taskTimers.clear();
        this.indent = new StringBuilder("");
    }

    public synchronized void setTaskTimer(ProfilerType type, String taskID, long timer) {
        if (!this.taskTimers.containsKey(taskID)) {
            this.taskTimers.put(taskID, new HashMap());
        }
        this.taskTimers.get(taskID).put(type, timer);
    }

    public synchronized void setTaskPowerUsage(ProfilerType type, String taskID, long power) {
        if (!this.taskPowerMetrics.containsKey(taskID)) {
            this.taskPowerMetrics.put(taskID, new HashMap());
        }
        if (power > 0L) {
            this.taskPowerMetrics.get(taskID).put(type, Long.toString(power));
        } else {
            this.taskPowerMetrics.get(taskID).put(type, "n/a");
        }
    }

    public void setSystemPowerConsumption(ProfilerType systemPowerConsumptionType, String taskID, long powerConsumption) {
        if (!this.taskPowerMetrics.containsKey(taskID)) {
            this.taskPowerMetrics.put(taskID, new HashMap());
        }
        if (powerConsumption > 0L) {
            this.taskPowerMetrics.get(taskID).put(systemPowerConsumptionType, Long.toString(powerConsumption));
        } else {
            this.taskPowerMetrics.get(taskID).put(systemPowerConsumptionType, "n/a");
        }
    }

    public void setSystemVoltage(ProfilerType systemPowerVoltageType, String taskID, long voltage) {
        if (!this.taskPowerMetrics.containsKey(taskID)) {
            this.taskPowerMetrics.put(taskID, new HashMap());
        }
        if (voltage > 0L) {
            this.taskPowerMetrics.get(taskID).put(systemPowerVoltageType, Float.toString(voltage));
        } else {
            this.taskPowerMetrics.get(taskID).put(systemPowerVoltageType, "n/a");
        }
    }

    public synchronized void sum(ProfilerType acc, long value) {
        long sum = this.getTimer(acc) + value;
        this.profilerTime.put(acc, sum);
    }
}

