/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.profiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graalvm.compiler.nodes.StructuredGraph;
import uk.ac.manchester.tornado.api.TornadoDeviceContext;
import uk.ac.manchester.tornado.runtime.common.Tornado;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.common.TornadoVMClient;
import uk.ac.manchester.tornado.runtime.profiler.ProfilerCodeFeatures;
import uk.ac.manchester.tornado.runtime.utils.JsonHandler;

public final class FeatureExtractionUtilities {
    private static final String FEATURES_DIRECTORY = Tornado.getProperty("tornado.features.dump.dir", "");
    private static final String LOOKUP_BUFFER_ADDRESS_NAME = "kernellookupBufferAddress";

    private FeatureExtractionUtilities() {
    }

    public static void emitFeatureProfileJsonFile(LinkedHashMap<ProfilerCodeFeatures, Integer> entry, StructuredGraph graph, TornadoDeviceContext deviceContext) {
        String name = graph.name.split("-")[1];
        if (!name.equals(LOOKUP_BUFFER_ADDRESS_NAME)) {
            HashMap<CallSite, LinkedHashMap<String, Integer>> task = new HashMap<CallSite, LinkedHashMap<String, Integer>>();
            String fullName = FeatureExtractionUtilities.getBaseClass(graph.method().getDeclaringClass().toClassName()) + "." + name;
            task.put((CallSite)((Object)fullName), FeatureExtractionUtilities.encodeFeatureMap(entry));
            JsonHandler jsonHandler = new JsonHandler();
            String json = jsonHandler.createJSon(FeatureExtractionUtilities.encodeFeatureMap(entry), fullName, deviceContext);
            if (!FEATURES_DIRECTORY.isEmpty()) {
                File fileLog = new File(FEATURES_DIRECTORY);
                try (FileWriter file = new FileWriter(fileLog, fileLog.exists());){
                    file.write(json);
                    file.write("\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println(json);
            }
            if (!TornadoOptions.SOCKET_PORT.isEmpty()) {
                TornadoVMClient tornadoVMClient = new TornadoVMClient();
                try {
                    tornadoVMClient.sentLogOverSocket(json);
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
        }
    }

    private static String getBaseClass(String fullDeclaredClass) {
        String[] baseClass = fullDeclaredClass.split("\\.");
        String baseCl = baseClass[baseClass.length - 1];
        if (baseCl.contains("$")) {
            baseCl = baseCl.split("\\$")[baseCl.length() - 1];
        }
        return baseCl;
    }

    private static LinkedHashMap<String, Integer> encodeFeatureMap(LinkedHashMap<ProfilerCodeFeatures, Integer> entry) {
        LinkedHashMap<String, Integer> encodeMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry<ProfilerCodeFeatures, Integer> ent : entry.entrySet()) {
            encodeMap.put(ent.getKey().toString(), ent.getValue());
        }
        return encodeMap;
    }

    public static LinkedHashMap<ProfilerCodeFeatures, Integer> initializeFeatureMap() {
        LinkedHashMap<ProfilerCodeFeatures, Integer> myMap = new LinkedHashMap<ProfilerCodeFeatures, Integer>();
        for (ProfilerCodeFeatures feature : ProfilerCodeFeatures.values()) {
            myMap.put(feature, 0);
        }
        return myMap;
    }
}

