/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.interpreter;

import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;

public class InterpreterUtilities {
    static String debugHighLightBC(String bc) {
        return "\u001b[31m " + bc + " \u001b[0m";
    }

    static String debugHighLightNonExecBC(String bc) {
        return "\u001b[33m " + bc + " \u001b[0m";
    }

    static String debugHighLightHelper(String info) {
        return "\u001b[34m" + info + " \u001b[0m";
    }

    static String debugDeviceBC(TornadoXPUDevice device) {
        TornadoVMBackendType tornadoVMBackend = device.getTornadoVMBackend();
        if (tornadoVMBackend == TornadoVMBackendType.OPENCL) {
            return "\u001b[36m " + String.valueOf(device) + " \u001b[0m";
        }
        if (tornadoVMBackend == TornadoVMBackendType.SPIRV) {
            return "\u001b[35m " + String.valueOf(device) + " \u001b[0m";
        }
        if (tornadoVMBackend == TornadoVMBackendType.PTX) {
            return "\u001b[32m " + String.valueOf(device) + " \u001b[0m";
        }
        return "\u001b[33m " + String.valueOf(device) + " \u001b[0m";
    }
}

