/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.interpreter;

import java.util.List;
import uk.ac.manchester.tornado.api.common.SchedulableTask;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.interpreter.InterpreterUtilities;

class DebugInterpreter {
    DebugInterpreter() {
    }

    private static void appendLogBuilder(String logMessage, StringBuilder logBuilder) {
        logBuilder.append(logMessage).append("\n");
    }

    static void logAllocObject(Object object, TornadoXPUDevice interpreterDevice, long size, long sizeBatch, StringBuilder logBuilder) {
        String verbose = String.format("bc: %s%s on %s, size=%d, batchSize=%d", InterpreterUtilities.debugHighLightBC("ALLOC"), object, InterpreterUtilities.debugDeviceBC(interpreterDevice), size, sizeBatch);
        DebugInterpreter.appendLogBuilder(verbose, logBuilder);
    }

    static void logDeallocObject(Object object, TornadoXPUDevice interpreterDevice, StringBuilder logBuilder, boolean materializeDealloc) {
        String verbose = String.format("bc: %s[0x%x] %s [Status:%s] on %s", materializeDealloc ? InterpreterUtilities.debugHighLightBC("DEALLOC") : InterpreterUtilities.debugHighLightNonExecBC("DEALLOC"), object.hashCode(), object, InterpreterUtilities.debugHighLightNonExecBC(materializeDealloc ? "Freed" : "Persisted"), InterpreterUtilities.debugDeviceBC(interpreterDevice));
        DebugInterpreter.appendLogBuilder(verbose, logBuilder);
    }

    static void logOnDeviceObject(Object object, TornadoXPUDevice interpreterDevice, StringBuilder logBuilder) {
        String verbose = String.format("bc: %s[0x%x] %s on %s", InterpreterUtilities.debugHighLightBC("ON_DEVICE"), object.hashCode(), object, InterpreterUtilities.debugDeviceBC(interpreterDevice));
        DebugInterpreter.appendLogBuilder(verbose, logBuilder);
    }

    static void logPersistedObject(Object object, TornadoXPUDevice interpreterDevice, StringBuilder logBuilder) {
        String verbose = String.format("bc: %s[0x%x] %s on %s", InterpreterUtilities.debugHighLightBC("PERSIST"), object.hashCode(), object, InterpreterUtilities.debugDeviceBC(interpreterDevice));
        DebugInterpreter.appendLogBuilder(verbose, logBuilder);
    }

    static void logTransferToDeviceOnce(List<Integer> allEvents, Object object, TornadoXPUDevice deviceForInterpreter, long sizeObject, long sizeBatch, long offset, int eventList, StringBuilder logBuilder) {
        boolean executed = allEvents != null;
        String transferStatus = executed ? "Transferred" : "Present";
        String coloredText = executed ? InterpreterUtilities.debugHighLightBC("TRANSFER_HOST_TO_DEVICE_ONCE") : InterpreterUtilities.debugHighLightNonExecBC("TRANSFER_HOST_TO_DEVICE_ONCE");
        String verbose = String.format("bc: %s [Object Hash Code=0x%x] %s on %s, size=%d, batchSize=%d, offset=%d [event list=%d], [Status:%s] ", coloredText, object.hashCode(), object, InterpreterUtilities.debugDeviceBC(deviceForInterpreter), sizeObject, sizeBatch, offset, eventList, InterpreterUtilities.debugHighLightNonExecBC(transferStatus));
        DebugInterpreter.appendLogBuilder(verbose, logBuilder);
    }

    static void logTransferToDeviceAlways(Object object, TornadoXPUDevice deviceForInterpreter, long sizeObject, long sizeBatch, long offset, int eventList, StringBuilder logBuilder) {
        String verbose = String.format("bc: %s [0x%x] %s on %s, size=%d, batchSize=%d, offset=%d [event list=%d]", InterpreterUtilities.debugHighLightBC("TRANSFER_HOST_TO_DEVICE_ALWAYS"), object.hashCode(), object, InterpreterUtilities.debugDeviceBC(deviceForInterpreter), sizeObject, sizeBatch, offset, eventList);
        DebugInterpreter.appendLogBuilder(verbose, logBuilder);
    }

    static void logTransferToHostAlways(Object object, TornadoXPUDevice interpreterDevice, long sizeObject, long sizeBatch, long offset, int eventList, StringBuilder logBuilder) {
        String verbose = String.format("bc: " + InterpreterUtilities.debugHighLightBC("TRANSFER_DEVICE_TO_HOST_ALWAYS") + "[0x%x] %s on %s, size=%d, batchSize=%d, offset=%d [event list=%d]", object.hashCode(), object, InterpreterUtilities.debugDeviceBC(interpreterDevice), sizeObject, sizeBatch, offset, eventList);
        DebugInterpreter.appendLogBuilder(verbose, logBuilder);
    }

    static void logTransferToHostAlwaysBlocking(Object object, TornadoXPUDevice interpreterDevice, StringBuilder logBuilder, long sizeObject, long sizeBatch, long offset, int eventId) {
        String verbose = String.format("bc: " + InterpreterUtilities.debugHighLightBC("TRANSFER_DEVICE_TO_HOST_ALWAYS_BLOCKING") + " [0x%x] %s on %s, size=%d, sizeBatch=%d, offset=%d [event list=%d]", object.hashCode(), object, InterpreterUtilities.debugDeviceBC(interpreterDevice), sizeObject, sizeBatch, offset, eventId);
        DebugInterpreter.appendLogBuilder(verbose, logBuilder);
    }

    public static void logLaunchTask(SchedulableTask task, TornadoXPUDevice interpreterDevice, long numBatchThreads, long offset, int eventId, StringBuilder logBuilder) {
        String verbose = String.format("bc: " + InterpreterUtilities.debugHighLightBC("LAUNCH") + " %s on %s, numThreadBatch=%d, offset=%d [event list=%d]", task.getFullName(), interpreterDevice, numBatchThreads, offset, eventId);
        DebugInterpreter.appendLogBuilder(verbose, logBuilder);
    }

    public static void logStreamInAtomic(Object bufferAtomics, TornadoXPUDevice interpreterDevice, int eventId, StringBuilder logBuilder) {
        String verbose = String.format("bc: " + InterpreterUtilities.debugHighLightBC("STREAM_IN") + "  ATOMIC [0x%x] %s on %s, batchSize=%d, offset=%d [event list=%d]", bufferAtomics.hashCode(), bufferAtomics, interpreterDevice, 0, 0, eventId);
        DebugInterpreter.appendLogBuilder(verbose, logBuilder);
    }

    public static void logAddDependency(int lastEvent, int eventId, StringBuilder logBuilder) {
        String verbose = String.format("bc: " + InterpreterUtilities.debugHighLightBC("ADD_DEPENDENCY") + " %s to event list %d", lastEvent, eventId);
        DebugInterpreter.appendLogBuilder(verbose, logBuilder);
    }

    public static void logBarrier(int enventId, StringBuilder logBuilder) {
        logBuilder.append(String.format("bc: " + InterpreterUtilities.debugHighLightBC("BARRIER") + " event-list %d%n", enventId));
    }
}

