/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graph.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.manchester.tornado.runtime.graph.nodes.AbstractNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.ContextNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.ContextOpNode;

public class TaskNode
extends ContextOpNode {
    private final AbstractNode[] arguments;
    private final int taskIndex;

    public TaskNode(ContextNode context, int index, AbstractNode[] arguments) {
        super(context);
        this.taskIndex = index;
        this.arguments = arguments;
    }

    public AbstractNode getArg(int index) {
        return this.arguments[index];
    }

    public int getTaskIndex() {
        return this.taskIndex;
    }

    @Override
    public List<AbstractNode> getInputs() {
        ArrayList<AbstractNode> inputs = new ArrayList<AbstractNode>();
        Collections.addAll(inputs, this.arguments);
        return inputs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.id).append("]: ");
        sb.append("task=").append(this.taskIndex);
        sb.append(", args=[ ");
        for (AbstractNode arg : this.arguments) {
            sb.append(arg.getId() + " ");
        }
        sb.append("]");
        return sb.toString();
    }

    public int getNumArgs() {
        return this.arguments.length;
    }
}

