/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graph.nodes;

import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.graph.nodes.AbstractNode;

public class ContextNode
extends AbstractNode {
    private int deviceIndex;
    private TornadoXPUDevice device;

    public ContextNode(int index, TornadoXPUDevice device) {
        this.deviceIndex = index;
        this.device = device;
    }

    @Override
    public int compareTo(AbstractNode o) {
        if (!(o instanceof ContextNode)) {
            return -1;
        }
        return Integer.compare(this.deviceIndex, ((ContextNode)o).deviceIndex);
    }

    public int getDeviceIndex() {
        return this.deviceIndex;
    }

    public void setDeviceIndex(int deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    public TornadoXPUDevice getDevice() {
        return this.device;
    }

    public void setDevice(TornadoXPUDevice device) {
        this.device = device;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[%d]: context device=%d, [ ", this.id, this.deviceIndex));
        for (AbstractNode use : this.uses) {
            sb.append("").append(use.getId()).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

