/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graph.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractNode
implements Comparable<AbstractNode> {
    protected int index;
    protected int id = -1;
    protected final List<AbstractNode> uses = new ArrayList<AbstractNode>();

    public boolean hasInputs() {
        return false;
    }

    public List<AbstractNode> getInputs() {
        return Collections.emptyList();
    }

    public void addUse(AbstractNode use) {
        if (!this.uses.contains(use)) {
            this.uses.add(use);
        }
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public int compareTo(AbstractNode o) {
        if (o == null) {
            return -1;
        }
        return this == o ? 0 : 1;
    }

    public int getId() {
        return this.id;
    }

    public List<AbstractNode> getUses() {
        return this.uses;
    }

    public void replaceAtUses(AbstractNode toReplace, AbstractNode replacement) {
        this.uses.remove(toReplace);
        this.uses.add(replacement);
    }

    public void setId(int value) {
        this.id = value;
    }

    public String toString() {
        return String.format("[%d]: %s", this.id, this.getClass().getSimpleName());
    }
}

