/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graph;

import java.nio.BufferOverflowException;
import java.util.Arrays;
import java.util.BitSet;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.runtime.common.BatchConfiguration;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graph.IntermediateTornadoGraph;
import uk.ac.manchester.tornado.runtime.graph.TornadoExecutionContext;
import uk.ac.manchester.tornado.runtime.graph.TornadoGraph;
import uk.ac.manchester.tornado.runtime.graph.TornadoVMBytecodeBuilder;
import uk.ac.manchester.tornado.runtime.graph.TornadoVMBytecodeResult;
import uk.ac.manchester.tornado.runtime.graph.TornadoVMBytecodes;
import uk.ac.manchester.tornado.runtime.graph.nodes.AbstractNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.ContextOpNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.DependentReadNode;

public class TornadoVMGraphCompiler {
    public static TornadoVMBytecodeResult[] compile(TornadoGraph graph, TornadoExecutionContext executionContext) {
        return TornadoVMGraphCompiler.compileTornadoGraphToTornadoBytecodes(graph, executionContext);
    }

    private static TornadoVMBytecodeResult[] compileTornadoGraphToTornadoBytecodes(TornadoGraph graph, TornadoExecutionContext executionContext) {
        boolean isSingleContextCompilation = TornadoVMGraphCompiler.shouldGenerateSingleBytecode(executionContext);
        int numContexts = isSingleContextCompilation ? 1 : executionContext.getValidContextSize();
        BitSet asyncNodes = graph.filter(ContextOpNode.class::isInstance);
        IntermediateTornadoGraph intermediateTornadoGraph = new IntermediateTornadoGraph(asyncNodes, graph);
        TornadoVMBytecodeResult[] tornadoVMBytecodeResults = new TornadoVMBytecodeResult[numContexts];
        intermediateTornadoGraph.analyzeDependencies();
        new TornadoLogger().debug("Compiling bytecodes...");
        for (int i = 0; i < tornadoVMBytecodeResults.length; ++i) {
            TornadoVMBytecodeBuilder tornadoVMBytecodeBuilder = new TornadoVMBytecodeBuilder(isSingleContextCompilation);
            tornadoVMBytecodeBuilder.begin(1, 1, intermediateTornadoGraph.getNumberOfDependencies() + 1);
            if (executionContext.getBatchSize() == (long)TornadoExecutionContext.INIT_VALUE) {
                TornadoVMGraphCompiler.scheduleAndEmitTornadoVMBytecodes(tornadoVMBytecodeBuilder, graph, intermediateTornadoGraph, 0L, 0L, 0L, i, executionContext);
            } else {
                TornadoVMGraphCompiler.scheduleBatchDependentBytecodes(executionContext, tornadoVMBytecodeBuilder, graph, intermediateTornadoGraph);
            }
            if (TornadoOptions.ENABLE_STREAM_OUT_BLOCKING) {
                TornadoVMGraphCompiler.synchronizeOperationLastByteCode(tornadoVMBytecodeBuilder, intermediateTornadoGraph.getNumberOfDependencies());
            } else {
                tornadoVMBytecodeBuilder.barrier(intermediateTornadoGraph.getNumberOfDependencies());
            }
            tornadoVMBytecodeBuilder.end();
            tornadoVMBytecodeResults[i] = new TornadoVMBytecodeResult(tornadoVMBytecodeBuilder.getCode(), tornadoVMBytecodeBuilder.getCodeSize());
        }
        if (executionContext.meta().isDebug()) {
            intermediateTornadoGraph.printDependencyMatrix();
        }
        return tornadoVMBytecodeResults;
    }

    private static boolean shouldGenerateSingleBytecode(TornadoExecutionContext executionContext) {
        boolean isBatchEnabled;
        boolean isSingleDeviceExecution = executionContext.getValidContextSize() == 1;
        boolean bl = isBatchEnabled = executionContext.getBatchSize() != -1L;
        if (isBatchEnabled && !isSingleDeviceExecution) {
            throw new TornadoRuntimeException("[UNSUPPORTED] Batches can only be enabled for single device execution");
        }
        return isSingleDeviceExecution;
    }

    private static void scheduleBatchDependentBytecodes(TornadoExecutionContext executionContext, TornadoVMBytecodeBuilder tornadoVMBytecodeBuilder, TornadoGraph graph, IntermediateTornadoGraph intermediateTornadoGraph) {
        long batchSize = executionContext.getBatchSize();
        BatchConfiguration batchConfiguration = BatchConfiguration.computeChunkSizes(executionContext, batchSize);
        long offset = 0L;
        long numberOfThreads = batchSize / (long)batchConfiguration.getNumBytesType();
        for (int i = 0; i < batchConfiguration.getTotalChunks(); ++i) {
            offset = batchSize * (long)i;
            TornadoVMGraphCompiler.scheduleAndEmitTornadoVMBytecodes(tornadoVMBytecodeBuilder, graph, intermediateTornadoGraph, offset, batchSize, numberOfThreads, 1, executionContext);
        }
        if (batchConfiguration.getRemainingChunkSize() != 0) {
            numberOfThreads = batchConfiguration.getRemainingChunkSize() / batchConfiguration.getNumBytesType();
            long realBatchSize = batchConfiguration.getTotalChunks() == 0 ? 0L : (long)batchConfiguration.getRemainingChunkSize();
            long realOffsetSize = batchConfiguration.getTotalChunks() == 0 ? 0L : (offset += batchSize);
            TornadoVMGraphCompiler.scheduleAndEmitTornadoVMBytecodes(tornadoVMBytecodeBuilder, graph, intermediateTornadoGraph, realOffsetSize, realBatchSize, numberOfThreads, 1, executionContext);
        }
    }

    private static void synchronizeOperationLastByteCode(TornadoVMBytecodeBuilder result, int numDepLists) {
        int position;
        byte[] code = result.getCode();
        if (code[position = result.getLastCopyOutPosition()] == TornadoVMBytecodes.TRANSFER_DEVICE_TO_HOST_ALWAYS.value()) {
            code[position] = TornadoVMBytecodes.TRANSFER_DEVICE_TO_HOST_ALWAYS_BLOCKING.value();
        } else {
            result.barrier(numDepLists);
        }
    }

    private static void scheduleAndEmitTornadoVMBytecodes(TornadoVMBytecodeBuilder tornadoVMBytecodeBuilder, TornadoGraph graph, IntermediateTornadoGraph intermediateTornadoGraph, long offset, long bufferBatchSize, long nThreads, int id, TornadoExecutionContext executionContext) {
        int i;
        int[] nodeIds = intermediateTornadoGraph.getNodeIds();
        BitSet[] dependencies = intermediateTornadoGraph.getDependencies();
        BitSet scheduled = new BitSet(dependencies.length);
        scheduled.clear();
        BitSet nodes = new BitSet(graph.getValid().length());
        int[] depLists = new int[dependencies.length];
        Arrays.fill(depLists, -1);
        int index = 0;
        for (i = 0; i < dependencies.length; ++i) {
            AbstractNode current;
            if (dependencies[i].isEmpty() || (current = graph.getNode(nodeIds[i])) instanceof DependentReadNode) continue;
            depLists[i] = index++;
        }
        while (scheduled.cardinality() < dependencies.length) {
            for (i = 0; i < dependencies.length; ++i) {
                if (scheduled.get(i)) continue;
                BitSet outstandingDeps = new BitSet(nodes.length());
                outstandingDeps.or(dependencies[i]);
                outstandingDeps.andNot(nodes);
                if (!outstandingDeps.isEmpty()) continue;
                ContextOpNode asyncNode = (ContextOpNode)graph.getNode(nodeIds[i]);
                if (TornadoVMGraphCompiler.shouldEmitAsyncNodeForTheCurrentContext(id, asyncNode, tornadoVMBytecodeBuilder.isSingleContext(), executionContext)) {
                    try {
                        tornadoVMBytecodeBuilder.emitAsyncNode(asyncNode, dependencies[i].isEmpty() ? -1 : depLists[i], offset, bufferBatchSize, nThreads);
                    }
                    catch (BufferOverflowException e) {
                        throw new TornadoRuntimeException("[ERROR] Buffer Overflow exception. To increase the buffer size, use -Dtornado.tvm.maxbytecodesize=" + TornadoVMBytecodeBuilder.MAX_TORNADO_VM_BYTECODE_SIZE);
                    }
                }
                for (int j = 0; j < dependencies.length; ++j) {
                    if (j == i || !dependencies[j].get(nodeIds[i]) || depLists[j] == -1) continue;
                    tornadoVMBytecodeBuilder.emitAddDependency(depLists[j]);
                }
                scheduled.set(i);
                nodes.set(nodeIds[i]);
            }
        }
    }

    private static boolean shouldEmitAsyncNodeForTheCurrentContext(int id, ContextOpNode asyncNode, boolean singleContext, TornadoExecutionContext executionContext) throws IndexOutOfBoundsException {
        return singleContext || id >= 0 && id < executionContext.getDevices().size() && asyncNode.getContext().getDevice() == executionContext.getDevices().get(id);
    }
}

