/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graph;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.runtime.graph.TornadoVMBytecodes;

public class TornadoVMBytecodeResult {
    private final byte[] bytecode;
    private final ByteBuffer buffer;

    TornadoVMBytecodeResult(byte[] bytecode, int size) {
        this.bytecode = bytecode;
        this.buffer = this.setupBytecodeBuffer(bytecode, size);
        TornadoInternalError.guarantee((this.buffer.get() == TornadoVMBytecodes.INIT.value() ? 1 : 0) != 0, (String)"invalid code", (Object[])new Object[0]);
    }

    public byte[] getBytecode() {
        return this.bytecode;
    }

    private ByteBuffer setupBytecodeBuffer(byte[] bytecode, int size) {
        return ByteBuffer.wrap(bytecode).order(ByteOrder.LITTLE_ENDIAN).limit(size);
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public byte get() {
        return this.buffer.get();
    }

    public ByteBuffer mark() {
        return this.buffer.mark();
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public void reset() {
        this.buffer.reset();
    }
}

