/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graph;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.Tornado;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.graph.TornadoVMBytecodes;
import uk.ac.manchester.tornado.runtime.graph.nodes.AbstractNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.AllocateMultipleBuffersNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.AllocateNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.ConstantNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.CopyInNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.CopyOutNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.DeallocateNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.DependentReadNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.ObjectNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.OnDeviceObjectNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.PersistedObjectNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.StreamInNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.TaskNode;

public class TornadoVMBytecodeBuilder {
    public static final int MAX_TORNADO_VM_BYTECODE_SIZE = Integer.parseInt(Tornado.getProperty("tornado.tvm.maxbytecodesize", "4096"));
    private final byte[] code = new byte[MAX_TORNADO_VM_BYTECODE_SIZE];
    private final TornadoVMBytecodeAssembler bitcodeASM = new TornadoVMBytecodeAssembler(this.code);
    private boolean isSingleContext;

    public TornadoVMBytecodeBuilder(boolean isSingleContext) {
        this.isSingleContext = isSingleContext;
    }

    public boolean isSingleContext() {
        return this.isSingleContext;
    }

    public void begin(int numContexts, int numStacks, int numDeps) {
        this.bitcodeASM.setup(numContexts, numStacks, numDeps);
        for (int i = 0; i < numContexts; ++i) {
            this.bitcodeASM.context(i);
        }
        this.bitcodeASM.begin();
    }

    public void barrier(int dep) {
        this.bitcodeASM.barrier(dep);
    }

    public void end() {
        this.bitcodeASM.end();
    }

    void emitAsyncNode(AbstractNode node, int dependencyBC, long offset, long batchSize, long nThreads) {
        if (node instanceof AllocateMultipleBuffersNode) {
            AllocateMultipleBuffersNode allocateMultipleBuffersNode = (AllocateMultipleBuffersNode)node;
            this.bitcodeASM.allocate(allocateMultipleBuffersNode.getValues(), batchSize);
        } else if (node instanceof OnDeviceObjectNode) {
            OnDeviceObjectNode onDeviceObjectNode = (OnDeviceObjectNode)node;
            this.bitcodeASM.onDevice(onDeviceObjectNode.getValue().getIndex(), dependencyBC);
        } else if (node instanceof CopyInNode) {
            CopyInNode copyInNode = (CopyInNode)node;
            this.bitcodeASM.transferToDeviceOnce(copyInNode.getValue().getIndex(), dependencyBC, offset, batchSize);
        } else if (node instanceof AllocateNode) {
            AllocateNode allocateNode = (AllocateNode)node;
            new TornadoLogger().info("[%s]: Skipping deprecated node %s", this.getClass().getSimpleName(), AllocateNode.class.getSimpleName());
        } else if (node instanceof CopyOutNode) {
            CopyOutNode copyOutNode = (CopyOutNode)node;
            ObjectNode value = copyOutNode.getValue().getValue();
            this.bitcodeASM.transferToHost(value.getIndex(), dependencyBC, offset, batchSize);
        } else if (node instanceof StreamInNode) {
            StreamInNode streamInNode = (StreamInNode)node;
            this.bitcodeASM.transferToDeviceAlways(streamInNode.getValue().getIndex(), dependencyBC, offset, batchSize);
        } else if (node instanceof DeallocateNode) {
            DeallocateNode deallocateNode = (DeallocateNode)node;
            this.bitcodeASM.deallocate(deallocateNode.getValue().getIndex());
        } else if (node instanceof PersistedObjectNode) {
            PersistedObjectNode persistedObjectNode = (PersistedObjectNode)node;
            this.bitcodeASM.persist(persistedObjectNode.getValue().getIndex(), dependencyBC);
        } else if (node instanceof TaskNode) {
            TaskNode taskNodee;
            TaskNode taskNode = taskNodee = (TaskNode)node;
            this.bitcodeASM.launch(taskNode.getContext().getDeviceIndex(), taskNode.getTaskIndex(), taskNode.getNumArgs(), dependencyBC, offset, nThreads);
            this.emitArgList(taskNode);
        }
    }

    private void emitArgList(TaskNode taskNode) {
        int numArgs = taskNode.getNumArgs();
        for (int i = 0; i < numArgs; ++i) {
            AbstractNode argNode = taskNode.getArg(i);
            if (argNode instanceof ConstantNode) {
                this.bitcodeASM.constantArg(argNode.getIndex());
                continue;
            }
            if (argNode instanceof CopyInNode) {
                CopyInNode copyInNode = (CopyInNode)argNode;
                this.bitcodeASM.referenceArg(copyInNode.getValue().getIndex());
                continue;
            }
            if (argNode instanceof OnDeviceObjectNode) {
                OnDeviceObjectNode onDeviceObjectNode = (OnDeviceObjectNode)argNode;
                this.bitcodeASM.referenceArg(onDeviceObjectNode.getValue().getIndex());
                continue;
            }
            if (argNode instanceof StreamInNode) {
                StreamInNode streamInNode = (StreamInNode)argNode;
                this.bitcodeASM.referenceArg(streamInNode.getValue().getIndex());
                continue;
            }
            if (argNode instanceof CopyOutNode) {
                CopyOutNode copyOutNode = (CopyOutNode)argNode;
                this.bitcodeASM.referenceArg(copyOutNode.getValue().getValue().getIndex());
                continue;
            }
            if (argNode instanceof AllocateNode) {
                AllocateNode allocateNode = (AllocateNode)argNode;
                this.bitcodeASM.referenceArg(allocateNode.getValue().getIndex());
                continue;
            }
            if (!(argNode instanceof DependentReadNode)) continue;
            DependentReadNode dependentReadNode = (DependentReadNode)argNode;
            this.bitcodeASM.referenceArg(dependentReadNode.getValue().getIndex());
        }
    }

    public void emitAddDependency(int dep) {
        this.bitcodeASM.addDependency(dep);
    }

    public void dump() {
        this.bitcodeASM.dump();
    }

    public byte[] getCode() {
        return this.code;
    }

    public int getCodeSize() {
        return this.bitcodeASM.position();
    }

    public int getLastCopyOutPosition() {
        return this.bitcodeASM.getLastCopyOutPosition();
    }

    private static class TornadoVMBytecodeAssembler {
        private final ByteBuffer buffer;
        private int lastCopyOutPosition;

        TornadoVMBytecodeAssembler(byte[] code) {
            this.buffer = ByteBuffer.wrap(code);
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }

        public int position() {
            return this.buffer.position();
        }

        void begin() {
            this.buffer.put(TornadoVMBytecodes.BEGIN.value);
        }

        public void end() {
            this.buffer.put(TornadoVMBytecodes.END.value);
        }

        void setup(int numContexts, int numStacks, int numDeps) {
            this.buffer.put(TornadoVMBytecodes.INIT.value);
            this.buffer.putInt(numContexts);
            this.buffer.putInt(numStacks);
            this.buffer.putInt(numDeps);
        }

        void addDependency(int index) {
            this.buffer.put(TornadoVMBytecodes.ADD_DEPENDENCY.value);
            this.buffer.putInt(index);
        }

        public void context(int index) {
            this.buffer.put(TornadoVMBytecodes.CONTEXT.value);
            this.buffer.putInt(index);
        }

        public void allocate(List<AbstractNode> values, long batchSize) {
            this.buffer.put(TornadoVMBytecodes.ALLOC.value);
            this.buffer.putLong(batchSize);
            this.buffer.putInt(values.size());
            for (AbstractNode node : values) {
                this.buffer.putInt(node.getIndex());
            }
        }

        public void onDevice(int object, int dep) {
            this.buffer.put(TornadoVMBytecodes.ON_DEVICE.value);
            this.buffer.putInt(object);
            this.buffer.putInt(dep);
        }

        public void persist(int object, int dep) {
            this.buffer.put(TornadoVMBytecodes.PERSIST.value);
            this.buffer.putInt(object);
            this.buffer.putInt(dep);
        }

        public void deallocate(int object) {
            this.buffer.put(TornadoVMBytecodes.DEALLOC.value);
            this.buffer.putInt(object);
        }

        void transferToDeviceOnce(int obj, int dep, long offset, long size) {
            this.buffer.put(TornadoVMBytecodes.TRANSFER_HOST_TO_DEVICE_ONCE.value);
            this.buffer.putInt(obj);
            this.buffer.putInt(dep);
            this.buffer.putLong(offset);
            this.buffer.putLong(size);
        }

        void transferToDeviceAlways(int obj, int dep, long offset, long size) {
            this.buffer.put(TornadoVMBytecodes.TRANSFER_HOST_TO_DEVICE_ALWAYS.value);
            this.buffer.putInt(obj);
            this.buffer.putInt(dep);
            this.buffer.putLong(offset);
            this.buffer.putLong(size);
        }

        void transferToHost(int obj, int dep, long offset, long size) {
            this.lastCopyOutPosition = this.buffer.position();
            this.buffer.put(TornadoVMBytecodes.TRANSFER_DEVICE_TO_HOST_ALWAYS.value);
            this.buffer.putInt(obj);
            this.buffer.putInt(dep);
            this.buffer.putLong(offset);
            this.buffer.putLong(size);
        }

        void launch(int callStackDeviceIndex, int taskIndex, int numParameters, int dep, long offset, long size) {
            this.buffer.put(TornadoVMBytecodes.LAUNCH.value);
            this.buffer.putInt(callStackDeviceIndex);
            this.buffer.putInt(taskIndex);
            this.buffer.putInt(numParameters);
            this.buffer.putInt(dep);
            this.buffer.putLong(offset);
            this.buffer.putLong(size);
        }

        public void barrier(int dep) {
            this.buffer.put(TornadoVMBytecodes.BARRIER.value);
            this.buffer.putInt(dep);
        }

        void constantArg(int index) {
            this.buffer.put(TornadoVMBytecodes.PUSH_CONSTANT_ARGUMENT.value);
            this.buffer.putInt(index);
        }

        void referenceArg(int index) {
            this.buffer.put(TornadoVMBytecodes.PUSH_REFERENCE_ARGUMENT.value);
            this.buffer.putInt(index);
        }

        int getLastCopyOutPosition() {
            return this.lastCopyOutPosition;
        }

        public void dump() {
            int width = 16;
            System.out.printf("code  : capacity = %s, in use = %s   \n", RuntimeUtilities.humanReadableByteCount(this.buffer.capacity(), true), RuntimeUtilities.humanReadableByteCount(this.buffer.position(), true));
            for (int i = 0; i < this.buffer.position(); i += 16) {
                System.out.printf("[0x%04x]: ", i);
                for (int j = 0; j < Math.min(this.buffer.capacity() - i, 16); ++j) {
                    if (j % 2 == 0) {
                        System.out.printf(" ", new Object[0]);
                    }
                    if (j < this.buffer.position() - i) {
                        System.out.printf("%02x", this.buffer.get(i + j));
                        continue;
                    }
                    System.out.printf("..", new Object[0]);
                }
                System.out.println();
            }
        }
    }
}

