/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graph;

import java.util.BitSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.runtime.graph.nodes.AbstractNode;

public class TornadoGraph {
    private static final int INITIAL_SIZE = 1024;
    private AbstractNode[] nodes = new AbstractNode[1024];
    private BitSet valid = new BitSet(1024);
    private int nextNode = 0;

    TornadoGraph() {
    }

    public AbstractNode getNode(int index) {
        return this.nodes[index];
    }

    public void add(AbstractNode node) {
        if (this.nextNode >= this.nodes.length) {
            this.resize();
        }
        node.setId(this.nextNode);
        this.nodes[this.nextNode] = node;
        this.valid.set(this.nextNode);
        ++this.nextNode;
    }

    <T extends AbstractNode> T addUnique(T node) {
        int i = this.valid.nextSetBit(0);
        while (i != -1 && i < this.nodes.length) {
            if (this.nodes[i].compareTo(node) == 0) {
                return (T)this.nodes[i];
            }
            i = this.valid.nextSetBit(i + 1);
        }
        this.add(node);
        return node;
    }

    public void delete(AbstractNode node) {
        this.valid.clear(node.getId());
        node.setId(-node.getId());
    }

    private void resize() {
        TornadoInternalError.unimplemented((String)"Tornado Graph resize not implemented yet.");
    }

    public <T extends AbstractNode> BitSet filter(Class<T> type) {
        BitSet nodes = new BitSet(this.valid.length());
        this.apply(n -> {
            if (n.getClass().equals(type)) {
                nodes.set(n.getId());
            }
        });
        return nodes;
    }

    public BitSet filter(Predicate<AbstractNode> test) {
        BitSet nodes = new BitSet(this.valid.length());
        this.apply(n -> {
            if (test.test((AbstractNode)n)) {
                nodes.set(n.getId());
            }
        });
        return nodes;
    }

    private void pApply(BitSet predicates, Consumer<AbstractNode> consumer) {
        int i = predicates.nextSetBit(0);
        while (i != -1 && i < predicates.length()) {
            consumer.accept(this.nodes[i]);
            i = predicates.nextSetBit(i + 1);
        }
    }

    public void apply(Consumer<AbstractNode> consumer) {
        this.pApply(this.valid, consumer);
    }

    public void dumpTornadoGraph() {
        String ansiCyan = "\u001b[36m";
        String ansiReset = "\u001b[0m";
        System.out.println("-----------------------------------");
        System.out.println("\u001b[36mTaskGraph:\u001b[0m");
        this.apply(System.out::println);
        System.out.println("-----------------------------------");
    }

    public BitSet getValid() {
        return this.valid;
    }
}

