/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graph;

import java.util.Arrays;
import java.util.BitSet;
import java.util.stream.Collectors;
import uk.ac.manchester.tornado.runtime.graph.TornadoGraph;
import uk.ac.manchester.tornado.runtime.graph.nodes.AbstractNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.ContextOpNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.DependentReadNode;
import uk.ac.manchester.tornado.runtime.graph.nodes.TaskNode;

public class IntermediateTornadoGraph {
    private final TornadoGraph graph;
    private final BitSet asyncNodes;
    private final BitSet tasks;
    private BitSet[] dependencies;
    private int[] nodeIds;
    private int index;
    private int numberOfDependencies;

    public IntermediateTornadoGraph(BitSet asyncNodes, TornadoGraph graph) {
        this.graph = graph;
        this.asyncNodes = asyncNodes;
        this.dependencies = new BitSet[asyncNodes.cardinality()];
        this.tasks = new BitSet(asyncNodes.cardinality());
        this.nodeIds = new int[asyncNodes.cardinality()];
        this.index = 0;
        this.numberOfDependencies = 0;
    }

    public BitSet[] getDependencies() {
        return this.dependencies;
    }

    public BitSet getTasks() {
        return this.tasks;
    }

    public int[] getNodeIds() {
        return this.nodeIds;
    }

    public int getNumberOfDependencies() {
        return this.numberOfDependencies;
    }

    public void analyzeDependencies() {
        int i = this.asyncNodes.nextSetBit(0);
        while (i != -1 && i < this.asyncNodes.length()) {
            this.dependencies[this.index] = this.calculateDependencies(this.graph, i);
            this.nodeIds[this.index] = i;
            if (this.graph.getNode(i) instanceof TaskNode) {
                this.tasks.set(this.index);
            }
            if (!this.dependencies[this.index].isEmpty()) {
                ++this.numberOfDependencies;
            }
            ++this.index;
            i = this.asyncNodes.nextSetBit(i + 1);
        }
    }

    private BitSet calculateDependencies(TornadoGraph graph, int i) {
        BitSet dependencies = new BitSet(graph.getValid().length());
        AbstractNode node = graph.getNode(i);
        for (AbstractNode input : node.getInputs()) {
            if (!(input instanceof ContextOpNode)) continue;
            if (input instanceof DependentReadNode) {
                DependentReadNode dependentReadNode = (DependentReadNode)input;
                dependencies.set(dependentReadNode.getDependent().getId());
                continue;
            }
            dependencies.set(input.getId());
        }
        return dependencies;
    }

    public void printDependencyMatrix() {
        StringBuilder output = new StringBuilder();
        output.append("TornadoGraph dependency matrix...\n");
        int maxNodeId = Arrays.stream(this.nodeIds).max().getAsInt();
        int maxLabelLength = Integer.toString(maxNodeId).length();
        output.append("+" + "-".repeat(maxLabelLength + 2) + "+");
        output.append("-".repeat(15) + "+");
        output.append("\n");
        for (int i = 0; i < this.nodeIds.length; ++i) {
            int nodeId = this.nodeIds[i];
            String label = String.format("%" + maxLabelLength + "d", nodeId);
            String type = this.tasks.get(i) ? "task" : "data";
            output.append("| ").append(String.format("%-" + maxLabelLength + "s", label));
            output.append(" [").append(type).append("]| ").append(this.toString(this.dependencies[i])).append("\n");
            output.append("|").append("-".repeat(maxLabelLength + 2)).append("+");
            output.append("-".repeat(15)).append("+");
            output.append("\n");
        }
        System.out.println(output);
    }

    private String toString(BitSet set) {
        return set.isEmpty() ? "<none>" : set.stream().mapToObj(String::valueOf).collect(Collectors.joining(" "));
    }
}

