/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.phases.sketcher;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.common.inlining.info.InlineInfo;
import org.graalvm.compiler.phases.common.inlining.policy.InliningPolicy;
import org.graalvm.compiler.phases.common.inlining.walker.MethodInvocation;
import uk.ac.manchester.tornado.api.exceptions.TornadoInliningException;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoInliningPolicy;

public class TornadoPartialInliningPolicy
implements TornadoInliningPolicy {
    public boolean continueInlining(StructuredGraph graph) {
        if (graph.getNodeCount() >= (Integer)GraalOptions.MaximumDesiredSize.getValue(graph.getOptions())) {
            InliningUtil.logInliningDecision((DebugContext)TornadoCoreRuntime.getDebugContext(), (String)"inlining is cut off by MaximumDesiredSize", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public InliningPolicy.Decision isWorthInlining(Replacements replacements, MethodInvocation invocation, InlineInfo calleeInfo, int inliningDepth, boolean fullyProcessed) {
        boolean notRoot;
        int inliningLimit;
        InlineInfo info = invocation.callee();
        int nodes = info.determineNodeCount();
        boolean inliningLimitExceeded = nodes > (inliningLimit = (Integer)GraalOptions.MaximumInliningSize.getValue(info.graph().getOptions()) * 2);
        boolean bl = notRoot = !invocation.isRoot();
        if (inliningLimitExceeded && notRoot) {
            throw new TornadoInliningException("Method " + String.valueOf(invocation) + " cannot be inlined: node count (" + nodes + ") exceeds limit (" + inliningLimit + ")");
        }
        return InliningPolicy.Decision.YES;
    }
}

