/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.phases.sketcher;

import java.util.Optional;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.FixedBinaryNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ShiftNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoSketchTierContext;

public class TornadoNumericPromotionPhase
extends BasePhase<TornadoSketchTierContext> {
    private boolean isNodeElegibleForNumericPromotion(ValueNode node) {
        return node instanceof BinaryArithmeticNode || node instanceof ShiftNode || node instanceof FixedBinaryNode;
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph, TornadoSketchTierContext context) {
        NodeIterable narrowNodes = graph.getNodes().filter(NarrowNode.class);
        for (NarrowNode narrow : narrowNodes) {
            NodeIterable filter;
            ValueNode valueOfNarrow = narrow.getValue();
            if (!this.isNodeElegibleForNumericPromotion(valueOfNarrow)) continue;
            NodeIterable usages = narrow.usages();
            SignExtendNode signExtendNode = null;
            for (Node u : usages) {
                if (!(u instanceof SignExtendNode)) continue;
                signExtendNode = (SignExtendNode)u;
            }
            if (signExtendNode == null || !(filter = signExtendNode.usages().filter(NarrowNode.class)).isNotEmpty()) continue;
            NarrowNode newNarrowNode = (NarrowNode)filter.first();
            signExtendNode.replaceAtMatchingUsages((Node)newNarrowNode, node -> !node.equals(newNarrowNode));
            assert (graph.verify());
        }
    }
}

