/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.phases.sketcher;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.PointerEqualsNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.nodes.WriteAtomicNode;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoSketchTierContext;

public class TornadoNativeTypeElimination
extends BasePhase<TornadoSketchTierContext> {
    private static void removeFixedGuardNodes(FixedGuardNode fixedGuardNode, LoadFieldNode loadFieldSegment) {
        ArrayList<Node> nodesToBeRemoved = new ArrayList<Node>();
        nodesToBeRemoved.add((Node)fixedGuardNode);
        for (Node node : fixedGuardNode.inputs()) {
            if (!(node instanceof InstanceOfNode) && !(node instanceof IsNullNode)) continue;
            nodesToBeRemoved.add(node);
        }
        for (Node node : fixedGuardNode.usages()) {
            PiNode piNode;
            PiNode piNode2;
            if (node instanceof PiNode && (piNode2 = (PiNode)node).usages().filter(OffsetAddressNode.class).isNotEmpty()) {
                for (OffsetAddressNode offsetAddressNode : piNode2.usages().filter(OffsetAddressNode.class)) {
                    if (TornadoNativeTypeElimination.piHasParameterInput(piNode2)) {
                        return;
                    }
                    if (!TornadoNativeTypeElimination.piNodeUsageReplacement(offsetAddressNode, piNode2, loadFieldSegment)) continue;
                    nodesToBeRemoved.add((Node)piNode2);
                }
                continue;
            }
            if (!(node instanceof PiNode) || !(piNode = (PiNode)node).usages().filter(LoadHubNode.class).isNotEmpty()) continue;
            nodesToBeRemoved.add((Node)piNode);
            LoadHubNode loadHubNode = (LoadHubNode)piNode.usages().filter(LoadHubNode.class).first();
            nodesToBeRemoved.add((Node)loadHubNode);
            for (Node pointerEqualsNode : loadHubNode.usages().filter(PointerEqualsNode.class)) {
                nodesToBeRemoved.add(pointerEqualsNode);
                nodesToBeRemoved.add(pointerEqualsNode.inputs().filter(ConstantNode.class).first());
                if (!pointerEqualsNode.usages().filter(FixedGuardNode.class).isNotEmpty()) continue;
                FixedGuardNode typeCheckingFixed = (FixedGuardNode)pointerEqualsNode.usages().filter(FixedGuardNode.class).first();
                nodesToBeRemoved.add((Node)typeCheckingFixed);
                for (PiNode piNodeOfTypeCheckingFixed : typeCheckingFixed.usages().filter(PiNode.class)) {
                    for (OffsetAddressNode offsetAddressNode : piNodeOfTypeCheckingFixed.usages().filter(OffsetAddressNode.class)) {
                        if (TornadoNativeTypeElimination.piHasParameterInput(piNodeOfTypeCheckingFixed)) {
                            return;
                        }
                        if (!TornadoNativeTypeElimination.piNodeUsageReplacement(offsetAddressNode, piNodeOfTypeCheckingFixed, loadFieldSegment)) continue;
                        nodesToBeRemoved.add((Node)piNodeOfTypeCheckingFixed);
                    }
                }
            }
        }
        TornadoNativeTypeElimination.deleteFixedGuardAndInputNodes(nodesToBeRemoved);
    }

    private static boolean piHasParameterInput(PiNode piNode) {
        return piNode.inputs().filter(ParameterNode.class).isNotEmpty();
    }

    private static boolean piNodeUsageReplacement(OffsetAddressNode off, PiNode piNode, LoadFieldNode loadFieldSegment) {
        if (off.usages().filter(JavaReadNode.class).isNotEmpty() || off.usages().filter(JavaWriteNode.class).isNotEmpty() || off.usages().filter(WriteAtomicNode.class).isNotEmpty()) {
            if (piNode.inputs().filter(LoadFieldNode.class).isNotEmpty()) {
                LoadFieldNode ldf = (LoadFieldNode)piNode.inputs().filter(LoadFieldNode.class).first();
                off.replaceFirstInput((Node)piNode, (Node)ldf);
            } else {
                off.replaceFirstInput((Node)piNode, (Node)loadFieldSegment);
            }
            return true;
        }
        return false;
    }

    private static void deleteFixedGuardAndInputNodes(ArrayList<Node> nodesToBeRemoved) {
        for (Node n : nodesToBeRemoved) {
            if (n == null || n.isDeleted()) continue;
            if (n instanceof FixedGuardNode) {
                TornadoNativeTypeElimination.deleteFixed(n);
                continue;
            }
            n.safeDelete();
        }
    }

    private static void deleteFixed(Node node) {
        if (!node.isDeleted()) {
            Node predecessor = node.predecessor();
            Node successor = node.successors().first();
            node.replaceFirstSuccessor(successor, null);
            node.replaceAtPredecessor(successor);
            predecessor.replaceFirstSuccessor(node, successor);
            for (Node us : node.usages()) {
                node.removeUsage(us);
            }
            node.clearInputs();
            node.safeDelete();
        }
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    private int getElementKindSize(LoadFieldNode baseIndexNode) {
        int kindElement = 0;
        Annotation[] declaredAnnotations = baseIndexNode.field().getDeclaringClass().getDeclaredAnnotations();
        if (declaredAnnotations.length == 0) {
            throw new TornadoRuntimeException("Annotation is missing");
        }
        for (Annotation annotation : declaredAnnotations) {
            if (!(annotation instanceof SegmentElementSize)) continue;
            SegmentElementSize panamaElementSize = (SegmentElementSize)annotation;
            kindElement = panamaElementSize.size();
        }
        return kindElement;
    }

    protected void run(StructuredGraph graph, TornadoSketchTierContext context) {
        for (LoadFieldNode loadFieldSegment : graph.getNodes().filter(LoadFieldNode.class)) {
            Node piNode;
            Iterator fixedGuardNode2;
            Node panamaObjectHeaderSize2;
            if (!loadFieldSegment.toString().contains("segment")) continue;
            Node node = loadFieldSegment.successors().first();
            if (node instanceof LoadFieldNode) {
                LoadFieldNode baseIndexNode = (LoadFieldNode)node;
                int elementKindSize = this.getElementKindSize(baseIndexNode);
                int panamaObjectHeaderSize2 = (int)TornadoOptions.PANAMA_OBJECT_HEADER_SIZE;
                int baseIndexPosition = panamaObjectHeaderSize2 / elementKindSize;
                ConstantNode constantNode = (ConstantNode)graph.addOrUnique((Node)ConstantNode.forInt((int)baseIndexPosition));
                baseIndexNode.replaceAtUsages((Node)constantNode);
                TornadoNativeTypeElimination.deleteFixed((Node)baseIndexNode);
            }
            if (loadFieldSegment.successors().filter(FixedGuardNode.class).isNotEmpty() && (panamaObjectHeaderSize2 = (fixedGuardNode2 = (FixedGuardNode)loadFieldSegment.successors().filter(FixedGuardNode.class).first()).successors().first()) instanceof LoadFieldNode) {
                LoadFieldNode baseIndexNode = (LoadFieldNode)panamaObjectHeaderSize2;
                int elementKindSize = this.getElementKindSize(baseIndexNode);
                int panamaObjectHeaderSize3 = (int)TornadoOptions.PANAMA_OBJECT_HEADER_SIZE;
                int baseIndexPosition = panamaObjectHeaderSize3 / elementKindSize;
                ConstantNode constantNode = (ConstantNode)graph.addOrUnique((Node)ConstantNode.forInt((int)baseIndexPosition));
                baseIndexNode.replaceAtUsages((Node)constantNode);
                Node node2 = baseIndexNode.predecessor();
                if (node2 instanceof FixedGuardNode) {
                    FixedGuardNode outterFixedGuardNode = (FixedGuardNode)node2;
                    outterFixedGuardNode.inputs().filter(IsNullNode.class).forEach(isNullNode -> isNullNode.safeDelete());
                    TornadoNativeTypeElimination.deleteFixed((Node)outterFixedGuardNode);
                }
                TornadoNativeTypeElimination.deleteFixed((Node)baseIndexNode);
            }
            fixedGuardNode2 = loadFieldSegment.inputs().filter(PiNode.class).iterator();
            while (fixedGuardNode2.hasNext()) {
                piNode = (PiNode)fixedGuardNode2.next();
                for (OffsetAddressNode offsetAddressNode : loadFieldSegment.usages().filter(OffsetAddressNode.class)) {
                    offsetAddressNode.replaceFirstInput((Node)loadFieldSegment, piNode);
                }
                for (PiNode piNodeInner : loadFieldSegment.usages().filter(PiNode.class)) {
                    for (OffsetAddressNode offsetAddressNode : piNodeInner.usages().filter(OffsetAddressNode.class)) {
                        offsetAddressNode.replaceFirstInput((Node)piNodeInner, piNode);
                        piNodeInner.inputs().filter(FixedGuardNode.class).forEach(fixedGuardNode -> {
                            fixedGuardNode.inputs().filter(IsNullNode.class).forEach(isNullNode -> isNullNode.safeDelete());
                            TornadoNativeTypeElimination.deleteFixed((Node)fixedGuardNode);
                        });
                        piNodeInner.safeDelete();
                    }
                }
            }
            piNode = loadFieldSegment.predecessor();
            if (piNode instanceof FixedGuardNode) {
                fixedGuardNode2 = (FixedGuardNode)piNode;
                TornadoNativeTypeElimination.deleteFixed((Node)loadFieldSegment);
                Node node3 = fixedGuardNode2.predecessor();
                if (!(node3 instanceof LoadFieldNode)) continue;
                LoadFieldNode ldf = (LoadFieldNode)node3;
                TornadoNativeTypeElimination.removeFixedGuardNodes((FixedGuardNode)fixedGuardNode2, ldf);
                continue;
            }
            TornadoNativeTypeElimination.deleteFixed((Node)loadFieldSegment);
        }
    }
}

