/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.phases.sketcher;

import java.util.ArrayList;
import java.util.Optional;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.UnboxNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.graal.nodes.GetGroupIdFixedWithNextNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.GlobalGroupSizeFixedWithNextNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.LocalGroupSizeFixedWithNextNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.ThreadIdFixedWithNextNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.ThreadLocalIdFixedWithNextNode;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoSketchTierContext;

public class TornadoKernelContextReplacement
extends BasePhase<TornadoSketchTierContext> {
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    private void replaceKernelContextNode(StructuredGraph graph, ArrayList<Node> nodesToBeRemoved, LoadFieldNode oldNode, FixedWithNextNode newNode) {
        Node fixedWithNextNode;
        for (Node n : oldNode.successors()) {
            for (Node input : n.inputs()) {
                input.safeDelete();
            }
            for (Node usage : n.usages()) {
                usage.safeDelete();
            }
            Node fixedWithNextNode2 = n.successors().first();
            fixedWithNextNode2.replaceAtPredecessor(null);
            oldNode.replaceFirstSuccessor(n, fixedWithNextNode2);
            n.safeDelete();
        }
        TornadoCoreRuntime.getDebugContext().dump(1, (Object)graph, "After-FIXED REMOVED");
        FixedNode unboxNode = oldNode.next();
        if (unboxNode instanceof UnboxNode) {
            unboxNode.replaceAtUsages((Node)oldNode);
            fixedWithNextNode = unboxNode.successors().first();
            fixedWithNextNode.replaceAtPredecessor(null);
            oldNode.replaceFirstSuccessor((Node)unboxNode, fixedWithNextNode);
            unboxNode.safeDelete();
        }
        TornadoCoreRuntime.getDebugContext().dump(1, (Object)graph, "After-UNBOXING");
        graph.addWithoutUnique((Node)newNode);
        oldNode.replaceAtUsages((Node)newNode);
        oldNode.replaceAtUsages((Node)newNode);
        oldNode.replaceAtPredecessor((Node)newNode);
        fixedWithNextNode = oldNode.successors().first();
        fixedWithNextNode.replaceAtPredecessor(null);
        newNode.replaceFirstSuccessor(null, fixedWithNextNode);
        nodesToBeRemoved.add((Node)oldNode);
    }

    private void introduceKernelContext(StructuredGraph graph) {
        ArrayList<Node> nodesToBeRemoved = new ArrayList<Node>();
        graph.getNodes().filter(LoadFieldNode.class).forEach(node -> {
            if (node != null) {
                String field = node.field().format("%H.%n");
                if (field.contains("KernelContext.globalId")) {
                    ThreadIdFixedWithNextNode threadIdNode;
                    if (field.contains("globalIdx")) {
                        threadIdNode = new ThreadIdFixedWithNextNode(node.getValue(), 0);
                    } else if (field.contains("globalIdy")) {
                        threadIdNode = new ThreadIdFixedWithNextNode(node.getValue(), 1);
                    } else if (field.contains("globalIdz")) {
                        threadIdNode = new ThreadIdFixedWithNextNode(node.getValue(), 2);
                    } else {
                        throw new TornadoRuntimeException("Unrecognized dimension");
                    }
                    this.replaceKernelContextNode(graph, nodesToBeRemoved, (LoadFieldNode)node, threadIdNode);
                } else if (field.contains("KernelContext.localId")) {
                    ThreadLocalIdFixedWithNextNode threadLocalIdNode;
                    if (field.contains("localIdx")) {
                        threadLocalIdNode = new ThreadLocalIdFixedWithNextNode(node.getValue(), 0);
                    } else if (field.contains("localIdy")) {
                        threadLocalIdNode = new ThreadLocalIdFixedWithNextNode(node.getValue(), 1);
                    } else if (field.contains("localIdz")) {
                        threadLocalIdNode = new ThreadLocalIdFixedWithNextNode(node.getValue(), 2);
                    } else {
                        throw new TornadoRuntimeException("Unrecognized dimension");
                    }
                    this.replaceKernelContextNode(graph, nodesToBeRemoved, (LoadFieldNode)node, threadLocalIdNode);
                } else if (field.contains("KernelContext.groupId")) {
                    GetGroupIdFixedWithNextNode groupIdNode;
                    if (field.contains("groupIdx")) {
                        groupIdNode = new GetGroupIdFixedWithNextNode(node.getValue(), 0);
                    } else if (field.contains("groupIdy")) {
                        groupIdNode = new GetGroupIdFixedWithNextNode(node.getValue(), 1);
                    } else if (field.contains("groupIdz")) {
                        groupIdNode = new GetGroupIdFixedWithNextNode(node.getValue(), 2);
                    } else {
                        throw new TornadoRuntimeException("Unrecognized dimension");
                    }
                    this.replaceKernelContextNode(graph, nodesToBeRemoved, (LoadFieldNode)node, groupIdNode);
                } else if (field.contains("KernelContext.globalGroupSize")) {
                    GlobalGroupSizeFixedWithNextNode globalGroupSizeNode;
                    if (field.contains("globalGroupSizeX")) {
                        globalGroupSizeNode = new GlobalGroupSizeFixedWithNextNode(node.getValue(), 0);
                    } else if (field.contains("globalGroupSizeY")) {
                        globalGroupSizeNode = new GlobalGroupSizeFixedWithNextNode(node.getValue(), 1);
                    } else if (field.contains("globalGroupSizeZ")) {
                        globalGroupSizeNode = new GlobalGroupSizeFixedWithNextNode(node.getValue(), 2);
                    } else {
                        throw new TornadoRuntimeException("Unrecognized dimension");
                    }
                    this.replaceKernelContextNode(graph, nodesToBeRemoved, (LoadFieldNode)node, globalGroupSizeNode);
                } else if (field.contains("KernelContext.localGroupSize")) {
                    LocalGroupSizeFixedWithNextNode localGroupSizeNode;
                    if (field.contains("localGroupSizeX")) {
                        localGroupSizeNode = new LocalGroupSizeFixedWithNextNode(node.getValue(), 0);
                    } else if (field.contains("localGroupSizeY")) {
                        localGroupSizeNode = new LocalGroupSizeFixedWithNextNode(node.getValue(), 1);
                    } else if (field.contains("localGroupSizeZ")) {
                        localGroupSizeNode = new LocalGroupSizeFixedWithNextNode(node.getValue(), 2);
                    } else {
                        throw new TornadoRuntimeException("Unrecognized dimension");
                    }
                    this.replaceKernelContextNode(graph, nodesToBeRemoved, (LoadFieldNode)node, localGroupSizeNode);
                }
            }
        });
        nodesToBeRemoved.forEach(node -> {
            node.clearSuccessors();
            node.clearInputs();
            node.safeDelete();
        });
    }

    public void execute(StructuredGraph graph, TornadoSketchTierContext context) {
        this.run(graph, context);
    }

    protected void run(StructuredGraph graph, TornadoSketchTierContext context) {
        this.introduceKernelContext(graph);
    }
}

