/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.phases.sketcher;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.BinaryOpLogicNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.graal.nodes.ParallelRangeNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.ParallelStrideNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.StoreAtomicIndexedNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.interfaces.MarkVectorStore;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoSketchTierContext;

public class TornadoDataflowAnalysis
extends BasePhase<TornadoSketchTierContext> {
    protected void run(StructuredGraph graph, TornadoSketchTierContext context) {
        Access[] accesses = context.getAccesses();
        TornadoLogger logger = new TornadoLogger(((Object)((Object)this)).getClass());
        for (int i = 0; i < accesses.length; ++i) {
            accesses[i] = Access.NONE;
            ParameterNode param = graph.getParameter(i);
            if (param != null && param.stamp(NodeView.DEFAULT) instanceof ObjectStamp) {
                accesses[i] = this.processUsages((Node)param, context.getMetaAccess());
            }
            logger.debug("access: parameter %d -> %s\n", i, accesses[i]);
        }
        logger.debug("[Compiler Pass] TornadoVM DataFlow Analysis finished");
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    private boolean checkIgnoreStride(ParallelRangeNode range) {
        ValueNode value = range.stride().value();
        if (value instanceof ConstantNode) {
            ConstantNode c = (ConstantNode)value;
            Constant value2 = c.getValue();
            String v = value2.toValueString();
            int stride = Integer.parseInt(v);
            return stride == 1;
        }
        return false;
    }

    private boolean shouldIgnoreNode(IfNode ifNode, IfNode fatherNodeStore) {
        boolean ignore = false;
        LogicNode logicNode = ifNode.condition();
        if (logicNode instanceof BinaryOpLogicNode) {
            BinaryOpLogicNode condition = (BinaryOpLogicNode)logicNode;
            if (condition.getX() instanceof ParallelRangeNode) {
                ignore = this.checkIgnoreStride((ParallelRangeNode)condition.getX());
            } else if (condition.getY() instanceof ParallelRangeNode) {
                ignore = this.checkIgnoreStride((ParallelRangeNode)condition.getY());
            }
        }
        if (ignore) {
            return true;
        }
        if (fatherNodeStore != null) {
            return !fatherNodeStore.equals(ifNode);
        }
        return false;
    }

    private MetaControlFlow analyseControlFlowForWriting(Node currentNode, IfNode fatherNodeStore, boolean isWrittenTrueCondition, boolean isWrittenFalseCondition) {
        Node predecessor;
        boolean trueCondition = isWrittenTrueCondition;
        boolean falseCondition = isWrittenFalseCondition;
        boolean exit = false;
        Node next = predecessor = currentNode;
        while (!exit && !(predecessor instanceof StartNode) && (predecessor = predecessor.predecessor()) != null) {
            if (predecessor instanceof IfNode) {
                IfNode ifNode = (IfNode)predecessor;
                if (this.shouldIgnoreNode(ifNode, fatherNodeStore)) continue;
                if (ifNode.trueSuccessor() == next) {
                    trueCondition = true;
                } else if (ifNode.falseSuccessor() == next) {
                    falseCondition = true;
                }
                fatherNodeStore = ifNode;
                exit = true;
            }
            next = predecessor;
        }
        return new MetaControlFlow(trueCondition, falseCondition, fatherNodeStore);
    }

    private boolean isNodeFromKnownObject(Node currentNode) {
        return currentNode.getClass().getName().equals("uk.ac.manchester.tornado.drivers.opencl.graal.nodes.IncAtomicNode") || currentNode.getClass().getName().equals("uk.ac.manchester.tornado.drivers.opencl.graal.nodes.DecAtomicNode") || currentNode.getClass().getName().equals("uk.ac.manchester.tornado.drivers.opencl.graal.nodes.AtomAddNodeTemplate") || currentNode.getClass().getName().equals("uk.ac.manchester.tornado.drivers.ptx.graal.nodes.AtomAddNodeTemplate");
    }

    private Access processUsages(Node parameter, MetaAccessProvider metaAccess) {
        boolean isRead = false;
        boolean isWritten = false;
        boolean isReadField = false;
        boolean isWrittenField = false;
        ArrayDeque nodesToProcess = new ArrayDeque();
        parameter.usages().forEach(nodesToProcess::add);
        boolean isWrittenTrueCondition = false;
        boolean isWrittenFalseCondition = false;
        IfNode fatherNodeStore = null;
        boolean isWritingAllPositions = false;
        while (!nodesToProcess.isEmpty()) {
            MetaControlFlow meta;
            Node currentNode = (Node)nodesToProcess.remove();
            if (currentNode instanceof LoadIndexedNode) {
                isRead = true;
                if (!((ValueNode)currentNode).stamp(NodeView.DEFAULT).javaType(metaAccess).isArray()) continue;
                nodesToProcess.addAll(currentNode.usages().snapshot());
                continue;
            }
            if (currentNode instanceof StoreIndexedNode || currentNode instanceof StoreAtomicIndexedNode || currentNode instanceof WriteNode || currentNode instanceof JavaWriteNode) {
                meta = this.analyseControlFlowForWriting(currentNode, fatherNodeStore, isWrittenTrueCondition, isWrittenFalseCondition);
                fatherNodeStore = meta.fatherNodeStore();
                isWrittenTrueCondition = meta.isWrittenTrueCondition();
                isWrittenFalseCondition = meta.isWrittenFalseCondition();
                isWritten = true;
                if (!(currentNode instanceof StoreIndexedNode)) continue;
                isWritingAllPositions = this.analyseWritingPositions((StoreIndexedNode)currentNode);
                continue;
            }
            if (currentNode instanceof ReadNode || currentNode instanceof JavaReadNode) {
                ValueNode readNode = (ValueNode)currentNode;
                if (readNode.stamp(NodeView.DEFAULT) instanceof ObjectStamp) {
                    readNode.usages().forEach(nodesToProcess::add);
                }
                isRead = true;
                continue;
            }
            if (currentNode instanceof LoadFieldNode) {
                LoadFieldNode loadField = (LoadFieldNode)currentNode;
                if (this.isTornadoNativeArray(loadField)) continue;
                if (loadField.stamp(NodeView.DEFAULT) instanceof ObjectStamp) {
                    loadField.usages().forEach(nodesToProcess::add);
                }
                isReadField = true;
                continue;
            }
            if (currentNode instanceof StoreFieldNode) {
                meta = this.analyseControlFlowForWriting(currentNode, fatherNodeStore, isWrittenTrueCondition, isWrittenFalseCondition);
                fatherNodeStore = meta.fatherNodeStore();
                isWrittenTrueCondition = meta.isWrittenTrueCondition();
                isWrittenFalseCondition = meta.isWrittenFalseCondition();
                isWrittenField = true;
                isReadField = true;
                continue;
            }
            if (currentNode instanceof MarkVectorStore) {
                isWritten = true;
                continue;
            }
            if (this.isNodeFromKnownObject(currentNode)) {
                isRead = true;
                isWritten = true;
                continue;
            }
            if (!(currentNode instanceof PiNode) && !(currentNode instanceof AddressNode)) {
                if (!(currentNode instanceof OffsetAddressNode)) continue;
            }
            currentNode.usages().forEach(nodesToProcess::add);
        }
        if (isWrittenTrueCondition ^ isWrittenFalseCondition && !isWritingAllPositions) {
            isRead = true;
        }
        Access result = Access.NONE;
        if (isRead && isWritten) {
            result = Access.READ_WRITE;
        } else if (isRead) {
            result = Access.READ_ONLY;
        } else if (isWritten) {
            result = Access.WRITE_ONLY;
        }
        if (isReadField && isWrittenField) {
            result = Access.asArray()[result.position | Access.READ_WRITE.position];
        } else if (isReadField) {
            result = Access.asArray()[result.position | Access.READ_ONLY.position];
        } else if (isWrittenField) {
            result = Access.asArray()[result.position | Access.WRITE_ONLY.position];
        }
        return result;
    }

    private boolean isTornadoNativeArray(LoadFieldNode loadFieldNode) {
        String field = loadFieldNode.field().toString();
        return field.contains("uk.ac.manchester.tornado.api.types.arrays.IntArray") || field.contains("uk.ac.manchester.tornado.api.types.arrays.DoubleArray") || field.contains("uk.ac.manchester.tornado.api.types.arrays.FloatArray") || field.contains("uk.ac.manchester.tornado.api.types.arrays.LongArray") || field.contains("uk.ac.manchester.tornado.api.types.arrays.CharArray") || field.contains("uk.ac.manchester.tornado.api.types.arrays.ShortArray") || field.contains("uk.ac.manchester.tornado.api.types.arrays.ByteArray");
    }

    private boolean analyseWritingPositions(StoreIndexedNode storeIndexedNode) {
        Node pre;
        for (pre = storeIndexedNode.predecessor(); pre != null && !(pre instanceof IfNode); pre = pre.predecessor()) {
        }
        if (pre != null && pre.predecessor() instanceof BeginNode) {
            return false;
        }
        ArrayDeque<ValueNode> nodesToProcess = new ArrayDeque<ValueNode>();
        HashSet<Node> visited = new HashSet<Node>();
        nodesToProcess.add(storeIndexedNode.index());
        block6: while (!nodesToProcess.isEmpty()) {
            Node node;
            Node node2 = (Node)nodesToProcess.remove();
            visited.add(node2);
            Objects.requireNonNull(node2);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ParallelStrideNode.class, BinaryArithmeticNode.class, PhiNode.class}, (Object)node, n)) {
                case 0: {
                    ParallelStrideNode parallelStrideNode = (ParallelStrideNode)node;
                    ValueNode valueNode = parallelStrideNode.value();
                    if (!(valueNode instanceof ConstantNode)) continue block6;
                    ConstantNode constantNode = (ConstantNode)valueNode;
                    ConstantNode constantNode1 = ConstantNode.forInt((int)1);
                    return constantNode.getValue().equals((Object)constantNode1.getValue());
                }
                case 1: {
                    BinaryArithmeticNode binaryArithmeticNode = (BinaryArithmeticNode)node;
                    ValueNode a = binaryArithmeticNode.getX();
                    ValueNode b = binaryArithmeticNode.getY();
                    if (!visited.contains(a)) {
                        nodesToProcess.add(a);
                    }
                    if (visited.contains(b)) continue block6;
                    nodesToProcess.add(b);
                    break;
                }
                case 2: {
                    PhiNode phiNode = (PhiNode)node;
                    for (ValueNode valuePhiNode : phiNode.values()) {
                        if (visited.contains(valuePhiNode)) continue;
                        nodesToProcess.add(valuePhiNode);
                    }
                    continue block6;
                }
            }
        }
        return false;
    }

    private record MetaControlFlow(boolean isWrittenTrueCondition, boolean isWrittenFalseCondition, IfNode fatherNodeStore) {
    }
}

