/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.phases.sketcher;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoSketchTierContext;

public class TornadoBatchFunctionAnalysis
extends BasePhase<TornadoSketchTierContext> {
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph, TornadoSketchTierContext context) {
        for (ValuePhiNode phiNode : graph.getNodes().filter(ValuePhiNode.class)) {
            for (Node phiNodeUsage : phiNode.usages()) {
                HashSet<Node> visited;
                if (!TornadoBatchFunctionAnalysis.isIndexUsedInJavaWrite(phiNodeUsage, visited = new HashSet<Node>())) continue;
                context.setBatchWriteThreadIndex();
            }
        }
    }

    private static boolean isIndexUsedInJavaWrite(Node indexUsage, Set<Node> visited) {
        visited.add(indexUsage);
        if (indexUsage instanceof OffsetAddressNode || indexUsage instanceof FrameState || indexUsage instanceof LoadIndexedNode || indexUsage instanceof JavaReadNode) {
            return false;
        }
        if (indexUsage instanceof JavaWriteNode) {
            return true;
        }
        for (Node node : indexUsage.usages()) {
            if (visited.contains(node) || !TornadoBatchFunctionAnalysis.isIndexUsedInJavaWrite(node, visited)) continue;
            return true;
        }
        return false;
    }
}

