/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.phases.sketcher;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.api.exceptions.TornadoBailoutRuntimeException;
import uk.ac.manchester.tornado.api.exceptions.TornadoCompilationException;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.nodes.ParallelOffsetNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.ParallelRangeNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.ParallelStrideNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.TornadoLoopsData;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoSketchTierContext;

public class TornadoAutoParalleliser
extends BasePhase<TornadoSketchTierContext> {
    private TornadoLogger logger = new TornadoLogger(((Object)((Object)this)).getClass());

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph, TornadoSketchTierContext context) {
        if (!TornadoOptions.AUTO_PARALLELISATION || graph.getNodes().filter(ParallelRangeNode.class).isNotEmpty()) {
            this.logger.info("auto parallelisation disabled");
            return;
        }
        this.autoParallelise(graph);
    }

    private void autoParallelise(StructuredGraph graph) {
        if (graph.hasLoops()) {
            TornadoLoopsData data = new TornadoLoopsData(graph);
            data.detectCountedLoops();
            List loops = data.outerFirst();
            for (int i = loops.size() - 1; i > 1; --i) {
                if (((LoopEx)loops.get(i)).parent() == loops.get(i - 1)) continue;
                this.logger.info("method %s does not have a single loop-nest", graph.method().getName());
                return;
            }
            int parallelDepth = 0;
            for (int i = 0; i < loops.size() && parallelDepth < 3; ++parallelDepth, ++i) {
                Object phi22;
                LoopEx current = (LoopEx)loops.get(0);
                LoopBeginNode loopBegin = current.loopBegin();
                EconomicMap ivMap = current.getInductionVariables();
                this.logger.info("%s loop info:\n", loopBegin);
                HashSet<Object> phis = new HashSet<Object>();
                for (Object phi22 : loopBegin.phis()) {
                    this.logger.info("\tphi: %s\n", phi22);
                    phis.add(phi22);
                }
                ArrayList<InductionVariable> ivs = new ArrayList<InductionVariable>();
                phi22 = ivMap.getKeys().iterator();
                while (phi22.hasNext()) {
                    Node node = (Node)phi22.next();
                    this.logger.info("\tiv: node=%s iv=%s\n", node, ivMap.get((Object)node));
                    phis.remove(node);
                    ivs.add((InductionVariable)ivMap.get((Object)node));
                }
                if (!phis.isEmpty()) {
                    this.logger.info("unable to parallelise because of loop-dependencies:\n");
                    for (Node node : phis) {
                        PhiNode phi3 = (PhiNode)node;
                        StringBuilder sb = new StringBuilder();
                        for (ValueNode value : phi3.values()) {
                            if (value.getNodeSourcePosition() != null) {
                                sb.append(value.getNodeSourcePosition().toString());
                            }
                            sb.append("\n");
                        }
                        this.logger.info("\tnode %s updated:\n", node);
                        this.logger.info(sb.toString().trim());
                    }
                    throw new TornadoBailoutRuntimeException("unable to parallelise because of loop-dependencies.");
                }
                if (ivs.size() > 1) {
                    this.logger.debug("Too many ivs");
                    return;
                }
                InductionVariable iv = (InductionVariable)ivs.getFirst();
                List conditions = iv.valueNode().usages().filter(IntegerLessThanNode.class).snapshot();
                IntegerLessThanNode lessThan = (IntegerLessThanNode)conditions.getFirst();
                ValueNode valueNode = lessThan.getY();
                this.parallelizationReplacement(graph, iv, parallelDepth, valueNode, conditions);
            }
            this.logger.info("automatically parallelised %s (%dD kernel)\n", graph.method().getName(), parallelDepth);
        }
    }

    private void parallelizationReplacement(StructuredGraph graph, InductionVariable iv, int parallelDepth, ValueNode maxIterations, List<IntegerLessThanNode> conditions) throws TornadoCompilationException {
        ValueNode oldStride;
        ValuePhiNode phi;
        ParallelRangeNode range;
        ParallelStrideNode stride;
        ParallelOffsetNode offset;
        if (iv.isConstantInit() && iv.isConstantStride()) {
            ConstantNode newInit = (ConstantNode)graph.addWithoutUnique((Node)ConstantNode.forInt((int)((int)iv.constantInit())));
            ConstantNode newStride = (ConstantNode)graph.addWithoutUnique((Node)ConstantNode.forInt((int)((int)iv.constantStride())));
            offset = (ParallelOffsetNode)graph.addWithoutUnique((Node)new ParallelOffsetNode(parallelDepth, (ValueNode)newInit));
            stride = (ParallelStrideNode)graph.addWithoutUnique((Node)new ParallelStrideNode(parallelDepth, (ValueNode)newStride));
            range = (ParallelRangeNode)graph.addWithoutUnique((Node)new ParallelRangeNode(parallelDepth, maxIterations, offset, stride));
            phi = (ValuePhiNode)iv.valueNode();
            oldStride = phi.singleBackValueOrThis();
            if (oldStride.usages().count() > 1) {
                ValueNode duplicateStride = (ValueNode)oldStride.copyWithInputs(true);
                oldStride.replaceAtMatchingUsages((Node)duplicateStride, usage -> !usage.equals(phi));
            }
        } else {
            throw new TornadoBailoutRuntimeException("Failed to parallelize because of non-constant loop strides. \nSequential code will run on the device.");
        }
        iv.initNode().replaceAtMatchingUsages((Node)offset, node -> node.equals(phi));
        iv.strideNode().replaceAtMatchingUsages((Node)stride, node -> node.equals(oldStride));
        maxIterations.replaceAtMatchingUsages((Node)range, node -> node.equals(conditions.get(0)));
    }
}

