/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.phases;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.util.Providers;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;

public class TornadoSketchTierContext
extends HighTierContext {
    private final ResolvedJavaMethod method;
    private final Access[] argumentAccess;
    private boolean batchWriteThreadIndex;
    private TornadoDevice device;

    public TornadoSketchTierContext(Providers providers, PhaseSuite<HighTierContext> graphBuilderSuite, OptimisticOptimizations optimisticOpts, ResolvedJavaMethod method, int backendIndex, int deviceIndex) {
        super(providers, graphBuilderSuite, optimisticOpts);
        this.method = method;
        int parameterCount = method.getParameters().length;
        this.argumentAccess = new Access[method.isStatic() ? parameterCount : parameterCount + 1];
        this.device = TornadoRuntimeProvider.getTornadoRuntime().getBackend(backendIndex).getDevice(deviceIndex);
    }

    public TornadoDevice getDevice() {
        return this.device;
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    public Access[] getAccesses() {
        return this.argumentAccess;
    }

    public void setBatchWriteThreadIndex() {
        this.batchWriteThreadIndex = true;
    }

    public boolean getBatchWriteThreadIndex() {
        return this.batchWriteThreadIndex;
    }
}

