/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.phases;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.util.Providers;
import uk.ac.manchester.tornado.runtime.common.BatchCompilationConfig;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class TornadoHighTierContext
extends HighTierContext {
    protected final ResolvedJavaMethod method;
    protected final Object[] args;
    protected final TaskDataContext meta;
    protected final boolean isKernel;
    private BatchCompilationConfig batchCompilationConfig;

    public TornadoHighTierContext(Providers providers, PhaseSuite<HighTierContext> graphBuilderSuite, OptimisticOptimizations optimisticOpts, ResolvedJavaMethod method, Object[] args, TaskDataContext meta, boolean isKernel, BatchCompilationConfig batchCompilationConfig) {
        super(providers, graphBuilderSuite, optimisticOpts);
        this.method = method;
        this.args = args;
        this.meta = meta;
        this.isKernel = isKernel;
        this.batchCompilationConfig = batchCompilationConfig;
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public boolean hasArgs() {
        return this.args != null;
    }

    public Object getArg(int index) {
        return this.args[index];
    }

    public int getNumArgs() {
        return this.hasArgs() ? this.args.length : 0;
    }

    public TaskDataContext getMeta() {
        return this.meta;
    }

    public TornadoXPUDevice getDeviceMapping() {
        return this.meta.getXPUDevice();
    }

    public boolean hasMeta() {
        return this.meta != null;
    }

    public boolean isKernel() {
        return this.isKernel;
    }

    public BatchCompilationConfig getBatchCompilationConfig() {
        return this.batchCompilationConfig;
    }

    public boolean isGridSchedulerEnabled() {
        if (this.meta != null) {
            return this.meta.isGridSchedulerEnabled();
        }
        return false;
    }
}

