/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.phases;

import java.util.ArrayList;
import java.util.Optional;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.phases.BasePhase;
import uk.ac.manchester.tornado.runtime.graal.nodes.HalfFloatPlaceholder;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoSketchTierContext;

public class TornadoHalfFloatFixedGuardElimination
extends BasePhase<TornadoSketchTierContext> {
    private static void deleteFixed(Node node) {
        if (!node.isDeleted()) {
            Node predecessor = node.predecessor();
            Node successor = node.successors().first();
            node.replaceFirstSuccessor(successor, null);
            node.replaceAtPredecessor(successor);
            predecessor.replaceFirstSuccessor(node, successor);
            for (Node us : node.usages()) {
                node.removeUsage(us);
            }
            node.clearInputs();
            node.safeDelete();
        }
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    protected void run(StructuredGraph graph, TornadoSketchTierContext context) {
        ArrayList<Object> nodesToBeDeleted = new ArrayList<Object>();
        for (HalfFloatPlaceholder halfFloatPlaceholder : graph.getNodes().filter(HalfFloatPlaceholder.class)) {
            ValueNode valueNode = halfFloatPlaceholder.getInput();
            if (!(valueNode instanceof PiNode)) continue;
            PiNode placeholderInput = (PiNode)valueNode;
            ValueNode halfFloatValue = placeholderInput.object();
            FixedGuardNode placeholderGuard = (FixedGuardNode)placeholderInput.getGuard();
            if (placeholderGuard.inputs().filter(IsNullNode.class).isNotEmpty()) {
                IsNullNode isNullNode = (IsNullNode)placeholderGuard.inputs().filter(IsNullNode.class).first();
                nodesToBeDeleted.add(isNullNode);
            }
            TornadoHalfFloatFixedGuardElimination.deleteFixed((Node)placeholderGuard);
            halfFloatPlaceholder.setInput(halfFloatValue);
            nodesToBeDeleted.add(placeholderInput);
        }
        for (ValueNode valueNode : nodesToBeDeleted) {
            valueNode.safeDelete();
        }
    }
}

