/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import uk.ac.manchester.tornado.runtime.graal.nodes.WriteAtomicNodeExtension;

@NodeInfo(nameTemplate="AtomicWrite")
public class WriteAtomicNode
extends FixedWithNextNode
implements StateSplit,
Lowerable {
    public static final NodeClass<WriteAtomicNode> TYPE = NodeClass.create(WriteAtomicNode.class);
    @Node.Input
    ValueNode value;
    @Node.Input
    ValueNode accumulator;
    @Node.Input
    ValueNode inputArray;
    @Node.Input
    WriteAtomicNodeExtension writeAtomicExtraNode;
    @Node.Input
    AddressNode address;
    @Node.Input
    ValueNode outArray;
    JavaKind kind;

    public WriteAtomicNode(JavaKind kind, AddressNode address, ValueNode value, ValueNode accumulator, ValueNode inputArray, ValueNode outArray, WriteAtomicNodeExtension extension) {
        super(TYPE, StampFactory.forVoid());
        this.value = value;
        this.accumulator = accumulator;
        this.inputArray = inputArray;
        this.writeAtomicExtraNode = extension;
        this.address = address;
        this.kind = kind;
        this.outArray = outArray;
    }

    public ValueNode getIndex() {
        return null;
    }

    public JavaKind getElementKind() {
        return this.kind;
    }

    public ValueNode value() {
        return this.value;
    }

    public ValueNode getAccumulator() {
        return this.accumulator;
    }

    public ValueNode getStartNode() {
        return this.writeAtomicExtraNode.getStartNode();
    }

    public ValueNode getInputArray() {
        return this.inputArray;
    }

    public void setOptionalOperation(ValueNode node) {
        this.writeAtomicExtraNode.setExtraOperation(node);
    }

    public ValueNode getExtraOperation() {
        return this.writeAtomicExtraNode.getExtraOperation();
    }

    public ValueNode getOutArray() {
        return this.outArray;
    }

    public FrameState stateAfter() {
        return this.writeAtomicExtraNode.getStateAfter();
    }

    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages((Node)this.writeAtomicExtraNode.getStateAfter(), (Node)x);
        this.writeAtomicExtraNode.setStateAfter(x);
    }

    public boolean hasSideEffect() {
        return true;
    }
}

