/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.java.AccessIndexedNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import uk.ac.manchester.tornado.runtime.graal.nodes.StoreAtomicIndexedNodeExtension;

@NodeInfo(nameTemplate="AtomicIndexedStore")
public final class StoreAtomicIndexedNode
extends AccessIndexedNode
implements StateSplit,
Lowerable,
Virtualizable {
    public static final NodeClass<StoreAtomicIndexedNode> TYPE = NodeClass.create(StoreAtomicIndexedNode.class);
    @Node.Input
    ValueNode value;
    @Node.Input
    ValueNode accumulator;
    @Node.Input
    ValueNode inputArray;
    @Node.Input
    StoreAtomicIndexedNodeExtension storeAtomicExtraNode;

    public FrameState stateAfter() {
        return this.storeAtomicExtraNode.getStateAfter();
    }

    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages((Node)this.storeAtomicExtraNode.getStateAfter(), (Node)x);
        this.storeAtomicExtraNode.setStateAfter(x);
    }

    public boolean hasSideEffect() {
        return true;
    }

    public ValueNode value() {
        return this.value;
    }

    public StoreAtomicIndexedNode(ValueNode outputArray, ValueNode index, JavaKind elementKind, GuardingNode boundsCheck, ValueNode value, ValueNode accumulator, ValueNode inputArray, StoreAtomicIndexedNodeExtension extension) {
        super(TYPE, StampFactory.forVoid(), outputArray, index, boundsCheck, elementKind);
        this.value = value;
        this.accumulator = accumulator;
        this.inputArray = inputArray;
        this.storeAtomicExtraNode = extension;
    }

    public void virtualize(VirtualizerTool tool) {
        throw new RuntimeException("StoreAtomic Virtual Node not supported yet");
    }

    public FrameState getState() {
        return this.storeAtomicExtraNode.getStateAfter();
    }

    public ValueNode getAccumulator() {
        return this.accumulator;
    }

    public ValueNode getStartNode() {
        return this.storeAtomicExtraNode.getStartNode();
    }

    public ValueNode getInputArray() {
        return this.inputArray;
    }

    public void setOptionalOperation(ValueNode node) {
        this.storeAtomicExtraNode.setExtraOperation(node);
    }

    public ValueNode getExtraOperation() {
        return this.storeAtomicExtraNode.getExtraOperation();
    }

    public StoreAtomicIndexedNodeExtension getStoreAtomicExtraNode() {
        return this.storeAtomicExtraNode;
    }
}

