/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal.compiler;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.phases.HighTier;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.IterativeConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.inlining.InliningPhase;
import org.graalvm.compiler.phases.common.inlining.policy.InliningPolicy;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoHalfFloatFixedGuardElimination;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoInliningPolicy;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoSketchTierContext;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoApiReplacement;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoAutoParalleliser;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoBatchFunctionAnalysis;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoDataflowAnalysis;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoFullInliningPolicy;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoKernelContextReplacement;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoNativeTypeElimination;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoNumericPromotionPhase;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoPanamaPrivateMemory;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoPartialInliningPolicy;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoReduceReplacement;
import uk.ac.manchester.tornado.runtime.graal.phases.sketcher.TornadoStampResolver;

public class TornadoSketchTier
extends PhaseSuite<TornadoSketchTierContext> {
    protected final CanonicalizerPhase.CustomSimplification customSimplification;

    public TornadoSketchTier(OptionValues options, CanonicalizerPhase.CustomSimplification customCanonicalizer) {
        this.customSimplification = customCanonicalizer;
        this.appendPhase(new TornadoNumericPromotionPhase());
        TornadoInliningPolicy inliningPolicy = TornadoOptions.FULL_INLINING ? new TornadoFullInliningPolicy() : new TornadoPartialInliningPolicy();
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        this.appendPhase((BasePhase)canonicalizer);
        if (((Boolean)HighTier.Options.Inline.getValue(options)).booleanValue()) {
            this.appendPhase((BasePhase)new InliningPhase((InliningPolicy)inliningPolicy, canonicalizer));
            this.appendPhase((BasePhase)new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional));
            if (((Boolean)GraalOptions.ConditionalElimination.getValue(options)).booleanValue()) {
                this.appendPhase((BasePhase)canonicalizer);
                this.appendPhase((BasePhase)new IterativeConditionalEliminationPhase(canonicalizer, false));
            }
        }
        this.appendPhase(new TornadoStampResolver());
        this.appendPhase(new TornadoHalfFloatFixedGuardElimination());
        this.appendPhase(new TornadoNativeTypeElimination());
        this.appendPhase(new TornadoReduceReplacement());
        this.appendPhase(new TornadoApiReplacement());
        this.appendPhase(new TornadoKernelContextReplacement());
        this.appendPhase(new TornadoAutoParalleliser());
        this.appendPhase(new TornadoDataflowAnalysis());
        this.appendPhase(new TornadoPanamaPrivateMemory());
        this.appendPhase(new TornadoBatchFunctionAnalysis());
    }
}

