/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.graal;

import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.lir.phases.LIRPhaseSuite;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;
import org.graalvm.compiler.lir.phases.PreAllocationOptimizationPhase;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.AddressLoweringByNodePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import uk.ac.manchester.tornado.api.TornadoDeviceContext;
import uk.ac.manchester.tornado.runtime.graal.TornadoLIRSuites;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoCompilerConfiguration;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoHighTier;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoLowTier;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoMidTier;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoSketchTier;
import uk.ac.manchester.tornado.runtime.graal.phases.TornadoAllocationStage;

public class TornadoSuites {
    private final TornadoSketchTier sketchTier;
    private final TornadoHighTier highTier;
    private final TornadoMidTier midTier;
    private final TornadoLowTier lowTier;
    private final TornadoAllocationStage allocStage;
    private final LIRPhaseSuite<PreAllocationOptimizationPhase.PreAllocationOptimizationContext> preAllocStage;
    private final LIRPhaseSuite<PostAllocationOptimizationPhase.PostAllocationOptimizationContext> postAllocStage;

    public TornadoSuites(OptionValues options, TornadoDeviceContext deviceContext, TornadoCompilerConfiguration config, MetaAccessProvider metaAccessProvider, CanonicalizerPhase.CustomSimplification canonicalizer, AddressLoweringByNodePhase.AddressLowering addressLowering) {
        this.sketchTier = config.createSketchTier(options, canonicalizer);
        this.highTier = config.createHighTier(options, deviceContext, canonicalizer, metaAccessProvider);
        this.midTier = config.createMidTier(options);
        this.lowTier = config.createLowTier(options, deviceContext, addressLowering);
        this.allocStage = config.createAllocationStage(options);
        this.preAllocStage = config.createPreAllocationOptimizationStage(options);
        this.postAllocStage = config.createPostAllocationOptimizationStage(options);
    }

    public TornadoSketchTier getSketchTier() {
        return this.sketchTier;
    }

    public TornadoHighTier getHighTier() {
        return this.highTier;
    }

    public TornadoMidTier getMidTier() {
        return this.midTier;
    }

    public TornadoLowTier getLowTier() {
        return this.lowTier;
    }

    public LIRPhaseSuite<PreAllocationOptimizationPhase.PreAllocationOptimizationContext> getPreAllocationOptimizationStage() {
        return this.preAllocStage;
    }

    public TornadoAllocationStage getAllocationStage() {
        return this.allocStage;
    }

    public LIRPhaseSuite<PostAllocationOptimizationPhase.PostAllocationOptimizationContext> getPostAllocationOptimizationStage() {
        return this.postAllocStage;
    }

    public TornadoLIRSuites getLIRSuites() {
        return new TornadoLIRSuites(this.preAllocStage, this.allocStage, this.postAllocStage);
    }
}

