/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.common.enums;

import java.util.Arrays;

public enum DataTypeSize {
    BYTE(Byte.TYPE, 1),
    CHAR(Character.TYPE, 2),
    SHORT(Short.TYPE, 2),
    INT(Integer.TYPE, 4),
    FLOAT(Float.TYPE, 4),
    LONG(Long.TYPE, 8),
    DOUBLE(Double.TYPE, 8),
    BYTE_WRAPPER(Byte.class, 1),
    CHAR_WRAPPER(Character.class, 2),
    SHORT_WRAPPER(Short.class, 2),
    INT_WRAPPER(Integer.class, 4),
    FLOAT_WRAPPER(Float.class, 4),
    LONG_WRAPPER(Long.class, 8),
    DOUBLE_WRAPPER(Double.class, 8);

    private final Class<?> dataType;
    private final byte size;

    private DataTypeSize(Class<?> dataType, byte size) {
        this.dataType = dataType;
        this.size = size;
    }

    public static DataTypeSize findDataTypeSize(Class<?> dataType) {
        return Arrays.stream(DataTypeSize.values()).filter(size -> size.getDataType().equals(dataType)).findFirst().orElse(null);
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public byte getSize() {
        return this.size;
    }
}

