/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.common;

import uk.ac.manchester.tornado.api.memory.DeviceBufferState;
import uk.ac.manchester.tornado.api.memory.XPUBuffer;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;

public class XPUDeviceBufferState
implements DeviceBufferState {
    private XPUBuffer xpuBuffer;
    private boolean atomicRegionPresent;
    private boolean bufferHasContent;
    private boolean lockBuffer;
    private long partialSize;
    private boolean reuseBuffer = false;

    public void setXPUBuffer(XPUBuffer value) {
        this.xpuBuffer = value;
    }

    public void setAtomicRegion(XPUBuffer buffer) {
        this.xpuBuffer = buffer;
        this.atomicRegionPresent = true;
    }

    public boolean hasObjectBuffer() {
        return this.xpuBuffer != null;
    }

    public XPUBuffer getXPUBuffer() {
        return this.xpuBuffer;
    }

    public boolean isLockedBuffer() {
        return this.lockBuffer;
    }

    public void setLockBuffer(boolean lockBuffer) {
        this.lockBuffer = lockBuffer;
    }

    public boolean hasContent() {
        return this.bufferHasContent;
    }

    public void setContents(boolean content) {
        this.bufferHasContent = content;
    }

    public boolean isAtomicRegionPresent() {
        return this.atomicRegionPresent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasObjectBuffer()) {
            sb.append(String.format(" buffer=0x%x, size=%s ", this.xpuBuffer.toBuffer(), RuntimeUtilities.humanReadableByteCount(this.xpuBuffer.size(), true)));
        } else {
            sb.append(" <unbuffered>");
        }
        return sb.toString();
    }

    public void setAtomicRegion() {
        this.atomicRegionPresent = true;
    }

    public void setPartialCopySize(long partialCopySize) {
        this.partialSize = partialCopySize;
    }

    public long getPartialCopySize() {
        return this.partialSize;
    }

    public boolean isBufferReused() {
        return this.reuseBuffer;
    }

    public void markBufferAsReused() {
        this.reuseBuffer = true;
    }

    public XPUDeviceBufferState createSnapshot() {
        XPUDeviceBufferState xpuDeviceBufferState = new XPUDeviceBufferState();
        xpuDeviceBufferState.setLockBuffer(this.isLockedBuffer());
        return xpuDeviceBufferState;
    }
}

