/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.common;

import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class UpsMeterReader {
    private static String OUTPUT_VOLTAGE_OID = "1.3.6.1.2.1.33.1.4.4.1.2.1";
    private static String OUTPUT_POWER_OID = "1.3.6.1.2.1.33.1.4.4.1.4.1";
    private static String COMMUNITY = "public";
    private static String ADDRESS = TornadoOptions.UPS_IP_ADDRESS;
    private static int SNMP_VERSION = 0;

    private static String getSnmpValue(String oid) {
        String result = "";
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            transport.listen();
            if (ADDRESS == null) {
                return null;
            }
            Address targetAddress = GenericAddress.parse((String)("udp:" + ADDRESS + "/161"));
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(COMMUNITY));
            target.setAddress(targetAddress);
            target.setRetries(2);
            target.setTimeout(1500L);
            target.setVersion(SNMP_VERSION);
            PDU pdu = new PDU();
            pdu.add(new VariableBinding(new OID(oid)));
            pdu.setType(-96);
            Snmp snmp = new Snmp((TransportMapping)transport);
            ResponseEvent response = snmp.get(pdu, (Target)target);
            if (response != null && response.getResponse() != null) {
                result = response.getResponse().get(0).getVariable().toString();
            } else {
                System.err.println("Error: No response from SNMP agent.");
            }
            snmp.close();
        }
        catch (Exception e) {
            System.err.println("Error in SNMP GET: " + e.getMessage());
        }
        return result;
    }

    public static String getOutputPowerMetric() {
        return UpsMeterReader.getSnmpValue(OUTPUT_POWER_OID);
    }

    public static String getOutputVoltageMetric() {
        return UpsMeterReader.getSnmpValue(OUTPUT_VOLTAGE_OID);
    }
}

