/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.common;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.SchedulableTask;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.memory.XPUBuffer;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.KernelStackFrame;
import uk.ac.manchester.tornado.runtime.common.TornadoInstalledCode;
import uk.ac.manchester.tornado.runtime.common.TornadoSchedulingStrategy;
import uk.ac.manchester.tornado.runtime.common.XPUDeviceBufferState;
import uk.ac.manchester.tornado.runtime.sketcher.Sketch;
import uk.ac.manchester.tornado.runtime.sketcher.TornadoSketcher;
import uk.ac.manchester.tornado.runtime.tasks.CompilableTask;

public interface TornadoXPUDevice
extends TornadoDevice {
    public TornadoSchedulingStrategy getPreferredSchedule();

    public KernelStackFrame createKernelStackFrame(long var1, int var3, Access var4);

    public XPUBuffer createOrReuseAtomicsBuffer(int[] var1, Access var2);

    public TornadoInstalledCode installCode(long var1, SchedulableTask var3);

    public boolean isFullJITMode(long var1, SchedulableTask var3);

    public TornadoInstalledCode getCodeFromCache(long var1, SchedulableTask var3);

    public int[] checkAtomicsForTask(SchedulableTask var1);

    public int[] checkAtomicsForTask(SchedulableTask var1, int[] var2, int var3, Object var4);

    public int[] updateAtomicRegionAndObjectState(SchedulableTask var1, int[] var2, int var3, Object var4, XPUDeviceBufferState var5);

    public int getAtomicsGlobalIndexForTask(SchedulableTask var1, int var2);

    public boolean checkAtomicsParametersForTask(SchedulableTask var1);

    public void enableThreadSharing();

    public void setAtomicRegion(XPUBuffer var1);

    default public boolean loopIndexInWrite(SchedulableTask task) {
        if (task instanceof CompilableTask) {
            CompilableTask executable = (CompilableTask)task;
            ResolvedJavaMethod resolvedMethod = TornadoCoreRuntime.getTornadoRuntime().resolveMethod(executable.getMethod());
            Sketch sketch = TornadoSketcher.lookup(resolvedMethod, task.meta().getBackendIndex(), task.meta().getDeviceIndex());
            return sketch.getBatchWriteThreadIndex();
        }
        return false;
    }
}

