/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.common;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class TornadoVMClient {
    private String host;
    private int port;

    public TornadoVMClient() {
        if (this.validArgument()) {
            this.host = TornadoOptions.SOCKET_PORT.split(":")[0];
            this.port = Integer.parseInt(TornadoOptions.SOCKET_PORT.split(":")[1]);
        }
        if (!TornadoVMClient.isValidInet4Address(this.host) || TornadoOptions.SOCKET_PORT.isEmpty() || !this.validArgument()) {
            throw new TornadoRuntimeException("Invalid IP address. \nCheck the argument passed with -Dtornado.send.logs=IP:PORT");
        }
    }

    private boolean validArgument() {
        return TornadoOptions.SOCKET_PORT.split(":").length == 2;
    }

    public void sentLogOverSocket(String outputFile) throws IOException {
        Socket socket = this.openSocket();
        if (socket.isConnected()) {
            try (OutputStreamWriter out = new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8);){
                out.write(outputFile);
            }
            catch (IOException e) {
                System.out.println(e.toString());
            }
        }
        socket.close();
    }

    private Socket openSocket() {
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.port);
        }
        catch (UnknownHostException u) {
            System.out.println(u);
        }
        catch (IOException i) {
            System.out.println(i);
        }
        return socket;
    }

    public static boolean isValidInet4Address(String ip) {
        try {
            if (ip == null || ip.isEmpty()) {
                return false;
            }
            String[] parts = ip.split("\\.");
            if (parts.length != 4) {
                return false;
            }
            for (String s : parts) {
                int i = Integer.parseInt(s);
                if (i >= 0 && i <= 255) continue;
                return false;
            }
            return !ip.endsWith(".");
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

