/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.common;

import java.lang.management.ManagementFactory;
import java.util.List;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.Tornado;

public class TornadoOptions {
    private static final String FALSE = "FALSE";
    private static final String TRUE = "TRUE";
    public static final String DEFAULT_OPENCL_COMPILER_FLAGS = Tornado.getProperty("tornado.opencl.compiler.flags", "-cl-mad-enable -cl-fast-relaxed-math -w");
    public static final String DEFAULT_PTX_COMPILER_FLAGS = Tornado.getProperty("tornado.ptx.compiler.flags", "CU_JIT_OPTIMIZATION_LEVEL 4");
    public static final String DEFAULT_SPIRV_LEVEL_ZERO_COMPILER_FLAGS = Tornado.getProperty("tornado.spirv.levelzero.flags", "-ze-opt-level 2 -ze-opt-large-register-file");
    public static final boolean TIME_IN_NANOSECONDS = Boolean.parseBoolean(System.getProperty("tornado.ns.time", "TRUE"));
    public static final int DEFAULT_BACKEND_INDEX = Integer.parseInt(Tornado.getProperty("tornado.backend", "0"));
    public static final int DEFAULT_DEVICE_INDEX = Integer.parseInt(Tornado.getProperty("tornado.device", "0"));
    public static final boolean TORNADO_LOOP_INTERCHANGE = TornadoOptions.getBooleanValue("tornado.loop.interchange", "True");
    public static final boolean THREAD_INFO = TornadoOptions.getBooleanValue("tornado.threadInfo", "FALSE");
    public static final boolean PRINT_KERNEL_SOURCE = TornadoOptions.getBooleanValue("tornado.printKernel", "FALSE");
    public static final int PTX_BACKEND_PRIORITY = Integer.parseInt(Tornado.getProperty("tornado.ptx.priority", "0"));
    public static final int OPENCL_BACKEND_PRIORITY = Integer.parseInt(Tornado.getProperty("tornado.opencl.priority", "10"));
    public static final int SPIRV_BACKEND_PRIORITY = Integer.parseInt(Tornado.getProperty("tornado.spirv.priority", "11"));
    public static final boolean FPGA_EMULATION = TornadoOptions.isFPGAEmulation();
    public static final long DEVICE_AVAILABLE_MEMORY = RuntimeUtilities.parseSize(System.getProperty("tornado.device.memory", "4GB"));
    public static final boolean ENABLE_EXCEPTIONS = Boolean.parseBoolean(System.getProperty("tornado.exceptions", "FALSE"));
    public static final boolean PRINT_BYTECODES = TornadoOptions.getBooleanValue("tornado.print.bytecodes", "FALSE");
    public static final String DUMP_BYTECODES = Tornado.getProperty("tornado.dump.bytecodes.dir", "");
    public static final boolean EXPERIMENTAL_REDUCE = TornadoOptions.getBooleanValue("tornado.experimental.reduce", "TRUE");
    public static final boolean IGNORE_NULL_CHECKS = TornadoOptions.getBooleanValue("tornado.ignore.nullchecks", "FALSE");
    public static final boolean FEATURE_EXTRACTION = TornadoOptions.getBooleanValue("tornado.feature.extraction", "FALSE");
    public static final boolean ENABLE_FMA = TornadoOptions.getBooleanValue("tornado.enable.fma", "TRUE");
    public static final boolean ENABLE_SPIRV_LOOP_UNROLL = TornadoOptions.getBooleanValue("tornado.spirv.loopunroll", "TRUE");
    public static final boolean ENABLE_FIX_READS = TornadoOptions.getBooleanValue("tornado.enable.fix.reads", "TRUE");
    public static final boolean DUMP_EVENTS = Boolean.parseBoolean(Tornado.getProperty("tornado.events.dump", "FALSE"));
    public static final String PRINT_SOURCE_DIRECTORY = Tornado.getProperty("tornado.print.kernel.dir", "");
    public static final boolean CIRCULAR_EVENTS = Boolean.parseBoolean(Tornado.getProperty("tornado.circularevents", "TRUE"));
    public static final int PTX_ARRAY_ALIGNMENT = Integer.parseInt(Tornado.getProperty("tornado.ptx.array.align", "128"));
    public static final int OPENCL_ARRAY_ALIGNMENT = Integer.parseInt(Tornado.getProperty("tornado.opencl.array.align", "128"));
    public static final int SPIRV_ARRAY_ALIGNMENT = Integer.parseInt(Tornado.getProperty("tornado.spirv.array.align", "128"));
    public static final boolean VIRTUAL_DEVICE_ENABLED = TornadoOptions.getBooleanValue("tornado.virtual.device", "FALSE");
    public static final String VIRTUAL_DEVICE_FILE = Tornado.getProperty("tornado.device.desc", "etc/virtual-device-template.json");
    public static final String PROFILER_DIRECTORY = Tornado.getProperty("tornado.profiler.dump.dir", "");
    public static final boolean DUMP_LOW_TIER_WITH_IGV = TornadoOptions.getBooleanValue("tornado.debug.lowtier", "FALSE");
    public static final boolean RECOVER_BAILOUT = TornadoOptions.getBooleanValue("tornado.recover.bailout", "TRUE");
    public static final boolean LOG_IP = TornadoOptions.getBooleanValue("tornado.enable.ip.logging", "FALSE");
    public static final String SOCKET_PORT = Tornado.getProperty("tornado.dump.to.ip", "");
    public static final int TORNADO_SKETCHER_THREADS = Integer.parseInt(Tornado.getProperty("tornado.sketcher.threads", "4"));
    public static final boolean AUTO_PARALLELISATION = TornadoOptions.getBooleanValue("tornado.parallelise.auto", "FALSE");
    public static final boolean FULL_INLINING = TornadoOptions.getBooleanValue("tornado.compiler.fullInlining", "FALSE");
    public static final boolean INLINE_DURING_BYTECODE_PARSING = TornadoOptions.getBooleanValue("tornado.compiler.bytecodeInlining", "FALSE");
    public static final String SPIRV_INSTALLED_RUNTIMES = Tornado.getProperty("tornado.spirv.runtimes", "opencl,levelzero");
    public static final boolean FORCE_CHECK_PARAMETERS = TornadoOptions.getBooleanValue("tornado.check.parameters", "TRUE");
    public static final boolean LEVEL_ZERO_SHARED_MEMORY = TornadoOptions.getBooleanValue("tornado.spirv.levelzero.memoryAlloc.shared", "FALSE");
    public static final boolean SPIRV_RETURN_LABEL = TornadoOptions.getBooleanValue("tornado.spirv.returnlabel", "TRUE");
    public static final boolean SPIRV_DIRECT_CALL_WITH_LOAD_HEAP = TornadoOptions.getBooleanValue("tornado.spirv.directcall.heap", "FALSE");
    public static final float SPIRV_VERSION_SUPPORTED = TornadoOptions.getFloatValue("tornado.spirv.version", "1.2");
    public static final boolean TRACE_CODE_GEN = TornadoOptions.getBooleanValue("tornado.logger.codegen", "FALSE");
    public static final boolean TRACE_BUILD_LIR = TornadoOptions.getBooleanValue("tornado.logger.buildlir", "FALSE");
    public static final boolean ENABLE_NATIVE_FUNCTION = TornadoOptions.getBooleanValue("tornado.enable.nativeFunctions", "TRUE");
    public static final boolean MATH_OPTIMIZATIONS = TornadoOptions.getBooleanValue("tornado.enable.mathOptimizations", "TRUE");
    public static final boolean FAST_MATH_OPTIMIZATIONS = TornadoOptions.getBooleanValue("tornado.enable.fastMathOptimizations", "TRUE");
    public static final boolean OPTIMIZE_LOAD_STORE_SPIRV = TornadoOptions.getBooleanValue("tornado.spirv.loadstore", "TRUE");
    public static final boolean USE_LEVELZERO_THREAD_DISPATCHER_SUGGESTIONS = TornadoOptions.getBooleanValue("tornado.spirv.levelzero.thread.dispatcher", "TRUE");
    public static final int LEVEL_ZERO_BUFFER_ALIGNMENT = TornadoOptions.getIntValue("tornado.spirv.levelzero.alignment", "64");
    public static final boolean LEVEL_ZERO_EXTENDED_MEMORY_MODE = TornadoOptions.getBooleanValue("tornado.spirv.levelzero.extended.memory", "TRUE");
    public static final boolean ENABLE_STREAM_OUT_BLOCKING = TornadoOptions.getBooleanValue("tornado.enable.streamOut.blocking", "TRUE");
    public static final boolean CONCURRENT_INTERPRETERS = Boolean.parseBoolean(System.getProperty("tornado.concurrent.devices", "FALSE"));
    public static final long PANAMA_OBJECT_HEADER_SIZE = TornadoNativeArray.ARRAY_HEADER;
    public static final int MAX_EVENTS = TornadoOptions.getIntValue("tornado.max.events", "32768");
    public static boolean USE_BLOCK_SCHEDULER = TornadoOptions.getBooleanValue("tornado.scheduler.block", "FALSE");
    public static boolean TORNADO_PROFILER_LOG = false;
    public static boolean TORNADO_PROFILER = false;
    public static StringBuilder FPGA_BINARIES = System.getProperty("tornado.precompiled.binary", null) != null ? new StringBuilder(System.getProperty("tornado.precompiled.binary", null)) : null;
    private static String PROFILER_LOG = "tornado.log.profiler";
    private static String PROFILER = "tornado.profiler";
    public static final int UNROLL_FACTOR = Integer.parseInt(Tornado.getProperty("tornado.unroll.factor", "4"));
    public static final boolean DEBUG = TornadoOptions.getBooleanValue("tornado.debug", "FALSE");
    public static final boolean FULL_DEBUG = TornadoOptions.getBooleanValue("tornado.fullDebug", "FALSE");
    public static final boolean DEBUG_KERNEL_ARGS = TornadoOptions.getBooleanValue("tornado.debug.kernelargs", "FALSE");
    public static final boolean USE_SYNC_FLUSH = TornadoOptions.getBooleanValue("tornado.opencl.syncflush", "FALSE");
    public static final boolean USE_VM_FLUSH = TornadoOptions.getBooleanValue("tornado.vmflush", "TRUE");
    public static final int MAX_WAIT_EVENTS = TornadoOptions.getIntValue("tornado.eventpool.maxwaitevents", "64");
    public static final int EVENT_WINDOW = TornadoOptions.getIntValue("tornado.eventpool.size", "1024");
    public static final boolean TORNADO_ENABLE_BIFS = TornadoOptions.getBooleanValue("tornado.bifs.enable", "FALSE");
    public static final boolean VM_USE_DEPS = TornadoOptions.getBooleanValue("tornado.vm.deps", "FALSE");
    public static final boolean ENABLE_OPENCL_PROFILING = TornadoOptions.getBooleanValue("tornado.opencl.profiling.enable", "TRUE");
    public static final boolean DUMP_COMPILED_METHODS = TornadoOptions.getBooleanValue("tornado.compiled.dump", "FALSE");
    public static final boolean ENABLE_OOO_EXECUTION = TornadoOptions.getBooleanValue("tornado.ooo-execution.enable", "FALSE");
    public static final String UPS_IP_ADDRESS = Tornado.getProperty("tornado.ups.ip", null);

    public static boolean PROFILER_LOGS_ACCUMULATE() {
        return TORNADO_PROFILER_LOG || TornadoOptions.getBooleanValue(PROFILER_LOG, FALSE);
    }

    public static boolean LOG_BYTECODES() {
        return PRINT_BYTECODES || !DUMP_BYTECODES.isBlank();
    }

    public static boolean isReusedBuffersEnabled() {
        return TornadoOptions.getBooleanValue("tornado.reuse.device.buffers", TRUE);
    }

    public static boolean isDeallocateBufferEnabled() {
        return TornadoOptions.getBooleanValue("tornado.deallocate.buffers", TRUE);
    }

    public static boolean isProfilerEnabled() {
        return TORNADO_PROFILER || TornadoOptions.getBooleanValue(PROFILER, FALSE);
    }

    public static boolean isUpsReaderEnabled() {
        return UPS_IP_ADDRESS != null;
    }

    public static boolean isPartialUnrollEnabled() {
        return TornadoOptions.getBooleanValue("tornado.experimental.partial.unroll", FALSE);
    }

    private static boolean getBooleanValue(String property, String defaultValue) {
        return Boolean.parseBoolean(System.getProperty(property, defaultValue));
    }

    private static int getIntValue(String property, String defaultValue) {
        return Integer.parseInt(System.getProperty(property, defaultValue));
    }

    private static float getFloatValue(String property, String defaultValue) {
        return Float.parseFloat(System.getProperty(property, defaultValue));
    }

    private static boolean isFPGAEmulation() {
        String contextEmulatorIntelFPGA = System.getenv("CL_CONTEXT_EMULATOR_DEVICE_INTELFPGA");
        String contextEmulatorXilinxFPGA = System.getenv("XCL_EMULATION_MODE");
        return contextEmulatorIntelFPGA != null && contextEmulatorIntelFPGA.equals("1") || contextEmulatorXilinxFPGA != null && contextEmulatorXilinxFPGA.equals("sw_emu");
    }

    public static boolean cleanUpAtomicsSpace() {
        return TornadoOptions.getBooleanValue("tornado.clean.atomics.space", FALSE);
    }

    public static boolean coopsUsed() {
        List<String> jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        boolean isUncompressed = jvmArgs.contains("-XX:-UseCompressedOops") || jvmArgs.contains("-XX:-UseCompressedClassPointers");
        return !isUncompressed;
    }
}

