/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class TornadoLogger {
    private final Logger logger;
    private final boolean isLogOptionEnabled = TornadoOptions.DEBUG || TornadoOptions.FULL_DEBUG;

    public TornadoLogger(Class<?> clazz) {
        this.logger = clazz == null ? Logger.getAnonymousLogger() : Logger.getLogger(clazz.getName());
    }

    public TornadoLogger() {
        this(null);
    }

    public void debug(String msg) {
        if (this.isLogOptionEnabled) {
            this.logger.setLevel(Level.INFO);
            this.logger.info(msg);
        }
    }

    public void debug(String pattern, Object ... args) {
        this.debug(String.format(pattern, args));
    }

    public void error(String msg) {
        if (this.isLogOptionEnabled) {
            this.logger.setLevel(Level.SEVERE);
            this.logger.severe(msg);
        }
    }

    public void error(String pattern, Object ... args) {
        if (this.isLogOptionEnabled) {
            this.error(String.format(pattern, args));
        }
    }

    public void fatal(String msg) {
        if (this.isLogOptionEnabled) {
            this.logger.setLevel(Level.SEVERE);
            this.logger.severe(msg);
        }
    }

    public void fatal(String pattern, Object ... args) {
        this.fatal(String.format(pattern, args));
    }

    public void info(String msg) {
        if (this.isLogOptionEnabled) {
            this.logger.setLevel(Level.INFO);
            this.logger.info(msg);
        }
    }

    public void info(String pattern, Object ... args) {
        this.info(String.format(pattern, args));
    }

    public void trace(String msg) {
        if (this.isLogOptionEnabled) {
            this.logger.setLevel(Level.INFO);
            this.logger.info(msg);
        }
    }

    public void trace(String pattern, Object ... args) {
        this.trace(String.format(pattern, args));
    }

    public void warn(String msg) {
        if (this.isLogOptionEnabled) {
            this.logger.setLevel(Level.WARNING);
            this.logger.warning(msg);
        }
    }

    public void warn(String msg, Object ... args) {
        this.trace(String.format(msg, args));
    }
}

