/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import uk.ac.manchester.tornado.api.TornadoSetting;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;

public final class Tornado
implements TornadoSetting {
    private static final String TORNADOVM_HOME_VARIABLE = "TORNADOVM_HOME";
    private static final Properties settings = System.getProperties();

    private static void setProperty(String key, String value) {
        settings.setProperty(key, value);
    }

    public static String getProperty(String key) {
        return settings.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return settings.getProperty(key, defaultValue);
    }

    private static void loadSettings(String filename) {
        File localSettings = new File(filename);
        Properties loadProperties = new Properties();
        if (localSettings.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(localSettings);){
                loadProperties.load(fileInputStream);
            }
            catch (IOException e) {
                new TornadoLogger().warn("Unable to load settings from %s", localSettings.getAbsolutePath());
            }
        }
        Set<String> localKeys = loadProperties.stringPropertyNames();
        Set<String> systemKeys = settings.stringPropertyNames();
        HashSet<String> diff = new HashSet<String>(localKeys);
        diff.removeAll(systemKeys);
        diff.forEach(key -> settings.setProperty((String)key, loadProperties.getProperty((String)key)));
    }

    private static void tryLoadSettings() {
        String tornadoRoot = System.getenv(TORNADOVM_HOME_VARIABLE);
        Tornado.loadSettings(tornadoRoot + "/etc/tornado.properties");
    }

    public void setTornadoProperty(String key, String value) {
        Tornado.setProperty(key, value);
    }

    public String getTornadoProperty(String key) {
        return Tornado.getProperty(key);
    }

    public String getTornadoProperty(String key, String defaultValue) {
        return Tornado.getProperty(key, defaultValue);
    }

    public void loadTornadoProperty(String filename) {
        Tornado.loadSettings(filename);
    }

    static {
        Tornado.tryLoadSettings();
    }
}

