/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.common;

import java.util.Arrays;

public class Statistics {
    double[] data;
    double size;

    public Statistics(double[] data) {
        this.data = data;
        this.size = data.length;
    }

    public double getMean() {
        double sum = 0.0;
        for (double a : this.data) {
            sum += a;
        }
        return sum / this.size;
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public double getSum() {
        double sum = 0.0;
        for (double a : this.data) {
            sum += a;
        }
        return sum;
    }

    public double getVariance() {
        double mean = this.getMean();
        double temp = 0.0;
        for (double a : this.data) {
            temp += (mean - a) * (mean - a);
        }
        return temp / this.size;
    }

    public double median() {
        double[] b = new double[this.data.length];
        System.arraycopy(this.data, 0, b, 0, b.length);
        Arrays.sort(b);
        if (this.data.length % 2 == 0) {
            return (b[b.length / 2 - 1] + b[b.length / 2]) / 2.0;
        }
        return b[b.length / 2];
    }
}

