/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.loop.BasicInductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graal.nodes.ParallelRangeNode;
import uk.ac.manchester.tornado.runtime.graal.nodes.TornadoLoopsData;

public final class RuntimeUtilities {
    public static final int ONE_GIGABYTE = 0x40000000;
    public static final int ONE_MEGABYTE = 0x100000;
    public static final int ONE_KILOBYTE = 1024;
    public static final String FPGA_OUTPUT_FILENAME = "outputFPGA.log";
    public static final String FPGA_ERROR_FILENAME = "errorFPGA.log";
    public static final String BYTECODES_FILENAME = "tornadovm_bytecodes.log";

    private RuntimeUtilities() {
    }

    public static long parseSize(String size) {
        if (size.endsWith("B")) {
            int index = size.indexOf("B");
            String prefixes = "KMGTPE";
            if ("KMGTPE".contains(size.substring(index - 1, index))) {
                int prefix = "KMGTPE".indexOf(size.charAt(index - 1));
                long base = 1024L;
                long unit = (long)Math.pow(1024.0, prefix + 1);
                return Long.parseLong(size.substring(0, index - 1)) * unit;
            }
            return Long.parseLong(size.substring(0, index - 1));
        }
        return Long.parseLong(size);
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableFreq(int freq) {
        int unit = 1000;
        if (freq < 1000) {
            return freq + " MHz";
        }
        int exp = (int)(Math.log(freq) / Math.log(1000.0));
        char pre = "GT".charAt(exp - 1);
        return String.format("%.1f %sHz", (double)freq / Math.pow(1000.0, exp), Character.valueOf(pre));
    }

    public static String formatBytes(long bytes) {
        String out = "";
        out = bytes >= 0x40000000L ? String.format("%.2f GB", (double)bytes / 1.073741824E9) : (bytes >= 0x100000L ? String.format("%.2f MB", (double)bytes / 1048576.0) : (bytes >= 1024L ? String.format("%.2f KB", (double)bytes / 1024.0) : String.format("%d B", bytes)));
        return out;
    }

    public static String formatBytesPerSecond(double bytes) {
        String out = "";
        out = bytes >= 1.073741824E9 ? String.format("%.2f GB/s", bytes / 1.073741824E9) : (bytes >= 1048576.0 ? String.format("%.2f MB/s", bytes / 1048576.0) : (bytes >= 1024.0 ? String.format("%.2f KB/s", bytes / 1024.0) : String.format("%f B/s", bytes)));
        return out;
    }

    public static boolean isBoxedPrimitive(Object obj) {
        boolean isBox = false;
        if (obj instanceof Boolean) {
            isBox = true;
        } else if (obj instanceof Byte) {
            isBox = true;
        } else if (obj instanceof Character) {
            isBox = true;
        } else if (obj instanceof Short) {
            isBox = true;
        } else if (obj instanceof HalfFloat) {
            isBox = true;
        } else if (obj instanceof Integer) {
            isBox = true;
        } else if (obj instanceof Long) {
            isBox = true;
        } else if (obj instanceof Float) {
            isBox = true;
        } else if (obj instanceof Double) {
            isBox = true;
        }
        return isBox;
    }

    public static boolean isBoxedPrimitiveClass(Class<?> klass) {
        boolean isBox = false;
        if (klass == Boolean.class) {
            isBox = true;
        } else if (klass == Byte.class) {
            isBox = true;
        } else if (klass == Character.class) {
            isBox = true;
        } else if (klass == Short.class) {
            isBox = true;
        } else if (klass == HalfFloat.class) {
            isBox = true;
        } else if (klass == Integer.class) {
            isBox = true;
        } else if (klass == Long.class) {
            isBox = true;
        } else if (klass == Float.class) {
            isBox = true;
        } else if (klass == Double.class) {
            isBox = true;
        }
        return isBox;
    }

    public static Class<?> toUnboxedPrimitiveClass(Class<?> clazz) {
        Class<Comparable<Boolean>> result = null;
        if (clazz == Boolean.class) {
            result = Boolean.TYPE;
        } else if (clazz == Byte.class) {
            result = Byte.TYPE;
        } else if (clazz == Character.class) {
            result = Character.TYPE;
        } else if (clazz == Short.class) {
            result = Short.TYPE;
        } else if (clazz == Integer.class) {
            result = Integer.TYPE;
        } else if (clazz == Long.class) {
            result = Long.TYPE;
        } else if (clazz == Float.class) {
            result = Float.TYPE;
        } else if (clazz == Double.class) {
            result = Double.TYPE;
        }
        return result != null ? result : clazz;
    }

    public static boolean isPrimitiveArray(Class<?> type) {
        Class<?> componentType = type.getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        return componentType.isPrimitive() || RuntimeUtilities.isBoxedPrimitive(componentType);
    }

    public static void printBuffer(ByteBuffer buffer) {
        int i;
        System.out.printf("buffer : position=%d, remaining=%d, capacity=%d, limit=%d\n", buffer.position(), buffer.remaining(), buffer.capacity(), buffer.limit());
        System.out.printf("array  : length=%d, offset=%d\n", buffer.array().length, buffer.arrayOffset());
        System.out.printf("%-8s: ", "Index");
        for (i = 0; i < 8; ++i) {
            System.out.printf("%-8d ", i * 4);
        }
        System.out.println();
        System.out.println();
        System.out.printf("", new Object[0]);
        for (i = 0; i < buffer.remaining(); i += 32) {
            System.out.printf("%-8d: ", i);
            for (int j = 0; j < 32; j += 4) {
                for (int k = 0; k < 4; ++k) {
                    if (i + j + k < buffer.remaining()) {
                        byte b = buffer.get(i + j + k);
                        System.out.printf("%02x", b);
                        continue;
                    }
                    System.out.printf("%2s", "..");
                }
                System.out.printf(" ", new Object[0]);
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void printBuffer(ByteBuffer buffer, int start, int len) {
        int i;
        System.out.printf("Index : ", new Object[0]);
        for (i = 0; i < 5; ++i) {
            System.out.printf(" %8d", i);
        }
        System.out.println();
        System.out.printf("Buffer: ", new Object[0]);
        for (i = 0; i < len; ++i) {
            System.out.printf(" %2X", buffer.get(start + i));
        }
        System.out.println();
    }

    public static double elapsedTimeInSeconds(long start, long end) {
        return RuntimeUtilities.elapsedTimeInSeconds(end - start);
    }

    public static double elapsedTimeInSeconds(long duration) {
        return (double)duration * 1.0E-9;
    }

    public static double elapsedTimeInMilliSeconds(long start, long end) {
        return BigDecimal.valueOf((double)(end - start) * 1.0E-6).setScale(5, RoundingMode.HALF_UP).doubleValue();
    }

    public static double elapsedTimeInMilliSeconds(long time) {
        return BigDecimal.valueOf((double)time * 1.0E-6).setScale(5, RoundingMode.HALF_UP).doubleValue();
    }

    public static String formatArray(Object object) {
        String result;
        if (object.getClass().isArray()) {
            int len = Array.getLength(object);
            result = String.format("%s[%d]", object.getClass().getComponentType().getName(), len);
        } else {
            result = object.toString();
        }
        return result;
    }

    public static boolean isPrimitive(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        return RuntimeUtilities.isBoxedPrimitive(type);
    }

    public static String formatMethod(ResolvedJavaMethod method) {
        Signature sig = method.getSignature();
        JavaKind rt = sig.getReturnKind();
        StringBuilder sb = new StringBuilder();
        sb.append(rt.getJavaName()).append(" ");
        sb.append(method.getName()).append("(");
        for (int i = 0; i < sig.getParameterCount(!method.isStatic()); ++i) {
            JavaKind jk = sig.getParameterKind(i);
            sb.append(jk.toString());
            if (i >= sig.getParameterCount(!method.isStatic()) - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private static void printInductionVariables(StructuredGraph graph) {
        TornadoLoopsData data = new TornadoLoopsData(graph);
        data.detectCountedLoops();
        List loops = data.outerFirst();
        List parRanges = graph.getNodes().filter(ParallelRangeNode.class).snapshot();
        for (LoopEx loop : loops) {
            for (ParallelRangeNode parRange : parRanges) {
                for (Node n : parRange.offset().usages()) {
                    if (!loop.getInductionVariables().containsKey((Object)n)) continue;
                    BasicInductionVariable iv = (BasicInductionVariable)loop.getInductionVariables().get((Object)n);
                    System.out.printf("[%d] parallel loop: %s -> init=%s, cond=%s, stride=%s, op=%s\n", parRange.index(), loop.loopBegin(), parRange.offset().value(), parRange.value(), parRange.stride(), iv.getOp());
                }
            }
        }
    }

    public static void dumpKernel(byte[] source) {
        String sourceCode = new String(source);
        if (TornadoOptions.PRINT_SOURCE_DIRECTORY.isEmpty()) {
            System.out.println(sourceCode);
        } else {
            File fileLog = new File(TornadoOptions.PRINT_SOURCE_DIRECTORY);
            try (FileWriter file = new FileWriter(fileLog, fileLog.exists());){
                file.write(sourceCode);
                file.write("\n");
                file.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void systemCall(String[] command, boolean printStandardOutput, String loggingDirectory) throws IOException {
        StringBuilder standardOutput = new StringBuilder();
        StringBuilder errorOutput = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        TornadoLogger logger = new TornadoLogger();
        try {
            String stdOutput;
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            standardOutput.append("Standard output:").append(lineSeparator);
            String fullCommand = Arrays.toString(command);
            standardOutput.append("Command: ").append(fullCommand).append(lineSeparator).append(lineSeparator);
            while ((stdOutput = stdInput.readLine()) != null) {
                standardOutput.append(stdOutput).append(lineSeparator);
            }
            standardOutput.append("--------------------------------------------------------------------\n");
            errorOutput.append("Standard error (if any) of the command (").append(Arrays.toString(command)).append("):\n");
            while ((stdOutput = stdError.readLine()) != null) {
                errorOutput.append(stdOutput).append(lineSeparator);
            }
            errorOutput.append("--------------------------------------------------------------------\n");
            if (printStandardOutput) {
                System.out.println(standardOutput.toString());
                System.out.println(errorOutput.toString());
            }
            RuntimeUtilities.writeStringToFile(loggingDirectory + FPGA_OUTPUT_FILENAME, standardOutput.toString(), true);
            RuntimeUtilities.writeStringToFile(loggingDirectory + FPGA_ERROR_FILENAME, errorOutput.toString(), true);
        }
        catch (IOException e) {
            logger.error("Unable to make a native system call.", e);
            throw new IOException(e);
        }
        catch (Throwable t) {
            logger.error("Unable to make a native system call.", t);
            throw new TornadoRuntimeException(t.getMessage());
        }
    }

    public static void writeStreamToFile(File file, byte[] source, boolean append) {
        try (FileOutputStream fos = append ? new FileOutputStream(file, true) : new FileOutputStream(file);){
            fos.write(source);
        }
        catch (IOException e) {
            new TornadoLogger().error("unable to dump source: ", e.getMessage());
            throw new RuntimeException("unable to dump source: " + e.getMessage());
        }
    }

    public static void writeStringToFile(String filename, String source, boolean append) {
        try (FileWriter fw = new FileWriter(filename, append);){
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(source);
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            new TornadoLogger().error("unable to dump source: ", e.getMessage());
            throw new RuntimeException("unable to dump source: " + e.getMessage());
        }
    }

    public static void writeToFile(String file, byte[] binary) {
        new TornadoLogger().info("dumping binary %s", file);
        try (FileOutputStream fis = new FileOutputStream(file);){
            fis.write(binary);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getTornadoInstanceIP() {
        String localIP = null;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            localIP = ip.getHostAddress();
        }
        catch (UnknownHostException e) {
            System.out.println("Exception occurred" + e.getMessage());
        }
        return localIP;
    }

    public static void profilerFileWriter(String jsonProfile) {
        try (FileWriter fileWriter = new FileWriter(TornadoOptions.PROFILER_DIRECTORY, true);){
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println(jsonProfile);
        }
        catch (IOException e) {
            throw new TornadoRuntimeException("JSon profiler file cannot be append");
        }
    }

    public static void writeBytecodeToFile(StringBuilder logBuilder) {
        if (logBuilder == null) {
            return;
        }
        String filePath = RuntimeUtilities.getFilePath();
        try (FileWriter fw = new FileWriter(filePath, true);
             BufferedWriter bw = new BufferedWriter(fw);){
            String cleanedString = RuntimeUtilities.removeAnsiEscapeCodes(logBuilder.toString());
            bw.write(cleanedString);
            bw.flush();
        }
        catch (IOException e) {
            new TornadoLogger().error("unable to dump bytecodes: ", e.getMessage());
            throw new RuntimeException("unable to dump bytecodes: " + e.getMessage());
        }
    }

    private static String removeAnsiEscapeCodes(String input) {
        return input.replaceAll("\u001b\\[[;\\d]*m", "");
    }

    private static String getFilePath() {
        Object filePath;
        if (TornadoOptions.DUMP_BYTECODES != null && !TornadoOptions.DUMP_BYTECODES.isEmpty()) {
            File directory = new File(TornadoOptions.DUMP_BYTECODES);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            filePath = TornadoOptions.DUMP_BYTECODES + File.separator + BYTECODES_FILENAME;
        } else {
            filePath = BYTECODES_FILENAME;
        }
        return filePath;
    }
}

