/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.analyzer;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import uk.ac.manchester.tornado.api.common.PrebuiltTaskPackage;
import uk.ac.manchester.tornado.api.common.TornadoFunctions;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.tasks.CompilableTask;
import uk.ac.manchester.tornado.runtime.tasks.PrebuiltTask;
import uk.ac.manchester.tornado.runtime.tasks.meta.ScheduleContext;

public class TaskUtils {
    private static final String JDK_VM_CI_HOTSPOT_JDK_REFLECTION = "jdk.vm.ci.hotspot.HotSpotJDKReflection";
    private static final String JDK_VM_CI_HOTSPOT_RESOLVED_JAVA_METHOD_IMPL = "jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl";
    private static boolean useToJavaMethod = false;

    public static CompilableTask scalaTask(String id, Object object, Object ... args) {
        Class<?> type = object.getClass();
        Method entryPoint = null;
        for (Method m : type.getDeclaredMethods()) {
            if (!m.getName().equals("apply") || m.isSynthetic() || m.isBridge()) continue;
            entryPoint = m;
            break;
        }
        TornadoInternalError.unimplemented((String)"scala task");
        return TaskUtils.createTask(null, id, entryPoint, object, false, args);
    }

    private static Method callToJava(JavaMethod javaMethod) {
        try {
            Class<?> hotSpotResolvedJavaMethodImpl = Class.forName(JDK_VM_CI_HOTSPOT_RESOLVED_JAVA_METHOD_IMPL);
            Method toJava = hotSpotResolvedJavaMethodImpl.getDeclaredMethod("toJava", new Class[0]);
            toJava.setAccessible(true);
            Method m = (Method)toJava.invoke((Object)javaMethod, new Object[0]);
            m.setAccessible(true);
            return m;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            TornadoInternalError.shouldNotReachHere((String)"Both HotSpotResolvedJavaMethodImpl::toJava and HotSpotJDKReflection::getMethod are missing from the JDK !");
            return null;
        }
    }

    private static Method callGetMethod(JavaMethod javaMethod) {
        try {
            Class<?> hotSpotJDKReflection = Class.forName(JDK_VM_CI_HOTSPOT_JDK_REFLECTION);
            Method getMethod = null;
            for (Method method : hotSpotJDKReflection.getDeclaredMethods()) {
                if (!"getMethod".equals(method.getName())) continue;
                getMethod = method;
                break;
            }
            getMethod.setAccessible(true);
            Method m = (Method)getMethod.invoke(hotSpotJDKReflection, javaMethod);
            m.setAccessible(true);
            return m;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            new TornadoLogger().debug("HotSpotJDKReflection::getMethod is missing from the JDK distribution. Falling back to HotSpotResolvedJavaMethodImpl::toJava");
            useToJavaMethod = true;
            return TaskUtils.callToJava(javaMethod);
        }
    }

    public static Method resolveMethodHandle(Object task) {
        Class<?> type = task.getClass();
        Method entryPoint = null;
        for (Method m : type.getDeclaredMethods()) {
            if (!m.getName().equals("apply")) continue;
            entryPoint = m;
        }
        TornadoInternalError.guarantee((entryPoint != null ? 1 : 0) != 0, (String)"unable to find entry point", (Object[])new Object[0]);
        ResolvedJavaMethod resolvedMethod = TornadoCoreRuntime.getVMBackend().getMetaAccess().lookupJavaMethod((Executable)entryPoint);
        ConstantPool cp = resolvedMethod.getConstantPool();
        byte[] bc = resolvedMethod.getCode();
        block14: for (int i = 0; i < bc.length; ++i) {
            JavaMethod jm;
            if (bc[i] == -72) {
                cp.loadReferencedType((int)bc[i + 2], 184);
                jm = cp.lookupMethod((int)bc[i + 2], 184);
                if (useToJavaMethod) {
                    return TaskUtils.callToJava(jm);
                }
                return TaskUtils.callGetMethod(jm);
            }
            if (bc[i] != -74) continue;
            cp.loadReferencedType((int)bc[i + 2], 182);
            jm = cp.lookupMethod((int)bc[i + 2], 182);
            switch (jm.getName()) {
                case "booleanValue": 
                case "byteValue": 
                case "charValue": 
                case "shortValue": 
                case "intValue": 
                case "floatValue": 
                case "doubleValue": 
                case "longValue": {
                    continue block14;
                }
                default: {
                    if (useToJavaMethod) {
                        return TaskUtils.callToJava(jm);
                    }
                    return TaskUtils.callGetMethod(jm);
                }
            }
        }
        TornadoInternalError.shouldNotReachHere();
        return null;
    }

    public static CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task code) {
        return TaskUtils.createTask(meta, id, method, code, true, new Object[0]);
    }

    public static <T1> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task1<T1> code, T1 arg1) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1);
    }

    public static <T1, T2> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task2<T1, T2> code, T1 arg1, T2 arg2) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2);
    }

    public static <T1, T2, T3> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task3<T1, T2, T3> code, T1 arg1, T2 arg2, T3 arg3) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3);
    }

    public static <T1, T2, T3, T4> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task4<T1, T2, T3, T4> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3, arg4);
    }

    public static <T1, T2, T3, T4, T5> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task5<T1, T2, T3, T4, T5> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3, arg4, arg5);
    }

    public static <T1, T2, T3, T4, T5, T6> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task6<T1, T2, T3, T4, T5, T6> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task7<T1, T2, T3, T4, T5, T6, T7> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task8<T1, T2, T3, T4, T5, T6, T7, T8> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task9<T1, T2, T3, T4, T5, T6, T7, T8, T9> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> CompilableTask createTask(Method method, ScheduleContext meta, String id, TornadoFunctions.Task15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> code, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14, T15 arg15) {
        return TaskUtils.createTask(meta, id, method, code, true, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
    }

    private static Object[] extractCapturedVariables(Object code) {
        Class<?> type = code.getClass();
        int count = 0;
        for (Field field : type.getDeclaredFields()) {
            if (field.getType().getName().contains("$$Lambda$") || field.getName().contains("LAMBDA_INSTANCE$")) continue;
            ++count;
        }
        Object[] cvs = new Object[count];
        int index = 0;
        for (Field field : type.getDeclaredFields()) {
            if (field.getType().getName().contains("$$Lambda$") || field.getName().contains("LAMBDA_INSTANCE$")) continue;
            field.setAccessible(true);
            try {
                cvs[index] = field.get(code);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            ++index;
        }
        return cvs;
    }

    public static PrebuiltTask createTask(ScheduleContext meta, PrebuiltTaskPackage taskPackage) {
        PrebuiltTask prebuiltTask = new PrebuiltTask(meta, taskPackage.getId(), taskPackage.getEntryPoint(), taskPackage.getFilename(), taskPackage.getArgs(), taskPackage.getAccesses());
        if (taskPackage.getAtomics() != null) {
            prebuiltTask.setAtomics(taskPackage.getAtomics());
        }
        return prebuiltTask;
    }

    private static CompilableTask createTask(ScheduleContext meta, String id, Method method, Object code, boolean extractCVs, Object ... args) {
        int n;
        int n2;
        Object[] objectArray;
        int numArgs;
        Object[] cvs;
        if (extractCVs) {
            cvs = TaskUtils.extractCapturedVariables(code);
            numArgs = cvs.length + args.length;
        } else {
            cvs = null;
            numArgs = args.length;
        }
        Object[] parameters = new Object[numArgs];
        int index = 0;
        if (extractCVs) {
            objectArray = cvs;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                Object cv;
                parameters[index] = cv = objectArray[n];
                ++index;
            }
        }
        objectArray = args;
        n2 = objectArray.length;
        for (n = 0; n < n2; ++n) {
            Object arg;
            parameters[index] = arg = objectArray[n];
            ++index;
        }
        return new CompilableTask(meta, id, method, parameters);
    }
}

