/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.analyzer;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.runtime.JVMCI;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.runtime.GraalJVMCICompiler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.GraalCompiler;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.CompilationRequestIdentifier;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpScope;
import org.graalvm.compiler.hotspot.HotSpotGraalOptionValues;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.runtime.RuntimeProvider;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.analyzer.TaskUtils;

public class CodeAnalysis {
    public static StructuredGraph buildHighLevelGraalGraph(Object taskInputCode) {
        StructuredGraph structuredGraph;
        block9: {
            Method methodToCompile = TaskUtils.resolveMethodHandle(taskInputCode);
            GraalJVMCICompiler graalCompiler = (GraalJVMCICompiler)JVMCI.getRuntime().getCompiler();
            RuntimeProvider capability = (RuntimeProvider)graalCompiler.getGraalRuntime().getCapability(RuntimeProvider.class);
            Backend backend = capability.getHostBackend();
            Providers providers = backend.getProviders();
            MetaAccessProvider metaAccess = providers.getMetaAccess();
            ResolvedJavaMethod resolvedJavaMethod = metaAccess.lookupJavaMethod((Executable)methodToCompile);
            CompilationIdentifier compilationIdentifier = backend.getCompilationIdentifier(resolvedJavaMethod);
            SpeculationLog speculationLog = resolvedJavaMethod.getSpeculationLog();
            if (speculationLog != null) {
                speculationLog.collectFailedSpeculations();
            }
            DebugContext.Scope ignored = TornadoCoreRuntime.getDebugContext().scope((Object)"compileMethodAndInstall", (Object)new DebugDumpScope("TornadoVM-Code-Analysis", true));
            try {
                EconomicMap opts = OptionValues.newOptionMap();
                opts.putAll(HotSpotGraalOptionValues.defaultOptions().getMap());
                OptionValues options = new OptionValues((UnmodifiableEconomicMap)opts);
                StructuredGraph graph = new StructuredGraph.Builder(options, TornadoCoreRuntime.getDebugContext(), StructuredGraph.AllowAssumptions.YES).speculationLog(speculationLog).method(resolvedJavaMethod).compilationId(compilationIdentifier).build();
                PhaseSuite graphBuilderSuite = new PhaseSuite();
                graphBuilderSuite.appendPhase((BasePhase)new GraphBuilderPhase(GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)new GraphBuilderConfiguration.Plugins(new InvocationPlugins()))));
                graphBuilderSuite.apply(graph, (Object)new HighTierContext(providers, graphBuilderSuite, OptimisticOptimizations.ALL));
                TornadoCoreRuntime.getDebugContext().dump(1, (Object)graph, "CodeToAnalyze");
                structuredGraph = graph;
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ignored.close();
        }
        return structuredGraph;
    }

    public static InstalledCode compileAndInstallMethod(StructuredGraph graph) {
        InstalledCode installedCode;
        block8: {
            ResolvedJavaMethod method = graph.method();
            GraalJVMCICompiler graalCompiler = (GraalJVMCICompiler)JVMCI.getRuntime().getCompiler();
            RuntimeProvider capability = (RuntimeProvider)graalCompiler.getGraalRuntime().getCapability(RuntimeProvider.class);
            Backend backend = capability.getHostBackend();
            Providers providers = backend.getProviders();
            CompilationIdentifier compilationID = backend.getCompilationIdentifier(method);
            EconomicMap opts = OptionValues.newOptionMap();
            opts.putAll(HotSpotGraalOptionValues.defaultOptions().getMap());
            OptionValues options = new OptionValues((UnmodifiableEconomicMap)opts);
            DebugContext.Scope ignored = TornadoCoreRuntime.getDebugContext().scope((Object)"compileMethodAndInstall", (Object)new DebugDumpScope(String.valueOf(compilationID), true));
            try {
                PhaseSuite graphBuilderPhase = backend.getSuites().getDefaultGraphBuilderSuite();
                Suites suites = backend.getSuites().getDefaultSuites(options, providers.getLowerer().getTarget().arch);
                LIRSuites lirSuites = backend.getSuites().getDefaultLIRSuites(options);
                OptimisticOptimizations optimizationsOpts = OptimisticOptimizations.ALL;
                ProfilingInfo profilerInfo = graph.getProfilingInfo(method);
                CompilationResult compilationResult = new CompilationResult(method.getSignature().toMethodDescriptor());
                CompilationResultBuilderFactory factory = CompilationResultBuilderFactory.Default;
                GraalCompiler.compileGraph((StructuredGraph)graph, (ResolvedJavaMethod)method, (Providers)providers, (Backend)backend, (PhaseSuite)graphBuilderPhase, (OptimisticOptimizations)optimizationsOpts, (ProfilingInfo)profilerInfo, (Suites)suites, (LIRSuites)lirSuites, (CompilationResult)compilationResult, (CompilationResultBuilderFactory)factory, (boolean)false);
                installedCode = backend.addInstalledCode(TornadoCoreRuntime.getDebugContext(), method, CompilationRequestIdentifier.asCompilationRequest((CompilationIdentifier)compilationID), compilationResult);
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw TornadoCoreRuntime.getDebugContext().handle(e);
                }
            }
            ignored.close();
        }
        return installedCode;
    }
}

