/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.exceptions.TornadoBailoutRuntimeException;
import uk.ac.manchester.tornado.api.exceptions.TornadoDeviceFP64NotSupported;
import uk.ac.manchester.tornado.api.exceptions.TornadoFailureException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.runtime.EmptyEvent;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.graph.TornadoExecutionContext;
import uk.ac.manchester.tornado.runtime.graph.TornadoGraph;
import uk.ac.manchester.tornado.runtime.graph.TornadoVMBytecodeResult;
import uk.ac.manchester.tornado.runtime.graph.TornadoVMGraphCompiler;
import uk.ac.manchester.tornado.runtime.interpreter.TornadoVMInterpreter;

public class TornadoVM {
    private TornadoExecutionContext executionContext;
    private TornadoProfiler timeProfiler;
    private final TornadoVMBytecodeResult[] tornadoVMBytecodes;
    private final TornadoVMInterpreter[] tornadoVMInterpreters;

    public TornadoVM(TornadoExecutionContext executionContext, TornadoGraph tornadoGraph, TornadoProfiler timeProfiler) {
        this.executionContext = executionContext;
        this.timeProfiler = timeProfiler;
        this.tornadoVMBytecodes = TornadoVMGraphCompiler.compile(tornadoGraph, executionContext);
        this.tornadoVMInterpreters = new TornadoVMInterpreter[executionContext.getValidContextSize()];
        this.bindBytecodesToInterpreters();
    }

    private void bindBytecodesToInterpreters() {
        assert (this.tornadoVMInterpreters.length == this.executionContext.getValidContextSize());
        Deque<Integer> activeDevices = this.executionContext.getActiveDeviceIndexes();
        int bound = this.executionContext.getValidContextSize();
        for (int i = 0; i < bound; ++i) {
            this.tornadoVMInterpreters[i] = new TornadoVMInterpreter(this.executionContext, this.tornadoVMBytecodes[i], this.timeProfiler, this.executionContext.getDevice(activeDevices.pop()));
        }
    }

    public Event execute(boolean isParallel, TornadoProfiler profiler) {
        this.timeProfiler = profiler;
        Arrays.stream(this.tornadoVMInterpreters).forEach(tornadoVMInterpreter -> tornadoVMInterpreter.setTimeProfiler(this.timeProfiler));
        if (this.shouldInterpreterRunInParallel(isParallel)) {
            return this.executeInterpreterThreadManager(isParallel);
        }
        return this.executeInterpreterSingleThreaded();
    }

    private int calculateNumberOfJavaThreads(boolean isTaskGraphConcurrent) {
        return this.shouldRunConcurrently(isTaskGraphConcurrent) ? this.executionContext.getValidContextSize() : 1;
    }

    private boolean shouldInterpreterRunInParallel(boolean isParallel) {
        return this.calculateNumberOfJavaThreads(isParallel) != 1;
    }

    private Event executeInterpreterSingleThreaded() {
        Arrays.stream(this.tornadoVMInterpreters).forEach(TornadoVMInterpreter::execute);
        return new EmptyEvent();
    }

    private Event executeInterpreterThreadManager(boolean isParallel) {
        int numberOfJavaThreads = this.calculateNumberOfJavaThreads(isParallel);
        ExecutorService executor = Executors.newFixedThreadPool(numberOfJavaThreads);
        ArrayList<Future<Event>> futures = new ArrayList<Future<Event>>();
        for (TornadoVMInterpreter tornadoVMInterpreter : this.tornadoVMInterpreters) {
            Future<Event> future = executor.submit(tornadoVMInterpreter::execute);
            futures.add(future);
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TornadoBailoutRuntimeException) {
                throw new TornadoBailoutRuntimeException(e.getMessage());
            }
            if (throwable instanceof TornadoFailureException) {
                throw new TornadoFailureException(e);
            }
            if (throwable instanceof TornadoRuntimeException) {
                throw new TornadoRuntimeException(e);
            }
            if (throwable instanceof TornadoDeviceFP64NotSupported) {
                throw new TornadoDeviceFP64NotSupported(e.getMessage());
            }
            throw new RuntimeException(e);
        }
        finally {
            executor.shutdown();
        }
        return new EmptyEvent();
    }

    private boolean shouldRunConcurrently(boolean isTaskGraphConcurrent) {
        return (isTaskGraphConcurrent || TornadoOptions.CONCURRENT_INTERPRETERS) && this.executionContext.getValidContextSize() > 1;
    }

    public void executeActionOnInterpreters(Consumer<TornadoVMInterpreter> action) {
        Arrays.stream(this.tornadoVMInterpreters).forEach(action::accept);
    }

    public void dumpProfiles() {
        this.executeActionOnInterpreters(TornadoVMInterpreter::dumpProfiles);
    }

    public void dumpEvents() {
        this.executeActionOnInterpreters(TornadoVMInterpreter::dumpEvents);
    }

    public void clearProfiles() {
        this.executeActionOnInterpreters(TornadoVMInterpreter::clearProfiles);
    }

    public void printTimes() {
        this.executeActionOnInterpreters(TornadoVMInterpreter::printTimes);
    }

    public void withPreCompilation() {
        this.executeActionOnInterpreters(TornadoVMInterpreter::withPreCompilation);
    }

    public void setGridScheduler(GridScheduler gridScheduler) {
        Arrays.stream(this.tornadoVMInterpreters).forEach(interpreter -> interpreter.setGridScheduler(gridScheduler));
    }
}

