/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.StreamSupport;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.runtime.JVMCIBackend;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotGraalOptionValues;
import org.graalvm.compiler.lir.constopt.ConstantLoadOptimization;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationStage;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import uk.ac.manchester.tornado.api.TornadoBackend;
import uk.ac.manchester.tornado.api.TornadoRuntime;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoBackendNotFound;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.runtime.JVMMapping;
import uk.ac.manchester.tornado.runtime.TornadoAcceleratorBackend;
import uk.ac.manchester.tornado.runtime.TornadoBackendProvider;
import uk.ac.manchester.tornado.runtime.TornadoVMConfigAccess;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.common.UpsMeterReader;
import uk.ac.manchester.tornado.runtime.common.enums.TornadoBackends;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoSnippetReflectionProvider;

public final class TornadoCoreRuntime
implements TornadoRuntime {
    private static final ThreadFactory executorThreadFactory = new ThreadFactory(){
        private int threadId = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, String.format("TornadoExecutorThread - %d", this.threadId));
            thread.setDaemon(true);
            ++this.threadId;
            return thread;
        }
    };
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(TornadoOptions.TORNADO_SKETCHER_THREADS, executorThreadFactory);
    private static final TornadoCoreRuntime runtime = new TornadoCoreRuntime();
    private static final JVMMapping JVM = new JVMMapping();
    private static final int DEFAULT_DRIVER = 0;
    private static Lock lock = new ReentrantLock();
    private static final int DEFAULT_BACKEND = 0;
    private static DebugContext debugContext = null;
    private static OptionValues options;
    private final JVMCIBackend vmBackend;
    private final HotSpotJVMCIRuntime vmRuntime;
    private final TornadoVMConfigAccess vmConfig;
    private final TornadoAcceleratorBackend[] tornadoVMBackends;
    private int backendCount;

    private TornadoCoreRuntime() {
        this.initOptions();
        GraalError.guarantee(((Boolean)GraalOptions.OmitHotExceptionStacktrace.getValue(options) == false ? 1 : 0) != 0, (String)"error");
        if (!(JVMCI.getRuntime() instanceof HotSpotJVMCIRuntime)) {
            TornadoInternalError.shouldNotReachHere((String)"Unsupported JVMCIRuntime: ", (Object[])new Object[]{JVMCI.getRuntime().getClass().getName()});
        }
        this.vmRuntime = (HotSpotJVMCIRuntime)JVMCI.getRuntime();
        this.vmBackend = this.vmRuntime.getHostJVMCIBackend();
        this.vmConfig = new TornadoVMConfigAccess(this.vmRuntime.getConfigStore(), this.vmBackend.getMetaAccess());
        this.tornadoVMBackends = this.loadBackends();
    }

    public static TornadoCoreRuntime getTornadoRuntime() {
        return runtime;
    }

    public static DebugContext getDebugContext() {
        lock.lock();
        if (debugContext == null) {
            debugContext = new DebugContext.Builder(TornadoCoreRuntime.getOptions(), (DebugHandlersFactory)new GraalDebugHandlersFactory((SnippetReflectionProvider)new TornadoSnippetReflectionProvider())).build();
        }
        lock.unlock();
        return debugContext;
    }

    public static ExecutorService getTornadoExecutor() {
        return EXECUTOR;
    }

    public static JVMCIBackend getVMBackend() {
        return TornadoCoreRuntime.runtime.vmBackend;
    }

    public static HotSpotJVMCIRuntime getVMRuntime() {
        return TornadoCoreRuntime.runtime.vmRuntime;
    }

    public static TornadoVMConfigAccess getVMConfig() {
        return TornadoCoreRuntime.runtime.vmConfig;
    }

    public static OptionValues getOptions() {
        return options;
    }

    private void initOptions() {
        EconomicMap opts = OptionValues.newOptionMap();
        opts.putAll(HotSpotGraalOptionValues.defaultOptions().getMap());
        opts.put((Object)GraalOptions.OmitHotExceptionStacktrace, (Object)false);
        opts.put((Object)GraalOptions.MatchExpressions, (Object)true);
        opts.put((Object)GraalOptions.RemoveNeverExecutedCode, (Object)false);
        opts.put((Object)ConstantLoadOptimization.Options.LIROptConstantLoadOptimization, (Object)false);
        opts.put((Object)PostAllocationOptimizationStage.Options.LIROptRedundantMoveElimination, (Object)false);
        opts.put((Object)GraalOptions.OptConvertDeoptsToGuards, (Object)true);
        options = new OptionValues((UnmodifiableEconomicMap)opts);
    }

    private TornadoAcceleratorBackend[] loadBackends() {
        ServiceLoader<TornadoBackendProvider> loader = ServiceLoader.load(TornadoBackendProvider.class);
        List providerList = StreamSupport.stream(loader.spliterator(), false).sorted().toList();
        TornadoAcceleratorBackend[] tornadoAcceleratorBackends = new TornadoAcceleratorBackend[TornadoBackends.values().length];
        int index = 0;
        for (TornadoBackendProvider provider : providerList) {
            TornadoAcceleratorBackend backend;
            if (TornadoOptions.FULL_DEBUG) {
                System.out.println("[INFO] TornadoVM Loading Backend: " + provider.getName());
            }
            if ((backend = provider.createBackend(options, this.vmRuntime, this.vmConfig)) == null) continue;
            tornadoAcceleratorBackends[index] = backend;
            ++index;
        }
        this.backendCount = index;
        return tornadoAcceleratorBackends;
    }

    public <D extends TornadoBackend> int getBackendIndex(Class<D> backendClass) {
        for (int backendIndex = 0; backendIndex < this.tornadoVMBackends.length; ++backendIndex) {
            if (this.tornadoVMBackends[backendIndex] == null || this.tornadoVMBackends[backendIndex].getClass() != backendClass) continue;
            return backendIndex;
        }
        throw TornadoInternalError.shouldNotReachHere((String)("Could not find index for backend: " + String.valueOf(backendClass)));
    }

    public boolean isProfilerEnabled() {
        return TornadoOptions.PROFILER_LOGS_ACCUMULATE() && TornadoOptions.isProfilerEnabled();
    }

    public boolean isPowerMonitoringEnabled() {
        return TornadoOptions.isUpsReaderEnabled();
    }

    public long getPowerMetric() {
        return UpsMeterReader.getOutputPowerMetric() != null ? Long.parseLong(UpsMeterReader.getOutputPowerMetric()) : -1L;
    }

    public MetaAccessProvider getMetaAccess() {
        return this.vmBackend.getMetaAccess();
    }

    public ResolvedJavaMethod resolveMethod(Method method) {
        return this.getMetaAccess().lookupJavaMethod((Executable)method);
    }

    public TornadoAcceleratorBackend getBackend(int index) {
        if (index > this.tornadoVMBackends.length) {
            throw new TornadoBackendNotFound("Tornado Backend Not Found");
        }
        return this.tornadoVMBackends[index];
    }

    public void setDefaultBackend(int index) {
        TornadoAcceleratorBackend tmp = this.tornadoVMBackends[0];
        this.tornadoVMBackends[0] = this.tornadoVMBackends[index];
        this.tornadoVMBackends[index] = tmp;
    }

    public <D extends TornadoBackend> D getBackend(Class<D> type) {
        for (TornadoAcceleratorBackend backend : this.tornadoVMBackends) {
            if (backend.getClass() != type) continue;
            return (D)backend;
        }
        return null;
    }

    public TornadoVMBackendType getBackendType(int index) {
        return this.tornadoVMBackends[index].getBackendType();
    }

    public int getNumBackends() {
        return this.backendCount;
    }

    public TornadoXPUDevice getDefaultDevice() {
        return this.tornadoVMBackends == null || this.tornadoVMBackends[0] == null ? JVM : (TornadoXPUDevice)this.tornadoVMBackends[0].getDefaultDevice();
    }
}

