/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime;

import java.util.BitSet;
import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.common.TornadoEvents;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;

public class EventSet
implements TornadoEvents {
    private final TornadoXPUDevice device;
    private final BitSet profiles;
    private int index;
    private Event event;
    private long executionPlanId;

    public EventSet(TornadoXPUDevice device, BitSet profiles, long executionPlanId) {
        this.device = device;
        this.profiles = profiles;
        this.executionPlanId = executionPlanId;
        this.index = profiles.nextSetBit(0);
        this.event = device.resolveEvent(executionPlanId, this.index);
    }

    public int cardinality() {
        return this.profiles.cardinality();
    }

    public void reset() {
        this.index = this.profiles.nextSetBit(0);
    }

    public boolean hasNext() {
        return this.index != -1;
    }

    public Event next() {
        if (this.index == -1) {
            return null;
        }
        this.event = this.device.resolveEvent(this.executionPlanId, this.index);
        this.index = this.profiles.nextSetBit(this.index);
        return this.event;
    }

    public TornadoXPUDevice getDevice() {
        return this.device;
    }

    public BitSet getProfiles() {
        return this.profiles;
    }
}

