/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.matrix;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;

public class SparseMatrixUtils {
    private static final boolean VERBOSE = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CSRMatrix<DoubleArray> loadMatrixD(String path) {
        boolean pattern = false;
        boolean symmetric = false;
        CSRMatrix<DoubleArray> mat = new CSRMatrix<DoubleArray>();
        Random rand = null;
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            String line = br.readLine();
            String[] opts = line.split(" ");
            if (!opts[1].equalsIgnoreCase("matrix")) {
                System.out.printf("Matrix file doesnot contain matrix\n", new Object[0]);
                br.close();
                CSRMatrix<DoubleArray> cSRMatrix = null;
                return cSRMatrix;
            }
            if (!opts[2].equalsIgnoreCase("coordinate")) {
                System.out.printf("Matrix representation is dense\n", new Object[0]);
                br.close();
                CSRMatrix<DoubleArray> cSRMatrix = null;
                return cSRMatrix;
            }
            if (opts[3].equalsIgnoreCase("pattern")) {
                pattern = true;
                rand = new Random();
            }
            if (opts[4].equalsIgnoreCase("symmetric")) {
                symmetric = true;
            }
            while ((line = br.readLine()) != null && line.startsWith("%")) {
            }
            opts = line.split(" ");
            int nRows = Integer.parseInt(opts[0]);
            int nCols = Integer.parseInt(opts[1]);
            int nElements = Integer.parseInt(opts[2]);
            class Coordinate
            implements Comparable<Coordinate> {
                int x;
                int y;
                float val;

                Coordinate(int a, int b, float c) {
                    this.x = a;
                    this.y = b;
                    this.val = c;
                }

                Coordinate(String[] opts) {
                    this.x = Integer.parseInt(opts[0]) - 1;
                    this.y = Integer.parseInt(opts[1]) - 1;
                    this.val = Float.parseFloat(opts[2]);
                }

                @Override
                public int compareTo(Coordinate c) {
                    int val = 0;
                    val = this.x != c.x ? this.x - c.x : this.y - c.y;
                    return val;
                }

                public String toString() {
                    return String.format("[ %d, %d, %10.2f ]", this.x, this.y, Float.valueOf(this.val));
                }
            }
            ArrayList<Coordinate> coords = symmetric ? new ArrayList(2 * nElements) : new ArrayList<Coordinate>(nElements);
            int index = 0;
            while ((line = br.readLine()) != null) {
                opts = line.split(" ");
                if (pattern) {
                    Coordinate c = new Coordinate(Integer.parseInt(opts[0]) - 1, Integer.parseInt(opts[1]) - 1, rand.nextFloat() * 256.0f);
                    coords.add(c);
                } else {
                    coords.add(new Coordinate(opts));
                }
                ++index;
                if (!symmetric) continue;
                Coordinate last = (Coordinate)coords.get(index - 1);
                if (last.x == last.y) continue;
                coords.add(new Coordinate(last.y, last.x, last.val));
                ++index;
            }
            Collections.sort(coords);
            mat.n = nElements = index;
            mat.size = nRows;
            mat.vals = new DoubleArray(nElements);
            mat.cols = new IntArray(nElements);
            mat.rows = new IntArray(nRows + 1);
            mat.rows.set(0, 0);
            mat.rows.set(nRows, nElements);
            int r = 0;
            for (int i = 0; i < nElements; ++i) {
                Coordinate c = (Coordinate)coords.get(i);
                while (c.x != r) {
                    mat.rows.set(++r, i);
                }
                ((DoubleArray)mat.vals).set(i, (double)c.val);
                mat.cols.set(i, c.y);
            }
            coords.clear();
            return mat;
        }
        catch (FileNotFoundException e) {
            System.out.printf("Unable to open matrix %s\n", path);
            return mat;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mat;
    }

    public static CSRMatrix<FloatArray> loadMatrixF(InputStream inStream) {
        CSRMatrix<FloatArray> cSRMatrix;
        BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        try {
            cSRMatrix = SparseMatrixUtils.loadMatrixF(br);
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.printf("unable to read matrix from input steam: %s\n", e.getMessage());
                e.printStackTrace();
                return null;
            }
        }
        br.close();
        return cSRMatrix;
    }

    public static CSRMatrix<FloatArray> loadMatrixF(String path) {
        CSRMatrix<FloatArray> cSRMatrix;
        BufferedReader br = new BufferedReader(new FileReader(path));
        try {
            cSRMatrix = SparseMatrixUtils.loadMatrixF(br);
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.printf("unable to read matrix from file: %s (%s)\n", path, e.getMessage());
                e.printStackTrace();
                return null;
            }
        }
        br.close();
        return cSRMatrix;
    }

    private static CSRMatrix<FloatArray> loadMatrixF(BufferedReader br) throws IOException {
        boolean pattern = false;
        boolean symmetric = false;
        CSRMatrix<FloatArray> mat = new CSRMatrix<FloatArray>();
        Random rand = null;
        String line = br.readLine();
        String[] opts = line.split(" ");
        if (!opts[1].equalsIgnoreCase("matrix")) {
            System.out.printf("Matrix file doesnot contain matrix\n", new Object[0]);
            br.close();
            return null;
        }
        if (!opts[2].equalsIgnoreCase("coordinate")) {
            System.out.printf("Matrix representation is dense\n", new Object[0]);
            br.close();
            return null;
        }
        if (opts[3].equalsIgnoreCase("pattern")) {
            pattern = true;
            rand = new Random();
            rand.setSeed(7L);
        }
        if (opts[4].equalsIgnoreCase("symmetric")) {
            symmetric = true;
        }
        while ((line = br.readLine()) != null && line.startsWith("%")) {
        }
        opts = line.split(" ");
        int nRows = Integer.parseInt(opts[0]);
        int nCols = Integer.parseInt(opts[1]);
        int nElements = Integer.parseInt(opts[2]);
        class Coordinate
        implements Comparable<Coordinate> {
            int x;
            int y;
            float val;

            Coordinate(int a, int b, float c) {
                this.x = a;
                this.y = b;
                this.val = c;
            }

            Coordinate(String[] opts) {
                this.x = Integer.parseInt(opts[0]) - 1;
                this.y = Integer.parseInt(opts[1]) - 1;
                this.val = Float.parseFloat(opts[2]);
            }

            @Override
            public int compareTo(Coordinate c) {
                int val = this.x != c.x ? this.x - c.x : this.y - c.y;
                return val;
            }

            public String toString() {
                return String.format("[ %d, %d, %10.2f ]", this.x, this.y, Float.valueOf(this.val));
            }
        }
        ArrayList<Coordinate> coords = symmetric ? new ArrayList(2 * nElements) : new ArrayList<Coordinate>(nElements);
        int index = 0;
        while ((line = br.readLine()) != null) {
            opts = line.split(" ");
            if (pattern) {
                Coordinate c = new Coordinate(Integer.parseInt(opts[0]) - 1, Integer.parseInt(opts[1]) - 1, rand.nextFloat() * 256.0f);
                coords.add(c);
            } else {
                coords.add(new Coordinate(opts));
            }
            ++index;
            if (!symmetric) continue;
            Coordinate last = (Coordinate)coords.get(index - 1);
            if (last.x == last.y) continue;
            coords.add(new Coordinate(last.y, last.x, last.val));
            ++index;
        }
        br.close();
        Collections.sort(coords);
        mat.n = nElements = index;
        mat.size = nRows;
        mat.vals = new FloatArray(nElements);
        mat.cols = new IntArray(nElements);
        mat.rows = new IntArray(nRows + 1);
        mat.rows.set(0, 0);
        mat.rows.set(nRows, nElements);
        int r = 0;
        for (int i = 0; i < nElements; ++i) {
            Coordinate c = (Coordinate)coords.get(i);
            while (c.x != r) {
                mat.rows.set(++r, i);
            }
            ((FloatArray)mat.vals).set(i, c.val);
            mat.cols.set(i, c.y);
        }
        coords.clear();
        return mat;
    }

    public static class CSRMatrix<T> {
        public int n;
        public int size;
        public T vals;
        public IntArray rows;
        public IntArray cols;
    }
}

